/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="StreamToString", summary="Calling toString on a Stream does not provide useful information", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class StreamToString
extends AbstractToString {
    static final TypePredicate STREAM = new TypePredicate(){

        public boolean apply(Type type, VisitorState state) {
            Type stream = state.getTypeFromString("java.util.stream.Stream");
            return ASTHelpers.isSubtype((Type)type, (Type)stream, (VisitorState)state);
        }
    };

    @Override
    protected TypePredicate typePredicate() {
        return STREAM;
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.absent();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.absent();
    }
}

