/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;

@BugPattern(name="UngroupedOverloads", summary="Constructors and methods with the same name should appear sequentially with no other code in between", generateExamplesFromTestCases=false, category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s3.4.2.1-overloads-never-split")
public class UngroupedOverloads
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final int DEFAULT_METHOD_COUNT_CUTOFF = 100;
    private final int methodCountCutoff;

    public UngroupedOverloads() {
        this(100);
    }

    UngroupedOverloads(int methodCountCutoff) {
        this.methodCountCutoff = methodCountCutoff;
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        ArrayList<? extends Tree> classMembers = new ArrayList<Tree>(classTree.getMembers());
        MethodFixSuggester suggester = new MethodFixSuggester(classTree, classMembers, state);
        long methodCount = classMembers.stream().filter(tree -> tree instanceof MethodTree).count();
        if (methodCount >= (long)this.methodCountCutoff) {
            UngroupedOverloads.checkMembers(classMembers, suggester);
        } else {
            UngroupedOverloads.orderMembers(classMembers, suggester);
        }
        return suggester.describeFix();
    }

    private static void checkMembers(List<? extends Tree> classMembers, MethodFixSuggester suggester) {
        LinkedHashMap<Name, Integer> previousOccurrences = new LinkedHashMap<Name, Integer>();
        for (int currentOccurrence = 0; currentOccurrence < classMembers.size(); ++currentOccurrence) {
            Tree memberTree = classMembers.get(currentOccurrence);
            if (!(memberTree instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)memberTree;
            Name methodName = methodTree.getName();
            Integer previousOccurrence = (Integer)previousOccurrences.get(methodName);
            if (previousOccurrence != null && previousOccurrence != currentOccurrence - 1) {
                suggester.justReport(currentOccurrence);
            }
            previousOccurrences.put(methodName, currentOccurrence);
        }
    }

    private static void orderMembers(List<? extends Tree> classMembers, MethodFixSuggester suggester) {
        LinkedHashMap<Name, Integer> previousOccurrences = new LinkedHashMap<Name, Integer>();
        for (int currentOccurrence = 0; currentOccurrence < classMembers.size(); ++currentOccurrence) {
            Tree memberTree = classMembers.get(currentOccurrence);
            if (!(memberTree instanceof MethodTree)) continue;
            MethodTree methodTree = (MethodTree)memberTree;
            Name methodName = methodTree.getName();
            Integer previousOccurrence = (Integer)previousOccurrences.get(methodName);
            if (previousOccurrence != null) {
                if (currentOccurrence - 1 > previousOccurrence) {
                    for (int i = currentOccurrence - 1; i > previousOccurrence; --i) {
                        Tree splitterTree = classMembers.get(i);
                        Name splitterName = UngroupedOverloads.getMemberName(splitterTree);
                        Integer splitterOccurrence = (Integer)previousOccurrences.get(splitterName);
                        if (splitterOccurrence != null && splitterOccurrence.equals(i)) {
                            previousOccurrences.put(splitterName, i + 1);
                        }
                        Collections.swap(classMembers, i, i + 1);
                    }
                    suggester.moveBlock(currentOccurrence);
                }
                previousOccurrences.put(methodName, previousOccurrence + 1);
                continue;
            }
            previousOccurrences.put(methodName, currentOccurrence);
        }
    }

    private static Name getMemberName(Tree memberTree) {
        if (memberTree instanceof ClassTree) {
            return ((ClassTree)memberTree).getSimpleName();
        }
        if (memberTree instanceof MethodTree) {
            return ((MethodTree)memberTree).getName();
        }
        if (memberTree instanceof VariableTree) {
            return ((VariableTree)memberTree).getName();
        }
        throw new AssertionError((Object)("expected member tree instead of " + (Object)((Object)memberTree.getKind())));
    }

    private static int getBroadStartPosition(VisitorState state, Tree current, Tree previous) {
        int previousEndPosition = UngroupedOverloads.getBroadEndPosition(state, previous, current);
        int currentStartPosition = ((JCTree)current).getStartPosition();
        return Math.min(previousEndPosition, currentStartPosition);
    }

    private static int getBroadEndPosition(VisitorState state, Tree current, @Nullable Tree next) {
        CharSequence source = state.getSourceCode();
        int currentEndPosition = state.getEndPosition(current);
        int nextStartPosition = next != null ? ((JCTree)next).getStartPosition() : source.length();
        String newline = System.lineSeparator();
        int newlinePosition = UngroupedOverloads.indexOf(source, newline, currentEndPosition, nextStartPosition);
        return newlinePosition < 0 ? currentEndPosition : newlinePosition;
    }

    private static int indexOf(CharSequence sequence, CharSequence term, int fromIndex, int toIndex) {
        int termLength = term.length();
        int index = fromIndex;
        while (index + termLength - 1 < toIndex) {
            int i;
            for (i = 0; i < termLength && sequence.charAt(index + i) == term.charAt(i); ++i) {
            }
            if (i == termLength) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static <K, V1, V2> ImmutableMap<K, V2> transformMap(Map<K, V1> input, Function<? super V1, ? extends V2> mapper) {
        return (ImmutableMap)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> mapper.apply((Object)entry.getValue())));
    }

    private static String getMethodFixMessage() {
        return "Overloaded versions of this method are not grouped together";
    }

    private static String getClassFixMessage(Collection<Name> methodNames) {
        String methods = methodNames.stream().map(methodName -> String.format("\"%s\"", methodName.toString())).sorted().collect(Collectors.joining(", "));
        return String.format("Overloaded methods (%s) of this class are not grouped together", methods);
    }

    private class MethodFixSuggester {
        private final ClassTree classTree;
        private final ImmutableList<? extends Tree> classMembers;
        private final VisitorState state;
        private final List<OverloadViolation> violations;

        public MethodFixSuggester(ClassTree classTree, List<? extends Tree> classMembers, VisitorState state) {
            this.classTree = classTree;
            this.classMembers = ImmutableList.copyOf(classMembers);
            this.state = state;
            this.violations = new ArrayList<OverloadViolation>();
        }

        public void justReport(int currentOccurrence) {
            this.violations.add(new JustReport((MethodTree)this.classMembers.get(currentOccurrence)));
        }

        public void moveBlock(int currentOccurrence) {
            MethodTree currentTree = (MethodTree)this.classMembers.get(currentOccurrence);
            Name currentName = currentTree.getName();
            Tree previousTree = (Tree)this.classMembers.get(currentOccurrence - 1);
            Tree nextTree = currentOccurrence + 1 < this.classMembers.size() ? (Tree)this.classMembers.get(currentOccurrence + 1) : null;
            int startPosition = UngroupedOverloads.getBroadStartPosition(this.state, currentTree, previousTree);
            int endPosition = UngroupedOverloads.getBroadEndPosition(this.state, currentTree, nextTree);
            this.violations.add(new MoveBlock(currentName, startPosition, endPosition));
        }

        public Description describeFix() {
            if (this.violations.isEmpty()) {
                return Description.NO_MATCH;
            }
            return this.buildAdaptedDescription().addFix((Fix)this.buildFix()).build();
        }

        private SuggestedFix buildFix() {
            ImmutableMap<Name, MethodTree> lastGroupedOccurrences = this.getLastGroupedOccurrences();
            SuggestedFix.Builder fix = SuggestedFix.builder();
            for (OverloadViolation violation : this.violations) {
                Name methodName = violation.getMethodName();
                violation.buildFix(fix, this.state, (MethodTree)lastGroupedOccurrences.get((Object)methodName));
            }
            return fix.build();
        }

        private Description.Builder buildAdaptedDescription() {
            ImmutableSet methodNames = (ImmutableSet)this.violations.stream().map(OverloadViolation::getMethodName).collect(ImmutableSet.toImmutableSet());
            if (methodNames.size() == 1) {
                return this.buildMethodDescription((Name)methodNames.iterator().next());
            }
            return this.buildClassDescription((Collection<Name>)methodNames);
        }

        private Description.Builder buildMethodDescription(Name methodName) {
            MethodTree methodTree = (MethodTree)this.getFirstOccurrences().get((Object)methodName);
            return UngroupedOverloads.this.buildDescription(methodTree).setMessage(UngroupedOverloads.getMethodFixMessage());
        }

        private Description.Builder buildClassDescription(Collection<Name> methodNames) {
            return UngroupedOverloads.this.buildDescription(this.classTree).setMessage(UngroupedOverloads.getClassFixMessage(methodNames));
        }

        private ImmutableMap<Name, MethodTree> getFirstOccurrences() {
            LinkedHashMap<Name, MethodTree> firstOccurrences = new LinkedHashMap<Name, MethodTree>();
            for (Tree memberTree : this.classMembers) {
                if (!(memberTree instanceof MethodTree)) continue;
                MethodTree methodTree = (MethodTree)memberTree;
                Name methodName = methodTree.getName();
                firstOccurrences.computeIfAbsent(methodName, __ -> methodTree);
            }
            return ImmutableMap.copyOf(firstOccurrences);
        }

        private ImmutableMap<Name, MethodTree> getLastGroupedOccurrences() {
            LinkedHashMap<Name, Integer> lastGroupedOccurrences = new LinkedHashMap<Name, Integer>();
            for (int i = 0; i < this.classMembers.size(); ++i) {
                MethodTree methodTree;
                Name methodName;
                Integer lastGroupedOccurrence;
                Tree memberTree = (Tree)this.classMembers.get(i);
                if (!(memberTree instanceof MethodTree) || (lastGroupedOccurrence = (Integer)lastGroupedOccurrences.get(methodName = (methodTree = (MethodTree)memberTree).getName())) != null && lastGroupedOccurrence + 1 != i) continue;
                lastGroupedOccurrences.put(methodName, i);
            }
            return UngroupedOverloads.transformMap(lastGroupedOccurrences, index -> (MethodTree)this.classMembers.get(index.intValue()));
        }
    }

    private static class MoveBlock
    implements OverloadViolation {
        private final Name methodName;
        private final int startPosition;
        private final int endPosition;

        public MoveBlock(Name methodName, int startPosition, int endPosition) {
            this.methodName = methodName;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        @Override
        public Name getMethodName() {
            return this.methodName;
        }

        @Override
        public void buildFix(SuggestedFix.Builder fix, VisitorState state, MethodTree target) {
            String methodSource = this.getMethodSource(state.getSourceCode());
            fix.replace(this.startPosition, this.endPosition, "");
            fix.postfixWith((Tree)target, methodSource);
        }

        public String getMethodSource(CharSequence sourceCode) {
            return sourceCode.subSequence(this.startPosition, this.endPosition).toString();
        }
    }

    private static class JustReport
    implements OverloadViolation {
        private final MethodTree methodTree;

        public JustReport(MethodTree methodTree) {
            this.methodTree = methodTree;
        }

        @Override
        public Name getMethodName() {
            return this.methodTree.getName();
        }

        @Override
        public void buildFix(SuggestedFix.Builder fix, VisitorState state, MethodTree target) {
        }
    }

    private static interface OverloadViolation {
        public Name getMethodName();

        public void buildFix(SuggestedFix.Builder var1, VisitorState var2, MethodTree var3);
    }
}

