/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.StringUtil;
import com.google.common.truth.SubjectUtils;
import com.google.common.truth.TestVerb;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import javax.annotation.Nullable;

public class Subject<S extends Subject<S, T>, T> {
    protected final FailureStrategy failureStrategy;
    private final T actual;
    private String customName = null;

    public Subject(FailureStrategy failureStrategy, @Nullable T actual) {
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        this.actual = actual;
    }

    protected String internalCustomName() {
        return this.customName;
    }

    @CanIgnoreReturnValue
    public S named(String format, Object ... args) {
        Preconditions.checkNotNull((Object)format, (Object)"Name passed to named() cannot be null.");
        this.customName = StringUtil.format(format, args);
        return (S)this;
    }

    public void isNull() {
        if (this.actual() != null) {
            this.fail("is null");
        }
    }

    public void isNotNull() {
        if (this.actual() == null) {
            this.failWithoutActual("is a non-null reference");
        }
    }

    public void isEqualTo(@Nullable Object other) {
        this.doEqualCheck(this.actual(), other, true);
    }

    public void isNotEqualTo(@Nullable Object other) {
        this.doEqualCheck(this.actual(), other, false);
    }

    private void doEqualCheck(@Nullable Object rawSubject, @Nullable Object rawOther, boolean expectEqual) {
        Object other;
        Object subject;
        if (Subject.isIntegralBoxedPrimitive(rawSubject) && Subject.isIntegralBoxedPrimitive(rawOther)) {
            subject = Subject.integralValue(rawSubject);
            other = Subject.integralValue(rawOther);
        } else {
            subject = rawSubject;
            other = rawOther;
        }
        if (Objects.equal((Object)subject, (Object)other) != expectEqual) {
            this.failComparingToStrings(expectEqual ? "is equal to" : "is not equal to", subject, other, rawOther, expectEqual);
        }
    }

    private static boolean isIntegralBoxedPrimitive(@Nullable Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Integer || o instanceof Long;
    }

    private static Long integralValue(Object o) {
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new AssertionError((Object)(o + " must be either a Character or a Number."));
    }

    public void isSameAs(@Nullable Object other) {
        if (this.actual() != other) {
            this.failComparingToStrings("is the same instance as", this.actual(), other, other, true);
        }
    }

    public void isNotSameAs(@Nullable Object other) {
        if (this.actual() == other) {
            this.fail("is not the same instance as", other);
        }
    }

    public void isInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (!Platform.isInstanceOfType(this.actual(), clazz)) {
            if (this.actual() != null) {
                if (Subject.classMetadataUnsupported()) {
                    throw new UnsupportedOperationException(this.actualAsString() + ", an instance of " + this.actual().getClass().getName() + ", may or may not be an instance of " + clazz.getName() + ". Under -XdisableClassMetadata, we do not have enough information to tell.");
                }
                this.failWithBadResults("is an instance of", clazz.getName(), "is an instance of", this.actual().getClass().getName());
            } else {
                this.fail("is an instance of", (Object)clazz.getName());
            }
        }
    }

    public void isNotInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (Subject.classMetadataUnsupported()) {
            throw new UnsupportedOperationException("isNotInstanceOf is not supported under -XdisableClassMetadata");
        }
        if (this.actual() == null) {
            return;
        }
        if (Platform.isInstanceOfType(this.actual(), clazz)) {
            this.failWithRawMessage("%s expected not to be an instance of %s, but was.", this.actualAsString(), clazz.getName());
        }
    }

    public void isIn(Iterable<?> iterable) {
        if (!Iterables.contains(iterable, this.actual())) {
            this.fail("is equal to any element in", (Object)iterable);
        }
    }

    public void isAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        List<Object> list = SubjectUtils.accumulate(first, second, rest);
        if (!list.contains(this.actual())) {
            this.fail("is equal to any of", (Object)list);
        }
    }

    public void isNotIn(Iterable<?> iterable) {
        int index = Iterables.indexOf(iterable, (Predicate)Predicates.equalTo(this.actual()));
        if (index != -1) {
            this.failWithRawMessage("Not true that %s is not in %s. It was found at index %s", this.actualAsString(), iterable, index);
        }
    }

    public void isNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.isNotIn(SubjectUtils.accumulate(first, second, rest));
    }

    @Deprecated
    protected T getSubject() {
        return this.actual;
    }

    protected final T actual() {
        return this.getSubject();
    }

    @Deprecated
    protected String getDisplaySubject() {
        String formatted = this.actualCustomStringRepresentation();
        if (this.customName != null) {
            return this.customName + (formatted.isEmpty() ? "" : " (<" + formatted + ">)");
        }
        return "<" + formatted + ">";
    }

    protected final String actualAsString() {
        return this.getDisplaySubject();
    }

    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actual());
    }

    protected TestVerb check() {
        return new TestVerb(this.failureStrategy);
    }

    protected final void fail(String proposition) {
        this.failureStrategy.fail("Not true that " + this.actualAsString() + " " + proposition);
    }

    protected final void fail(String verb, Object other) {
        this.failComparingToStrings(verb, this.actual(), other, other, false);
    }

    private void failComparingToStrings(String verb, Object subject, Object other, Object displayOther, boolean compareToStrings) {
        boolean needsClassDisambiguation;
        StringBuilder message = new StringBuilder("Not true that ").append(this.actualAsString()).append(" ");
        boolean neitherNull = other != null && subject != null;
        boolean sameToStrings = this.actualCustomStringRepresentation().equals(String.valueOf(other));
        boolean bl = needsClassDisambiguation = neitherNull && sameToStrings && !subject.getClass().equals(other.getClass());
        if (needsClassDisambiguation) {
            message.append("(").append(subject.getClass().getName()).append(") ");
        }
        message.append(verb).append(" <").append(displayOther).append(">");
        if (needsClassDisambiguation) {
            message.append(" (").append(other.getClass().getName()).append(")");
        }
        if (!needsClassDisambiguation && sameToStrings && compareToStrings) {
            message.append(" (although their toString() representations are the same)");
        }
        this.failureStrategy.fail(message.toString());
    }

    protected final void fail(String verb, Object ... messageParts) {
        if (messageParts.length == 0) {
            this.fail(verb);
        } else if (messageParts.length == 1) {
            this.fail(verb, messageParts[0]);
        } else {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append(this.actualAsString()).append(" ").append(verb);
            for (Object part : messageParts) {
                message.append(" <").append(part).append(">");
            }
            this.failureStrategy.fail(message.toString());
        }
    }

    protected final void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = StringUtil.format("Not true that %s %s <%s>. It %s <%s>", this.actualAsString(), verb, expected, failVerb, actual == null ? "null reference" : actual);
        this.failureStrategy.fail(message);
    }

    protected final void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = StringUtil.format("Not true that <%s> %s <%s>", actual == null ? "null reference" : actual, verb, expected);
        this.failureStrategy.fail(message);
    }

    @Deprecated
    protected final void failWithoutSubject(String proposition) {
        String strSubject = this.customName == null ? "the subject" : "\"" + this.customName + "\"";
        this.failureStrategy.fail(StringUtil.format("Not true that %s %s", strSubject, proposition));
    }

    protected final void failWithoutActual(String proposition) {
        this.failWithoutSubject(proposition);
    }

    protected void failWithRawMessage(String message, Object ... parameters) {
        this.failureStrategy.fail(StringUtil.format(message, parameters));
    }

    @Deprecated
    public final boolean equals(@Nullable Object o) {
        throw new UnsupportedOperationException("If you meant to test object equality, use .isEqualTo(other) instead.");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
    }

    private static boolean classMetadataUnsupported() {
        return String.class.getSuperclass() == null;
    }
}

