/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.AbstractContainerTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.google.TestMultimapGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@GwtCompatible
public abstract class AbstractMultimapTester<K, V, M extends Multimap<K, V>>
extends AbstractContainerTester<M, Map.Entry<K, V>> {
    private M multimap;

    protected M multimap() {
        return this.multimap;
    }

    protected Map.Entry<K, V>[] createArrayWithNullKey() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullKeyLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullKeyLocation];
        array[nullKeyLocation] = Helpers.mapEntry(null, oldEntry.getValue());
        return array;
    }

    protected Map.Entry<K, V>[] createArrayWithNullValue() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullValueLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullValueLocation];
        array[nullValueLocation] = Helpers.mapEntry(oldEntry.getKey(), null);
        return array;
    }

    protected Map.Entry<K, V>[] createArrayWithNullKeyAndValue() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullValueLocation = this.getNullLocation();
        array[nullValueLocation] = Helpers.mapEntry(null, null);
        return array;
    }

    protected V getValueForNullKey() {
        return this.getEntryNullReplaces().getValue();
    }

    protected K getKeyForNullValue() {
        return this.getEntryNullReplaces().getKey();
    }

    private Map.Entry<K, V> getEntryNullReplaces() {
        Iterator entries = this.getSampleElements().iterator();
        for (int i = 0; i < this.getNullLocation(); ++i) {
            entries.next();
        }
        return (Map.Entry)entries.next();
    }

    protected void initMultimapWithNullKey() {
        this.resetContainer((M)((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullKey())));
    }

    protected void initMultimapWithNullValue() {
        this.resetContainer((M)((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullValue())));
    }

    protected void initMultimapWithNullKeyAndValue() {
        this.resetContainer((M)((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullKeyAndValue())));
    }

    protected SampleElements<K> sampleKeys() {
        return ((TestMultimapGenerator)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getInnerGenerator()).sampleKeys();
    }

    protected SampleElements<V> sampleValues() {
        return ((TestMultimapGenerator)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getInnerGenerator()).sampleValues();
    }

    @Override
    protected Collection<Map.Entry<K, V>> actualContents() {
        return this.multimap.entries();
    }

    @Override
    protected M resetContainer(M newContents) {
        this.multimap = (Multimap)super.resetContainer(newContents);
        return this.multimap;
    }

    @Override
    protected Multimap<K, V> resetContainer(Map.Entry<K, V> ... newContents) {
        this.multimap = (Multimap)super.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(newContents));
        return this.multimap;
    }

    protected void resetCollection() {
        this.resetContainer();
    }

    protected void assertGet(K key, V ... values) {
        this.assertGet(key, (Collection<V>)Arrays.asList(values));
    }

    protected void assertGet(K key, Collection<V> values) {
        Helpers.assertEqualIgnoringOrder(values, this.multimap().get(key));
        if (!values.isEmpty()) {
            Helpers.assertEqualIgnoringOrder(values, (Iterable)this.multimap().asMap().get(key));
            AbstractMultimapTester.assertFalse((boolean)this.multimap().isEmpty());
        } else {
            AbstractMultimapTester.assertNull(this.multimap().asMap().get(key));
        }
        AbstractMultimapTester.assertEquals((int)values.size(), (int)this.multimap().get(key).size());
        AbstractMultimapTester.assertEquals((values.size() > 0 ? 1 : 0) != 0, (boolean)this.multimap().containsKey(key));
        AbstractMultimapTester.assertEquals((values.size() > 0 ? 1 : 0) != 0, (boolean)this.multimap().keySet().contains(key));
        AbstractMultimapTester.assertEquals((values.size() > 0 ? 1 : 0) != 0, (boolean)this.multimap().keys().contains(key));
    }

    protected final K k0() {
        return ((Map.Entry)this.e0()).getKey();
    }

    protected final V v0() {
        return ((Map.Entry)this.e0()).getValue();
    }

    protected final K k1() {
        return ((Map.Entry)this.e1()).getKey();
    }

    protected final V v1() {
        return ((Map.Entry)this.e1()).getValue();
    }

    protected final K k2() {
        return ((Map.Entry)this.e2()).getKey();
    }

    protected final V v2() {
        return ((Map.Entry)this.e2()).getValue();
    }

    protected final K k3() {
        return ((Map.Entry)this.e3()).getKey();
    }

    protected final V v3() {
        return ((Map.Entry)this.e3()).getValue();
    }

    protected final K k4() {
        return ((Map.Entry)this.e4()).getKey();
    }

    protected final V v4() {
        return ((Map.Entry)this.e4()).getValue();
    }
}

