/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import org.objectweb.asm.MethodVisitor;

public class TextConstant
implements StackManipulation {
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final String text;

    public TextConstant(String text) {
        this.text = text;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn((Object)this.text);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.text.equals(((TextConstant)other).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        return "TextConstant{text='" + this.text + '\'' + '}';
    }
}

