/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.InternalUtils;

public class PurityUtils {
    public static boolean hasPurityAnnotation(AnnotationProvider provider, MethodTree tree) {
        return !PurityUtils.getPurityKinds(provider, tree).isEmpty();
    }

    public static boolean hasPurityAnnotation(AnnotationProvider provider, Element methodElement) {
        return !PurityUtils.getPurityKinds(provider, methodElement).isEmpty();
    }

    public static boolean isDeterministic(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = InternalUtils.symbol((Tree)tree);
        return PurityUtils.isDeterministic(provider, methodElement);
    }

    public static boolean isDeterministic(AnnotationProvider provider, Element methodElement) {
        List<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.DETERMINISTIC);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = InternalUtils.symbol((Tree)tree);
        return PurityUtils.isSideEffectFree(provider, methodElement);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, Element methodElement) {
        List<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains((Object)Pure.Kind.SIDE_EFFECT_FREE);
    }

    public static List<Pure.Kind> getPurityKinds(AnnotationProvider provider, MethodTree tree) {
        Element methodElement = InternalUtils.symbol((Tree)tree);
        return PurityUtils.getPurityKinds(provider, methodElement);
    }

    public static List<Pure.Kind> getPurityKinds(AnnotationProvider provider, Element methodElement) {
        AnnotationMirror pureAnnotation = provider.getDeclAnnotation(methodElement, Pure.class);
        AnnotationMirror sefAnnotation = provider.getDeclAnnotation(methodElement, SideEffectFree.class);
        AnnotationMirror detAnnotation = provider.getDeclAnnotation(methodElement, Deterministic.class);
        ArrayList<Pure.Kind> kinds = new ArrayList<Pure.Kind>();
        if (pureAnnotation != null) {
            kinds.add(Pure.Kind.DETERMINISTIC);
            kinds.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (sefAnnotation != null) {
            kinds.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (detAnnotation != null) {
            kinds.add(Pure.Kind.DETERMINISTIC);
        }
        return kinds;
    }
}

