/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.Tree;

@BugPattern(name="AssertFalse", summary="Assertions may be disabled at runtime and do not guarantee that execution will halt here; consider throwing an exception instead", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class AssertFalse
extends BugChecker
implements BugChecker.AssertTreeMatcher {
    private static final Matcher<AssertTree> ASSERT_FALSE_MATCHER = Matchers.assertionWithCondition((Matcher)Matchers.booleanLiteral((boolean)false));

    public Description matchAssert(AssertTree tree, VisitorState state) {
        if (!ASSERT_FALSE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)"throw new AssertionError()"));
    }
}

