/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="JodaDurationConstructor", summary="Use of new Duration(long) is not allowed. Please use Duration.millis(long) instead.", explanation="Joda-Time's 'new Duration(long)' constructor is ambiguous with respect to time units and is frequently a source of bugs. Please use Duration.millis(long) instead. If your Duration is better expressed in terms of other units, use standardSeconds(long), standardMinutes(long), standardHours(long), or standardDays(long) instead.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class JodaDurationConstructor
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("org.joda.time.Duration").withParameters(new String[]{"int"}), Matchers.constructor().forClass("org.joda.time.Duration").withParameters(new String[]{"long"})}), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree millisArg = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        SuggestedFix fix = SuggestedFix.replace((int)((JCTree)((Object)tree)).getStartPosition(), (int)((JCTree)((Object)millisArg)).getStartPosition(), (String)(state.getSourceForNode((Tree)tree.getIdentifier()) + ".millis("));
        return this.describeMatch(tree, (Fix)fix);
    }
}

