/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.stream.Stream;

@BugPattern(name="JodaToSelf", summary="Use of Joda-Time's DateTime.toDateTime(), Duration.toDuration(), Instant.toInstant(), Interval.toInterval(), and Period.toPeriod() are not allowed.", explanation="Joda-Time's DateTime.toDateTime(), Duration.toDuration(), Instant.toInstant(), Interval.toInterval(), and Period.toPeriod() are always unnecessary, since they simply 'return this'. There is no reason to ever call them.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class JodaToSelf
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final ImmutableSet<String> TYPE_NAMES = ImmutableSet.of((Object)"DateTime", (Object)"Duration", (Object)"Instant", (Object)"Interval", (Object)"Period");
    private static final ImmutableSet<String> TYPES_WITHOUT_METHOD = ImmutableSet.of((Object)"LocalDate", (Object)"LocalDateTime", (Object)"LocalTime");
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Iterable)((Iterable)TYPE_NAMES.stream().map(typeName -> Matchers.instanceMethod().onExactClass("org.joda.time." + typeName).named("to" + typeName).withParameters(new String[0])).collect(ImmutableList.toImmutableList()))), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});
    private static final Matcher<ExpressionTree> CONSTRUCTOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Iterable)((Iterable)Streams.concat((Stream[])new Stream[]{TYPE_NAMES.stream(), TYPES_WITHOUT_METHOD.stream()}).map(typeName -> Matchers.constructor().forClass("org.joda.time." + typeName).withParameters(new String[]{"java.lang.Object"})).collect(ImmutableList.toImmutableList()))), Matchers.not((Matcher)Matchers.packageStartsWith((String)"org.joda.time"))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Use of %s is a no-op and is not allowed.", ASTHelpers.getSymbol((MethodInvocationTree)tree))).addFix((Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), (int)state.getEndPosition((Tree)tree), (String)"")).build();
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)ASTHelpers.getType((Tree)tree.getIdentifier()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Use of %s is a no-op and is not allowed.", ASTHelpers.getSymbol((NewClassTree)tree))).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)argument))).build();
    }
}

