/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class AllowAllHostnameVerifierDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AllowAllHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"AllowAllHostnameVerifier", (String)"Insecure HostnameVerifier", (String)"This check looks for use of HostnameVerifier implementations whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList("org.apache.http.conn.ssl.AllowAllHostnameVerifier");
    }

    public void visitConstructor(JavaContext context, AstVisitor visitor, ConstructorInvocation node, JavaParser.ResolvedMethod constructor) {
        Location location = context.getLocation((Node)node);
        context.report(ISSUE, (Node)node, location, "Using the AllowAllHostnameVerifier HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames");
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("setHostnameVerifier", "setDefaultHostnameVerifier");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        JavaParser.ResolvedField field;
        Expression argument;
        JavaParser.ResolvedNode resolvedArgument;
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod && (method = (JavaParser.ResolvedMethod)resolved).getArgumentCount() == 1 && node.astArguments().size() == 1 && method.getArgumentType(0).matchesName("javax.net.ssl.HostnameVerifier") && (resolvedArgument = context.resolve((Node)(argument = (Expression)node.astArguments().first()))) instanceof JavaParser.ResolvedField && (field = (JavaParser.ResolvedField)resolvedArgument).getName().equals("ALLOW_ALL_HOSTNAME_VERIFIER")) {
            Location location = context.getLocation((Node)argument);
            String message = "Using the ALLOW_ALL_HOSTNAME_VERIFIER HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames";
            context.report(ISSUE, (Node)argument, location, message);
        }
    }
}

