/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.unsafe.UnsafeProvider;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import sun.reflect.ReflectionFactory;

public class DynamicCodec
implements ObjectCodec<Object> {
    private static final Logger logger = Logger.getLogger(DynamicCodec.class.getName());
    private final Class<?> type;
    private final Constructor<?> constructor;
    private final TypeAndOffset[] offsets;

    public DynamicCodec(Class<?> type) throws ReflectiveOperationException {
        this.type = type;
        this.constructor = DynamicCodec.getConstructor(type);
        this.offsets = DynamicCodec.getOffsets(type);
    }

    @Override
    public Class<?> getEncodedClass() {
        return this.type;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.MEMOIZE_BEFORE;
    }

    @Override
    public void serialize(SerializationContext context, Object obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.serializeField(context, codedOut, obj, this.offsets[i].type, this.offsets[i].offset);
        }
    }

    private void serializeField(SerializationContext context, CodedOutputStream codedOut, Object obj, Class<?> type, long offset) throws SerializationException, IOException {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                codedOut.writeBoolNoTag(UnsafeProvider.getInstance().getBoolean(obj, offset));
            } else if (type.equals(Byte.TYPE)) {
                codedOut.writeRawByte(UnsafeProvider.getInstance().getByte(obj, offset));
            } else if (type.equals(Short.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).putShort(UnsafeProvider.getInstance().getShort(obj, offset));
                codedOut.writeRawBytes(buffer);
            } else if (type.equals(Character.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).putChar(UnsafeProvider.getInstance().getChar(obj, offset));
                codedOut.writeRawBytes(buffer);
            } else if (type.equals(Integer.TYPE)) {
                codedOut.writeInt32NoTag(UnsafeProvider.getInstance().getInt(obj, offset));
            } else if (type.equals(Long.TYPE)) {
                codedOut.writeInt64NoTag(UnsafeProvider.getInstance().getLong(obj, offset));
            } else if (type.equals(Float.TYPE)) {
                codedOut.writeFloatNoTag(UnsafeProvider.getInstance().getFloat(obj, offset));
            } else if (type.equals(Double.TYPE)) {
                codedOut.writeDoubleNoTag(UnsafeProvider.getInstance().getDouble(obj, offset));
            } else if (!type.equals(Void.TYPE)) {
                throw new UnsupportedOperationException("Unknown primitive type: " + type);
            }
        } else if (type.isArray()) {
            Object arr = UnsafeProvider.getInstance().getObject(obj, offset);
            if (type.getComponentType().equals(Byte.TYPE)) {
                if (arr == null) {
                    codedOut.writeBoolNoTag(false);
                } else {
                    codedOut.writeBoolNoTag(true);
                    codedOut.writeByteArrayNoTag((byte[])arr);
                }
                return;
            }
            if (arr == null) {
                codedOut.writeInt32NoTag(-1);
                return;
            }
            int length = Array.getLength(arr);
            codedOut.writeInt32NoTag(length);
            int base = UnsafeProvider.getInstance().arrayBaseOffset(type);
            int scale = UnsafeProvider.getInstance().arrayIndexScale(type);
            if (scale == 0) {
                throw new SerializationException("Failed to get index scale for type: " + type);
            }
            for (int i = 0; i < length; ++i) {
                this.serializeField(context, codedOut, arr, type.getComponentType(), base + scale * i);
            }
        } else {
            try {
                context.serialize(UnsafeProvider.getInstance().getObject(obj, offset), codedOut);
            }
            catch (SerializationException e) {
                logger.severe(String.format("Unserializable object and superclass: %s %s", obj, obj.getClass().getSuperclass()));
                e.addTrail(this.type);
                throw e;
            }
        }
    }

    @Override
    public Object deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Object instance;
        try {
            instance = this.constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Could not instantiate object of type: " + this.type, e);
        }
        context.registerInitialValue(instance);
        for (int i = 0; i < this.offsets.length; ++i) {
            this.deserializeField(context, codedIn, instance, this.offsets[i].type, this.offsets[i].offset);
        }
        return instance;
    }

    private void deserializeField(DeserializationContext context, CodedInputStream codedIn, Object obj, Class<?> type, long offset) throws SerializationException, IOException {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                UnsafeProvider.getInstance().putBoolean(obj, offset, codedIn.readBool());
            } else if (type.equals(Byte.TYPE)) {
                UnsafeProvider.getInstance().putByte(obj, offset, codedIn.readRawByte());
            } else if (type.equals(Short.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).put(codedIn.readRawBytes(2));
                UnsafeProvider.getInstance().putShort(obj, offset, buffer.getShort(0));
            } else if (type.equals(Character.TYPE)) {
                ByteBuffer buffer = ByteBuffer.allocate(2).put(codedIn.readRawBytes(2));
                UnsafeProvider.getInstance().putChar(obj, offset, buffer.getChar(0));
            } else if (type.equals(Integer.TYPE)) {
                UnsafeProvider.getInstance().putInt(obj, offset, codedIn.readInt32());
            } else if (type.equals(Long.TYPE)) {
                UnsafeProvider.getInstance().putLong(obj, offset, codedIn.readInt64());
            } else if (type.equals(Float.TYPE)) {
                UnsafeProvider.getInstance().putFloat(obj, offset, codedIn.readFloat());
            } else if (type.equals(Double.TYPE)) {
                UnsafeProvider.getInstance().putDouble(obj, offset, codedIn.readDouble());
            } else if (!type.equals(Void.TYPE)) {
                throw new UnsupportedOperationException("Unknown primitive type: " + type);
            }
        } else if (type.isArray()) {
            if (type.getComponentType().equals(Byte.TYPE)) {
                boolean isNonNull = codedIn.readBool();
                UnsafeProvider.getInstance().putObject(obj, offset, isNonNull ? codedIn.readByteArray() : null);
                return;
            }
            int length = codedIn.readInt32();
            if (length < 0) {
                UnsafeProvider.getInstance().putObject(obj, offset, null);
                return;
            }
            Object arr = Array.newInstance(type.getComponentType(), length);
            UnsafeProvider.getInstance().putObject(obj, offset, arr);
            int base = UnsafeProvider.getInstance().arrayBaseOffset(type);
            int scale = UnsafeProvider.getInstance().arrayIndexScale(type);
            if (scale == 0) {
                throw new SerializationException("Failed to get index scale for type: " + type);
            }
            for (int i = 0; i < length; ++i) {
                this.deserializeField(context, codedIn, arr, type.getComponentType(), base + scale * i);
            }
        } else {
            UnsafeProvider.getInstance().putObject(obj, offset, context.deserialize(codedIn));
        }
    }

    private static <T> TypeAndOffset[] getOffsets(Class<T> type) {
        TreeMap<Field, Long> offsets = new TreeMap<Field, Long>(new FieldComparator());
        for (Class<T> next = type; next != null; next = next.getSuperclass()) {
            for (Field field : next.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0) continue;
                field.setAccessible(true);
                offsets.put(field, UnsafeProvider.getInstance().objectFieldOffset(field));
            }
        }
        TypeAndOffset[] offsetsArr = new TypeAndOffset[offsets.size()];
        int i = 0;
        for (Map.Entry entry : offsets.entrySet()) {
            offsetsArr[i] = new TypeAndOffset(entry.getKey().getType(), (Long)entry.getValue());
            ++i;
        }
        return offsetsArr;
    }

    private static Constructor<?> getConstructor(Class<?> type) throws ReflectiveOperationException {
        Constructor<?> constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(type, Object.class.getDeclaredConstructor(new Class[0]));
        constructor.setAccessible(true);
        return constructor;
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f1, Field f2) {
            int classCompare = f1.getDeclaringClass().getName().compareTo(f2.getDeclaringClass().getName());
            if (classCompare != 0) {
                return classCompare;
            }
            return f1.getName().compareTo(f2.getName());
        }
    }

    private static class TypeAndOffset {
        public final Class<?> type;
        public final long offset;

        public TypeAndOffset(Class<?> type, long offset) {
            this.type = type;
            this.offset = offset;
        }
    }
}

