/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Catch;
import lombok.ast.ConstructorInvocation;
import lombok.ast.EnumConstant;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StringLiteral;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SupportAnnotationDetector
extends Detector
implements Detector.JavaScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RANGE = Issue.create((String)"Range", (String)"Outside Range", (String)"Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create((String)"ResourceType", (String)"Wrong Resource Type", (String)"Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create((String)"ResourceAsColor", (String)"Should pass resolved color instead of resource id", (String)"Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create((String)"WrongConstant", (String)"Incorrect constant", (String)"Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", (Category)Category.SECURITY, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create((String)"CheckResult", (String)"Ignoring results", (String)"Some methods have no side effects, an calling them without doing something without the result is suspicious. ", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create((String)"UseCheckPermission", (String)"Using the result of check permission calls", (String)"You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create((String)"MissingPermission", (String)"Missing Permissions", (String)"This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue THREAD = Issue.create((String)"WrongThread", (String)"Wrong Thread", (String)"Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String PERMISSION_ANNOTATION_READ = "android.support.annotation.RequiresPermission.Read";
    public static final String PERMISSION_ANNOTATION_WRITE = "android.support.annotation.RequiresPermission.Write";
    public static final String RES_SUFFIX = "Res";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    private PermissionHolder mPermissions;

    private void checkMethodAnnotation(JavaContext context, JavaParser.ResolvedMethod method, Node node, JavaParser.ResolvedAnnotation annotation) {
        String signature = annotation.getSignature();
        if (CHECK_RESULT_ANNOTATION.equals(signature) || signature.endsWith(".CheckReturnValue")) {
            SupportAnnotationDetector.checkResult(context, node, annotation);
        } else if (signature.equals(PERMISSION_ANNOTATION)) {
            PermissionRequirement requirement = PermissionRequirement.create((Context)context, annotation);
            this.checkPermission(context, node, method, null, requirement);
        } else if (signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.")) {
            SupportAnnotationDetector.checkThreading(context, node, method, signature);
        }
    }

    private void checkParameterAnnotations(JavaContext context, Node argument, Node call, JavaParser.ResolvedMethod method, Iterable<JavaParser.ResolvedAnnotation> annotations) {
        boolean handledResourceTypes = false;
        for (JavaParser.ResolvedAnnotation annotation : annotations) {
            String signature = annotation.getSignature();
            if (COLOR_INT_ANNOTATION.equals(signature)) {
                SupportAnnotationDetector.checkColor(context, argument);
                continue;
            }
            if (signature.equals(INT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkIntRange(context, annotation, argument, annotations);
                continue;
            }
            if (signature.equals(FLOAT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkFloatRange(context, annotation, argument);
                continue;
            }
            if (signature.equals(SIZE_ANNOTATION)) {
                SupportAnnotationDetector.checkSize(context, annotation, argument);
                continue;
            }
            if (signature.startsWith(PERMISSION_ANNOTATION)) {
                this.checkParameterPermission(context, signature, call, method, argument);
                continue;
            }
            if (signature.equals("android.support.annotation.IntDef")) {
                boolean flag = annotation.getValue("flag") == Boolean.TRUE;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, flag, annotations);
                continue;
            }
            if (signature.equals("android.support.annotation.StringDef")) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, false, annotations);
                continue;
            }
            if (!signature.endsWith(RES_SUFFIX) || handledResourceTypes) continue;
            handledResourceTypes = true;
            EnumSet<ResourceType> types = null;
            for (JavaParser.ResolvedAnnotation a : annotations) {
                String s = a.getSignature();
                if (!s.endsWith(RES_SUFFIX)) continue;
                String typeString = s.substring("android.support.annotation.".length(), s.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
                ResourceType type = ResourceType.getEnum((String)typeString);
                if (type != null) {
                    if (types == null) {
                        types = EnumSet.of(type);
                        continue;
                    }
                    types.add(type);
                    continue;
                }
                if (!typeString.equals("any")) continue;
                types = SupportAnnotationDetector.getAnyRes();
                break;
            }
            if (types == null) continue;
            SupportAnnotationDetector.checkResourceType(context, argument, types);
        }
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(COLOR_INT_MARKER_TYPE);
        return types;
    }

    private void checkParameterPermission(JavaContext context, String signature, Node call, JavaParser.ResolvedMethod method, Node argument) {
        PermissionFinder.Operation operation = null;
        if (signature.equals(PERMISSION_ANNOTATION_READ)) {
            operation = PermissionFinder.Operation.READ;
        } else if (signature.equals(PERMISSION_ANNOTATION_WRITE)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            JavaParser.TypeDescriptor type = context.getType(argument);
            if (type == null) {
                return;
            }
            if (type.matchesSignature("android.content.Intent")) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(operation, context, argument);
        if (result != null) {
            this.checkPermission(context, call, method, result, result.requirement);
        }
    }

    private static void checkColor(JavaContext context, Node argument) {
        if (argument instanceof InlineIfExpression) {
            InlineIfExpression expression = (InlineIfExpression)argument;
            SupportAnnotationDetector.checkColor(context, (Node)expression.astIfTrue());
            SupportAnnotationDetector.checkColor(context, (Node)expression.astIfFalse());
            return;
        }
        EnumSet<ResourceType> types = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (types != null && types.contains(ResourceType.COLOR) && !SupportAnnotationDetector.isIgnoredInIde(COLOR_USAGE, context, argument)) {
            String message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString());
            context.report(COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private static boolean isIgnoredInIde(Issue issue, JavaContext context, Node node) {
        Issue synonym = Issue.create((String)"ResourceType", (String)issue.getBriefDescription(TextFormat.RAW), (String)issue.getExplanation(TextFormat.RAW), (Category)issue.getCategory(), (int)issue.getPriority(), (Severity)issue.getDefaultSeverity(), (Implementation)issue.getImplementation());
        return context.getDriver().isSuppressed(context, synonym, node);
    }

    private void checkPermission(JavaContext context, Node node, JavaParser.ResolvedMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(context, permissions, node))) {
                PermissionFinder.Operation operation;
                String name;
                if (SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                    return;
                }
                if (result != null) {
                    name = result.name;
                    operation = result.operation;
                } else {
                    assert (method != null);
                    name = method.getContainingClass().getSimpleName() + "." + method.getName();
                    operation = PermissionFinder.Operation.CALL;
                }
                String message = SupportAnnotationDetector.getMissingPermissionMessage(requirement, name, permissions, operation);
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message);
            }
        } else if (requirement.isRevocable(permissions) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            Node methodNode;
            MethodDeclaration declaration;
            Try tryCatch;
            boolean handlesMissingPermission = false;
            Node parent = node;
            while ((tryCatch = (Try)JavaContext.getParentOfType((Node)parent, Try.class)) != null) {
                JavaParser parser = context.getParser();
                block1: for (Catch aCatch : tryCatch.astCatches()) {
                    for (JavaParser.TypeDescriptor catchType : parser.getCatchTypes(context, aCatch)) {
                        if (!SupportAnnotationDetector.isSecurityException(context, catchType)) continue;
                        handlesMissingPermission = true;
                        continue block1;
                    }
                }
                parent = tryCatch;
            }
            if (!handlesMissingPermission && (declaration = (MethodDeclaration)JavaContext.getParentOfType((Node)parent, MethodDeclaration.class)) != null) {
                for (TypeReference typeReference : declaration.astThrownTypeReferences()) {
                    if (!SupportAnnotationDetector.isSecurityException(context, context.getType((Node)typeReference))) continue;
                    handlesMissingPermission = true;
                    break;
                }
            }
            if (!handlesMissingPermission && (methodNode = JavaContext.findSurroundingMethod((Node)node)) != null) {
                CheckPermissionVisitor visitor = new CheckPermissionVisitor(node);
                methodNode.accept((AstVisitor)visitor);
                handlesMissingPermission = visitor.checksPermission();
            }
            if (!handlesMissingPermission && !SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                String message = SupportAnnotationDetector.getUnhandledPermissionMessage();
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message);
            }
        }
    }

    private static PermissionHolder addLocalPermissions(JavaContext context, PermissionHolder permissions, Node node) {
        Node methodNode = JavaContext.findSurroundingMethod((Node)node);
        if (methodNode == null) {
            return permissions;
        }
        JavaParser.ResolvedNode resolved = context.resolve(methodNode);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return permissions;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        JavaParser.ResolvedAnnotation annotation = method.getAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        annotation = method.getContainingClass().getAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        return permissions;
    }

    private static PermissionHolder mergeAnnotationPermissions(JavaContext context, PermissionHolder permissions, JavaParser.ResolvedAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create((Context)context, annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    public static String getMissingPermissionMessage(PermissionRequirement requirement, String callName, PermissionHolder permissions, PermissionFinder.Operation operation) {
        return String.format("Missing permissions required %1$s %2$s: %3$s", operation.prefix(), callName, requirement.describeMissingPermissions(permissions));
    }

    public static String getUnhandledPermissionMessage() {
        return "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
    }

    private static boolean isSecurityException(JavaContext context, JavaParser.TypeDescriptor type) {
        return type != null && type.matchesSignature("java.lang.SecurityException");
    }

    private PermissionHolder getPermissions(JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            LintClient client = context.getClient();
            Project mainProject = context.getMainProject();
            for (File manifest : mainProject.getManifestFiles()) {
                SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
            }
            for (Project library : mainProject.getAllLibraries()) {
                for (File manifest : library.getManifestFiles()) {
                    SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
                }
            }
            AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
            AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
        }
        return this.mPermissions;
    }

    private static void addPermissions(LintClient client, Set<String> permissions, Set<String> revocable, File manifest) {
        Document document = XmlUtils.parseDocumentSilently((String)client.readFile(manifest), (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name;
            String protectionLevel;
            Element element;
            org.w3c.dom.Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission") || nodeName.equals("uses-permission-sdk-23") || nodeName.equals("uses-permission-sdk-m")) {
                element = (Element)item;
                String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name2.isEmpty()) continue;
                permissions.add(name2);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name);
        }
    }

    private static void checkResult(JavaContext context, Node node, JavaParser.ResolvedAnnotation annotation) {
        if (node.getParent() instanceof ExpressionStatement) {
            String methodName = JavaContext.getMethodName((Node)node);
            Object suggested = annotation.getValue(ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName != null && methodName.startsWith("check") && methodName.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(issue, context, node)) {
                return;
            }
            String message = String.format("The result of `%1$s` is not used", methodName);
            if (suggested != null) {
                message = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName, suggested.toString());
            }
            context.report(issue, node, context.getLocation(node), message);
        }
    }

    private static void checkThreading(JavaContext context, Node node, JavaParser.ResolvedMethod method, String annotation) {
        String threadContext = SupportAnnotationDetector.getThreadContext(context, node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, annotation) && !SupportAnnotationDetector.isIgnoredInIde(THREAD, context, node)) {
            String message = String.format("Method %1$s must be called from the `%2$s` thread, currently inferred thread is `%3$s` thread", method.getName(), SupportAnnotationDetector.describeThread(annotation), SupportAnnotationDetector.describeThread(threadContext));
            context.report(THREAD, node, context.getLocation(node), message);
        }
    }

    public static String describeThread(String annotation) {
        if (UI_THREAD_ANNOTATION.equals(annotation)) {
            return "UI";
        }
        if (MAIN_THREAD_ANNOTATION.equals(annotation)) {
            return "main";
        }
        if (BINDER_THREAD_ANNOTATION.equals(annotation)) {
            return "binder";
        }
        if (WORKER_THREAD_ANNOTATION.equals(annotation)) {
            return "worker";
        }
        return "other";
    }

    public static boolean isCompatibleThread(String thread1, String thread2) {
        if (thread1.equals(thread2)) {
            return true;
        }
        return thread1.equals(UI_THREAD_ANNOTATION) ? thread2.equals(MAIN_THREAD_ANNOTATION) : thread1.equals(MAIN_THREAD_ANNOTATION) && thread2.equals(UI_THREAD_ANNOTATION);
    }

    private static String getThreadContext(JavaContext context, Node methodCall) {
        JavaParser.ResolvedNode resolved;
        Node node = JavaContext.findSurroundingMethod((Node)methodCall);
        if (node != null && (resolved = context.resolve(node)) instanceof JavaParser.ResolvedMethod) {
            String name;
            JavaParser.ResolvedMethod method;
            JavaParser.ResolvedClass cls = method.getContainingClass();
            for (method = (JavaParser.ResolvedMethod)resolved; method != null; method = method.getSuperMethod()) {
                for (JavaParser.ResolvedAnnotation annotation : method.getAnnotations()) {
                    name = annotation.getSignature();
                    if (!name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    return name;
                }
            }
            while (cls != null) {
                for (JavaParser.ResolvedAnnotation annotation : cls.getAnnotations()) {
                    name = annotation.getSignature();
                    if (!name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    return name;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private static boolean isNumber(Node argument) {
        return argument instanceof IntegralLiteral || argument instanceof UnaryExpression && ((UnaryExpression)argument).astOperator() == UnaryOperator.UNARY_MINUS && ((UnaryExpression)argument).astOperand() instanceof IntegralLiteral;
    }

    private static boolean isZero(Node argument) {
        return argument instanceof IntegralLiteral && ((IntegralLiteral)argument).astIntValue() == 0;
    }

    private static boolean isMinusOne(Node argument) {
        return argument instanceof UnaryExpression && ((UnaryExpression)argument).astOperator() == UnaryOperator.UNARY_MINUS && ((UnaryExpression)argument).astOperand() instanceof IntegralLiteral && ((IntegralLiteral)((UnaryExpression)argument).astOperand()).astIntValue() == 1;
    }

    private static void checkResourceType(JavaContext context, Node argument, EnumSet<ResourceType> expectedType) {
        EnumSet<ResourceType> actual = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection(actual, expectedType).isEmpty() || expectedType.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(RESOURCE_TYPE, context, argument)) {
            return;
        }
        String message = actual != null && actual.size() == 1 && actual.contains(COLOR_INT_MARKER_TYPE) ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType.contains(COLOR_INT_MARKER_TYPE) ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString()) : (expectedType.size() < ResourceType.getNames().length - 1 ? String.format("Expected resource of type %1$s", Joiner.on((String)" or ").join(expectedType)) : "Expected resource identifier (`R`.type.`name`)"));
        context.report(RESOURCE_TYPE, argument, context.getLocation(argument), message);
    }

    private static EnumSet<ResourceType> getResourceTypes(JavaContext context, Node argument) {
        block13: {
            JavaParser.ResolvedNode resolved;
            block14: {
                block12: {
                    Select select;
                    Expression typeOperand;
                    Node grandParent;
                    Node parent;
                    if (!(argument instanceof Select)) break block12;
                    Select node = (Select)argument;
                    if (node.astOperand() instanceof Select) {
                        VariableReference reference;
                        Select innerSelect;
                        Select select2 = (Select)node.astOperand();
                        if (select2.astOperand() instanceof Select && (innerSelect = (Select)select2.astOperand()).astIdentifier().astValue().equals("R")) {
                            String typeName = select2.astIdentifier().astValue();
                            ResourceType type = ResourceType.getEnum((String)typeName);
                            return type != null ? EnumSet.of(type) : null;
                        }
                        if (select2.astOperand() instanceof VariableReference && (reference = (VariableReference)select2.astOperand()).astIdentifier().astValue().equals("R")) {
                            String typeName = select2.astIdentifier().astValue();
                            ResourceType type = ResourceType.getEnum((String)typeName);
                            return type != null ? EnumSet.of(type) : null;
                        }
                    }
                    if (node.astIdentifier().astValue().equals("R") && (parent = node.getParent()) instanceof Select && (grandParent = parent.getParent()) instanceof Select && (typeOperand = (select = (Select)grandParent).astOperand()) instanceof Select) {
                        Select typeSelect = (Select)typeOperand;
                        String typeName = typeSelect.astIdentifier().astValue();
                        ResourceType type = ResourceType.getEnum((String)typeName);
                        return type != null ? EnumSet.of(type) : null;
                    }
                    break block13;
                }
                if (!(argument instanceof VariableReference)) break block14;
                Statement statement = (Statement)JavaContext.getParentOfType((Node)argument, Statement.class, (boolean)false);
                if (statement == null) break block13;
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)argument).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            return SupportAnnotationDetector.getResourceTypes(context, (Node)entry.astInitializer());
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                    return SupportAnnotationDetector.getResourceTypes(context, (Node)binaryExpression.astRight());
                }
                break block13;
            }
            if (argument instanceof MethodInvocation && (resolved = context.resolve(argument)) != null) {
                for (JavaParser.ResolvedAnnotation annotation : resolved.getAnnotations()) {
                    String signature = annotation.getSignature();
                    if (signature.equals(COLOR_INT_ANNOTATION)) {
                        return EnumSet.of(COLOR_INT_MARKER_TYPE);
                    }
                    if (!signature.endsWith(RES_SUFFIX) || !signature.startsWith("android.support.annotation.")) continue;
                    String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
                    ResourceType type = ResourceType.getEnum((String)typeString);
                    if (type != null) {
                        return EnumSet.of(type);
                    }
                    if (!typeString.equals("any")) continue;
                    return SupportAnnotationDetector.getAnyRes();
                }
            }
        }
        return null;
    }

    private static void checkIntRange(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument, Iterable<JavaParser.ResolvedAnnotation> allAnnotations) {
        String message = SupportAnnotationDetector.getIntRangeError(context, annotation, argument);
        if (message != null) {
            if (SupportAnnotationDetector.findIntDef(allAnnotations) != null) {
                return;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
                return;
            }
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getIntRangeError(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument) {
        if (argument instanceof ArrayCreation) {
            ArrayCreation creation = (ArrayCreation)argument;
            ArrayInitializer initializer = creation.astInitializer();
            if (initializer != null) {
                for (Expression expression : initializer.astExpressions()) {
                    String error = SupportAnnotationDetector.getIntRangeError(context, annotation, (Node)expression);
                    if (error == null) continue;
                    return error;
                }
            }
            return null;
        }
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (Node)argument);
        if (!(object instanceof Number)) {
            return null;
        }
        long value = ((Number)object).longValue();
        long from = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_FROM, Long.MIN_VALUE);
        long to = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_TO, Long.MAX_VALUE);
        return SupportAnnotationDetector.getIntRangeError(value, from, to);
    }

    private static String getIntRangeError(long value, long from, long to) {
        String message = null;
        if (value < from || value > to) {
            StringBuilder sb = new StringBuilder(20);
            if (value < from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(from));
            } else {
                assert (value > to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(to));
            }
            sb.append(" (was ").append(value).append(')');
            message = sb.toString();
        }
        return message;
    }

    private static void checkFloatRange(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument) {
        boolean toInclusive;
        boolean fromInclusive;
        double to;
        double from;
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (Node)argument);
        if (!(object instanceof Number)) {
            return;
        }
        double value = ((Number)object).doubleValue();
        String message = SupportAnnotationDetector.getFloatRangeError(value, from = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_FROM, Double.NEGATIVE_INFINITY), to = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_TO, Double.POSITIVE_INFINITY), fromInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_FROM_INCLUSIVE, true), toInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_TO_INCLUSIVE, true), argument);
        if (message != null && !SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getFloatRangeError(double value, double from, double to, boolean fromInclusive, boolean toInclusive, Node node) {
        if (!((fromInclusive && value >= from || !fromInclusive && value > from) && (toInclusive && value <= to || !toInclusive && value < to))) {
            StringBuilder sb = new StringBuilder(20);
            if (from != Double.NEGATIVE_INFINITY) {
                if (to != Double.POSITIVE_INFINITY) {
                    if (fromInclusive && value < from || !fromInclusive && value <= from) {
                        sb.append("Value must be ");
                        if (fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(from));
                    } else {
                        assert (toInclusive && value > to || !toInclusive && value >= to);
                        sb.append("Value must be ");
                        if (toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(from));
                }
            } else if (to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(to));
            }
            sb.append(" (was ");
            if (node instanceof FloatingPointLiteral || node instanceof IntegralLiteral) {
                String str = node.toString();
                if (str.endsWith("f") || str.endsWith("F")) {
                    str = str.substring(0, str.length() - 1);
                }
                sb.append(str);
            } else {
                sb.append(value);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    private static void checkSize(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument) {
        int actual;
        StringLiteral literal;
        if (argument instanceof StringLiteral) {
            literal = (StringLiteral)argument;
            String s = literal.astValue();
            actual = s.length();
        } else if (argument instanceof ArrayCreation) {
            literal = (ArrayCreation)argument;
            ArrayInitializer initializer = literal.astInitializer();
            if (initializer == null) {
                return;
            }
            actual = initializer.astExpressions().size();
        } else {
            return;
        }
        long exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
        long min = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MIN, Long.MIN_VALUE);
        long max = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MAX, Long.MAX_VALUE);
        long multiple = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MULTIPLE, 1L);
        boolean isString = argument instanceof StringLiteral;
        String unit = isString ? "length" : "size";
        String message = SupportAnnotationDetector.getSizeError(actual, exact, min, max, multiple, unit);
        if (message != null && !SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getSizeError(long actual, long exact, long min, long max, long multiple, String unit) {
        String message = null;
        if (exact != -1L) {
            if (exact != actual) {
                message = String.format("Expected %1$s %2$d (was %3$d)", unit, exact, actual);
            }
        } else if (actual < min || actual > max) {
            StringBuilder sb = new StringBuilder(20);
            if (actual < min) {
                sb.append("Expected ").append(unit).append(" \u2265 ");
                sb.append(Long.toString(min));
            } else {
                assert (actual > max);
                sb.append("Expected ").append(unit).append(" \u2264 ");
                sb.append(Long.toString(max));
            }
            sb.append(" (was ").append(actual).append(')');
            message = sb.toString();
        } else if (actual % multiple != 0L) {
            message = String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, multiple, actual, actual / multiple * multiple, (actual / multiple + 1L) * multiple);
        }
        return message;
    }

    private static JavaParser.ResolvedAnnotation findIntRange(Iterable<JavaParser.ResolvedAnnotation> annotations) {
        for (JavaParser.ResolvedAnnotation annotation : annotations) {
            if (!INT_RANGE_ANNOTATION.equals(annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    static JavaParser.ResolvedAnnotation findIntDef(Iterable<JavaParser.ResolvedAnnotation> annotations) {
        for (JavaParser.ResolvedAnnotation annotation : annotations) {
            if (!"android.support.annotation.IntDef".equals(annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    private static void checkTypeDefConstant(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument, Node errorNode, boolean flag, Iterable<JavaParser.ResolvedAnnotation> allAnnotations) {
        block16: {
            Statement statement;
            block26: {
                block25: {
                    block23: {
                        BinaryExpression expression;
                        block24: {
                            block20: {
                                UnaryOperator operator;
                                block22: {
                                    UnaryExpression expression2;
                                    block21: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block15: {
                                                        if (argument instanceof NullLiteral) {
                                                            return;
                                                        }
                                                        if (!(argument instanceof StringLiteral)) break block15;
                                                        StringLiteral string = (StringLiteral)argument;
                                                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string.astValue(), allAnnotations);
                                                        break block16;
                                                    }
                                                    if (!(argument instanceof IntegralLiteral)) break block17;
                                                    IntegralLiteral literal = (IntegralLiteral)argument;
                                                    int value = literal.astIntValue();
                                                    if (flag && value == 0) {
                                                        return;
                                                    }
                                                    JavaParser.ResolvedAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
                                                    if (rangeAnnotation != null && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, (Node)literal) == null) {
                                                        return;
                                                    }
                                                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, allAnnotations);
                                                    break block16;
                                                }
                                                if (!SupportAnnotationDetector.isMinusOne(argument)) break block18;
                                                if (flag) break block16;
                                                JavaParser.ResolvedAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
                                                if (rangeAnnotation != null && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, argument) == null) {
                                                    return;
                                                }
                                                SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                                break block16;
                                            }
                                            if (!(argument instanceof InlineIfExpression)) break block19;
                                            InlineIfExpression expression3 = (InlineIfExpression)argument;
                                            if (expression3.astIfTrue() != null) {
                                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression3.astIfTrue(), errorNode, flag, allAnnotations);
                                            }
                                            if (expression3.astIfFalse() == null) break block16;
                                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression3.astIfFalse(), errorNode, flag, allAnnotations);
                                            break block16;
                                        }
                                        if (!(argument instanceof UnaryExpression)) break block20;
                                        expression2 = (UnaryExpression)argument;
                                        operator = expression2.astOperator();
                                        if (!flag) break block21;
                                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression2.astOperand(), errorNode, true, allAnnotations);
                                        break block16;
                                    }
                                    if (operator != UnaryOperator.BINARY_NOT) break block22;
                                    if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (Node)expression2)) {
                                        return;
                                    }
                                    context.report(TYPE_DEF, (Node)expression2, context.getLocation((Node)expression2), "Flag not allowed here");
                                    break block16;
                                }
                                if (operator != UnaryOperator.UNARY_MINUS) break block16;
                                JavaParser.ResolvedAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
                                if (rangeAnnotation != null && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, argument) == null) {
                                    return;
                                }
                                SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                break block16;
                            }
                            if (!(argument instanceof BinaryExpression)) break block23;
                            expression = (BinaryExpression)argument;
                            if (!flag) break block24;
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astLeft(), errorNode, true, allAnnotations);
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression.astRight(), errorNode, true, allAnnotations);
                            break block16;
                        }
                        BinaryOperator operator = expression.astOperator();
                        if (operator != BinaryOperator.BITWISE_AND && operator != BinaryOperator.BITWISE_OR && operator != BinaryOperator.BITWISE_XOR) break block16;
                        if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (Node)expression)) {
                            return;
                        }
                        context.report(TYPE_DEF, (Node)expression, context.getLocation((Node)expression), "Flag not allowed here");
                        break block16;
                    }
                    if (!(argument instanceof ArrayCreation)) break block25;
                    ArrayCreation creation = (ArrayCreation)argument;
                    TypeReference typeReference = creation.astComponentTypeReference();
                    ArrayInitializer initializer = creation.astInitializer();
                    if (initializer == null || !"int".equals(typeReference.getTypeName()) && !"long".equals(typeReference.getTypeName())) break block16;
                    for (Expression expression : initializer.astExpressions()) {
                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)expression, errorNode, flag, allAnnotations);
                    }
                    break block16;
                }
                JavaParser.ResolvedNode resolved = context.resolve(argument);
                if (!(resolved instanceof JavaParser.ResolvedField)) break block26;
                JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
                if (field.getType().isArray()) {
                    return;
                }
                int modifiers = field.getModifiers();
                if ((modifiers & 0x18) != 24) break block16;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, resolved, allAnnotations);
                break block16;
            }
            if (argument instanceof VariableReference && (statement = (Statement)JavaContext.getParentOfType((Node)argument, Statement.class, (boolean)false)) != null) {
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)argument).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)entry.astInitializer(), errorNode != null ? errorNode : argument, flag, allAnnotations);
                            return;
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (Node)binaryExpression.astRight(), errorNode != null ? errorNode : argument, flag, allAnnotations);
                    return;
                }
            }
        }
    }

    private static void checkTypeDefConstant(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument, Node errorNode, boolean flag, Object value, Iterable<JavaParser.ResolvedAnnotation> allAnnotations) {
        Object allowed = annotation.getValue();
        if (allowed instanceof Object[]) {
            Object[] allowedValues;
            for (Object o : allowedValues = (Object[])allowed) {
                if (!o.equals(value)) continue;
                return;
            }
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, allowedValues, allAnnotations);
        }
    }

    private static void reportTypeDef(JavaContext context, JavaParser.ResolvedAnnotation annotation, Node argument, Node errorNode, Iterable<JavaParser.ResolvedAnnotation> allAnnotations) {
        Object allowed = annotation.getValue();
        if (allowed instanceof Object[]) {
            Object[] allowedValues = (Object[])allowed;
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, allowedValues, allAnnotations);
        }
    }

    private static void reportTypeDef(JavaContext context, Node node, Node errorNode, boolean flag, Object[] allowedValues, Iterable<JavaParser.ResolvedAnnotation> allAnnotations) {
        String rangeError;
        if (errorNode == null) {
            errorNode = node;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, errorNode)) {
            return;
        }
        String values = SupportAnnotationDetector.listAllowedValues(allowedValues);
        String message = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        JavaParser.ResolvedAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && (rangeError = SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, node)) != null && !rangeError.isEmpty()) {
            message = message + " or " + Character.toLowerCase(rangeError.charAt(0)) + rangeError.substring(1);
        }
        context.report(TYPE_DEF, errorNode, context.getLocation(errorNode), message);
    }

    private static String listAllowedValues(Object[] allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (Object allowedValue : allowedValues) {
            String s;
            if (allowedValue instanceof Integer) {
                s = allowedValue.toString();
            } else {
                if (!(allowedValue instanceof JavaParser.ResolvedNode)) continue;
                JavaParser.ResolvedNode node = (JavaParser.ResolvedNode)allowedValue;
                if (node instanceof JavaParser.ResolvedField) {
                    JavaParser.ResolvedField field = (JavaParser.ResolvedField)node;
                    String containingClassName = field.getContainingClassName();
                    if (containingClassName == null) continue;
                    containingClassName = containingClassName.substring(containingClassName.lastIndexOf(46) + 1);
                    s = containingClassName + "." + field.getName();
                } else {
                    s = node.getSignature();
                }
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static double getDoubleAttribute(JavaParser.ResolvedAnnotation annotation, String name, double defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    private static long getLongAttribute(JavaParser.ResolvedAnnotation annotation, String name, long defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultValue;
    }

    private static boolean getBoolean(JavaParser.ResolvedAnnotation annotation, String name, boolean defaultValue) {
        Object value = annotation.getValue(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    static Iterable<JavaParser.ResolvedAnnotation> filterRelevantAnnotations(Iterable<JavaParser.ResolvedAnnotation> annotations) {
        List<JavaParser.ResolvedAnnotation> result = null;
        Iterator<JavaParser.ResolvedAnnotation> iterator = annotations.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            JavaParser.ResolvedClass type;
            JavaParser.ResolvedAnnotation annotation = iterator.next();
            ++index;
            String signature = annotation.getSignature();
            if (signature.startsWith("java.")) continue;
            if (signature.startsWith("android.support.annotation.")) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (!iterator.hasNext() && index == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList<JavaParser.ResolvedAnnotation>(2);
                }
                result.add(annotation);
            }
            if ((type = annotation.getClassType()) == null) continue;
            Iterable innerAnnotations = type.getAnnotations();
            Iterator iterator2 = innerAnnotations.iterator();
            while (iterator2.hasNext()) {
                JavaParser.ResolvedAnnotation inner = (JavaParser.ResolvedAnnotation)iterator2.next();
                if (!inner.matches("android.support.annotation.IntDef") && !inner.matches(PERMISSION_ANNOTATION) && !inner.matches(INT_RANGE_ANNOTATION) && !inner.matches("android.support.annotation.StringDef")) continue;
                if (!iterator.hasNext() && !iterator2.hasNext() && index == 1) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList<JavaParser.ResolvedAnnotation>(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Arrays.asList(MethodInvocation.class, ConstructorInvocation.class, EnumConstant.class);
    }

    public AstVisitor createJavaVisitor(JavaContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public CallVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodInvocation(MethodInvocation call) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)call);
            if (resolved instanceof JavaParser.ResolvedMethod) {
                JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                this.checkCall((Node)call, method);
            }
            return false;
        }

        public boolean visitConstructorInvocation(ConstructorInvocation call) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)call);
            if (resolved instanceof JavaParser.ResolvedMethod) {
                JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                this.checkCall((Node)call, method);
            }
            return false;
        }

        public boolean visitEnumConstant(EnumConstant node) {
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
            if (resolved instanceof JavaParser.ResolvedMethod) {
                JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                this.checkCall((Node)node, method);
            }
            return false;
        }

        private void checkCall(Node call, JavaParser.ResolvedMethod method) {
            Iterable<JavaParser.ResolvedAnnotation> annotations = method.getAnnotations();
            annotations = SupportAnnotationDetector.filterRelevantAnnotations(annotations);
            for (JavaParser.ResolvedAnnotation annotation : annotations) {
                SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation);
            }
            JavaParser.ResolvedClass containingClass = method.getContainingClass();
            annotations = containingClass.getAnnotations();
            annotations = SupportAnnotationDetector.filterRelevantAnnotations(annotations);
            for (JavaParser.ResolvedAnnotation annotation : annotations) {
                SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation);
            }
            Iterator arguments = JavaContext.getParameters((Node)call);
            int n = method.getArgumentCount();
            for (int i = 0; i < n && arguments.hasNext(); ++i) {
                Expression argument = (Expression)arguments.next();
                annotations = method.getParameterAnnotations(i);
                annotations = SupportAnnotationDetector.filterRelevantAnnotations(annotations);
                SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, (Node)argument, call, method, annotations);
            }
            while (arguments.hasNext()) {
                Expression argument = (Expression)arguments.next();
                SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, (Node)argument, call, method, annotations);
            }
        }
    }

    private static class CheckPermissionVisitor
    extends ForwardingAstVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final Node mTarget;

        public CheckPermissionVisitor(Node target) {
            this.mTarget = target;
        }

        public boolean visitNode(Node node) {
            return this.mDone;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if (((name = node.astName().astValue()).startsWith("check") || name.startsWith("enforce")) && name.endsWith("Permission")) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

