/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(name="TypeToString", summary="Type#toString shouldn't be used for comparison as it is expensive and fragile.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class TypeToString
extends AbstractToString {
    private static final TypePredicate IS_TYPE = TypePredicates.isDescendantOf((String)"com.sun.tools.javac.code.Type");
    private static final Matcher<Tree> STRING_EQUALS = Matchers.toType(MemberSelectTree.class, (Matcher)Matchers.instanceMethod().onExactClass("java.lang.String").named("equals"));

    private static boolean typeToStringInBugChecker(Type type, VisitorState state) {
        if (!ASTHelpers.isBugCheckerCode((VisitorState)state)) {
            return false;
        }
        Tree parentTree = state.getPath().getParentPath().getLeaf();
        return IS_TYPE.apply(type, state) && STRING_EQUALS.matches(parentTree, state);
    }

    @Override
    protected TypePredicate typePredicate() {
        return TypeToString::typeToStringInBugChecker;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.of("Type#toString shouldn't be used as it is expensive and fragile.");
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }
}

