/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.ExpressionParser;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.LayoutBinderWriter;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class LayoutBinder
implements FileScopeProvider {
    private static final Comparator<BindingTarget> COMPARE_FIELD_NAME = new Comparator<BindingTarget>(){

        @Override
        public int compare(BindingTarget first, BindingTarget second) {
            String fieldName1 = LayoutBinderWriterKt.getFieldName(first);
            String fieldName2 = LayoutBinderWriterKt.getFieldName(second);
            return fieldName1.compareTo(fieldName2);
        }
    };
    private final ExprModel mExprModel;
    private final ExpressionParser mExpressionParser;
    private final List<BindingTarget> mBindingTargets;
    private final List<BindingTarget> mSortedBindingTargets;
    private String mModulePackage;
    private final HashMap<String, String> mUserDefinedVariables = new HashMap();
    private LayoutBinderWriter mWriter;
    private ResourceBundle.LayoutFileBundle mBundle;
    public final ResourceBundle.LayoutFileBundle mLayoutBundle;
    private final boolean mEnableV2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutBinder(ResourceBundle.LayoutFileBundle layoutBundle, boolean enableV2) {
        this.mLayoutBundle = layoutBundle;
        this.mEnableV2 = enableV2;
        try {
            Scope.enter((ScopeProvider)this);
            this.mModulePackage = layoutBundle.getModulePackage();
            this.mExprModel = new ExprModel(this.mModulePackage, enableV2);
            this.mExpressionParser = new ExpressionParser(this.mExprModel);
            this.mBindingTargets = new ArrayList<BindingTarget>();
            this.mBundle = layoutBundle;
            HashSet<String> names = new HashSet<String>();
            for (ResourceBundle.VariableDeclaration variable : this.mBundle.getVariables()) {
                this.addVariable(variable.name, variable.type, variable.location, variable.declared);
                names.add(variable.name);
            }
            for (ResourceBundle.NameTypeLocation userImport : this.mBundle.getImports()) {
                this.mExprModel.addImport(userImport.name, userImport.type, userImport.location);
                names.add(userImport.name);
            }
            if (!names.contains("context")) {
                this.mExprModel.builtInVariable("context", "android.content.Context", "getRoot().getContext()");
                names.add("context");
            }
            for (ResourceBundle.BindingTargetBundle targetBundle : this.mBundle.getBindingTargetBundles()) {
                try {
                    Scope.enter((ScopeProvider)targetBundle);
                    BindingTarget bindingTarget = this.createBindingTarget(targetBundle);
                    if (bindingTarget.getId() == null) continue;
                    String fieldName2 = LayoutBinderWriterKt.getReadableName(bindingTarget);
                    if (names.contains(fieldName2)) {
                        L.w((String)"View field %s collides with a variable or import", (Object[])new Object[]{fieldName2});
                        continue;
                    }
                    names.add(fieldName2);
                    this.mExprModel.viewFieldExpr(bindingTarget);
                }
                finally {
                    Scope.exit();
                }
            }
            for (BindingTarget bindingTarget : this.mBindingTargets) {
                try {
                    Scope.enter((ScopeProvider)bindingTarget.mBundle);
                    String implName = this.getPackage() + "." + this.getImplementationName();
                    for (ResourceBundle.BindingTargetBundle.BindingBundle bindingBundle : bindingTarget.mBundle.getBindingBundleList()) {
                        try {
                            Scope.enter((Location)bindingBundle.getValueLocation());
                            Expr expr = this.parse(bindingBundle.getExpr(), bindingBundle.getValueLocation(), bindingTarget);
                            bindingTarget.addBinding(bindingBundle.getName(), expr);
                            if (!bindingBundle.isTwoWay()) continue;
                            bindingTarget.addInverseBinding(bindingBundle.getName(), expr, implName);
                        }
                        finally {
                            Scope.exit();
                        }
                    }
                    bindingTarget.resolveCallbackParams();
                    bindingTarget.resolveTwoWayExpressions();
                }
                finally {
                    Scope.exit();
                }
            }
            for (BindingTarget bindingTarget : this.mBindingTargets) {
                try {
                    Scope.enter((ScopeProvider)bindingTarget.mBundle);
                    bindingTarget.resolveMultiSetters();
                    bindingTarget.resolveListeners();
                    bindingTarget.injectSafeUnboxing(this.mExprModel);
                }
                finally {
                    Scope.exit();
                }
            }
            this.mSortedBindingTargets = new ArrayList<BindingTarget>(this.mBindingTargets);
            Collections.sort(this.mSortedBindingTargets, COMPARE_FIELD_NAME);
        }
        finally {
            Scope.exit();
        }
    }

    public void resolveWhichExpressionsAreUsed() {
        ArrayList<Expr> used = new ArrayList<Expr>();
        for (BindingTarget target : this.mBindingTargets) {
            for (Binding binding : target.getBindings()) {
                binding.getExpr().markAsUsed();
                used.add(binding.getExpr());
            }
        }
        while (!used.isEmpty()) {
            Expr e = (Expr)used.remove(used.size() - 1);
            for (Dependency dep : e.getDependencies()) {
                if (dep.getOther().isUsed()) continue;
                used.add(dep.getOther());
                dep.getOther().markAsUsed();
            }
        }
    }

    public IdentifierExpr addVariable(String name, String type, Location location, boolean declared) {
        Preconditions.check((!this.mUserDefinedVariables.containsKey(name) ? 1 : 0) != 0, (String)"%s has already been defined as %s", (Object[])new Object[]{name, type});
        IdentifierExpr id = this.mExprModel.identifier(name);
        id.setUserDefinedType(type);
        id.enableDirectInvalidation();
        if (location != null) {
            id.addLocation(location);
        }
        this.mUserDefinedVariables.put(name, type);
        if (declared) {
            id.setDeclared();
        }
        return id;
    }

    public HashMap<String, String> getUserDefinedVariables() {
        return this.mUserDefinedVariables;
    }

    public BindingTarget createBindingTarget(ResourceBundle.BindingTargetBundle targetBundle) {
        BindingTarget target = new BindingTarget(targetBundle);
        this.mBindingTargets.add(target);
        target.setModel(this.mExprModel);
        return target;
    }

    public Expr parse(String input, Location locationInFile, BindingTarget target) {
        Expr parsed = this.mExpressionParser.parse(input, locationInFile, target);
        parsed.markAsBindingExpression();
        return parsed;
    }

    public List<BindingTarget> getBindingTargets() {
        return this.mBindingTargets;
    }

    public List<BindingTarget> getSortedTargets() {
        return this.mSortedBindingTargets;
    }

    public boolean isEmpty() {
        return this.mExprModel.size() == 0;
    }

    public ExprModel getModel() {
        return this.mExprModel;
    }

    private void ensureWriter() {
        if (this.mWriter == null) {
            this.mWriter = new LayoutBinderWriter(this, ModelAnalyzer.getInstance().libTypes);
        }
    }

    public void sealModel() {
        this.mExprModel.seal();
    }

    public String writeViewBinderBaseClass(boolean forLibrary, List<LayoutBinder> variations) {
        this.ensureWriter();
        return this.mWriter.writeBaseClass(forLibrary, variations);
    }

    public String writeViewBinder(int minSdk) {
        this.ensureWriter();
        Preconditions.checkNotNull((Object)this.getPackage(), (String)"package cannot be null", (Object[])new Object[0]);
        Preconditions.checkNotNull((Object)this.getClassName(), (String)"base class name cannot be null", (Object[])new Object[0]);
        return this.mWriter.write(minSdk);
    }

    public String getPackage() {
        return this.mBundle.getBindingClassPackage();
    }

    public boolean isMerge() {
        return this.mBundle.isMerge();
    }

    public String getModulePackage() {
        return this.mModulePackage;
    }

    public String getLayoutname() {
        return this.mBundle.getFileName();
    }

    public String getImplementationName() {
        if (this.mEnableV2 || this.hasVariations()) {
            return this.mBundle.createImplClassNameWithConfig();
        }
        return this.mBundle.getBindingClassName();
    }

    public boolean enableV2() {
        return this.mEnableV2;
    }

    public String getClassName() {
        return this.mBundle.getBindingClassName();
    }

    public String getTag() {
        return this.mBundle.createTag();
    }

    public boolean hasVariations() {
        return this.mBundle.hasVariations();
    }

    public String provideScopeFilePath() {
        return this.mBundle.getAbsoluteFilePath();
    }
}

