/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.graph;

import com.google.monitoring.runtime.instrumentation.common.annotations.Beta;
import com.google.monitoring.runtime.instrumentation.common.base.Function;
import com.google.monitoring.runtime.instrumentation.common.base.Functions;
import com.google.monitoring.runtime.instrumentation.common.base.Preconditions;
import com.google.monitoring.runtime.instrumentation.common.collect.ImmutableMap;
import com.google.monitoring.runtime.instrumentation.common.collect.Maps;
import com.google.monitoring.runtime.instrumentation.common.graph.BaseGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.ConfigurableValueGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.DirectedGraphConnections;
import com.google.monitoring.runtime.instrumentation.common.graph.EndpointPair;
import com.google.monitoring.runtime.instrumentation.common.graph.ForwardingGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.Graph;
import com.google.monitoring.runtime.instrumentation.common.graph.GraphBuilder;
import com.google.monitoring.runtime.instrumentation.common.graph.GraphConnections;
import com.google.monitoring.runtime.instrumentation.common.graph.GraphConstants;
import com.google.monitoring.runtime.instrumentation.common.graph.MutableGraph;
import com.google.monitoring.runtime.instrumentation.common.graph.UndirectedGraphConnections;
import com.google.monitoring.runtime.instrumentation.errorprone.annotations.CanIgnoreReturnValue;
import com.google.monitoring.runtime.instrumentation.errorprone.annotations.Immutable;

@Immutable(containerOf={"N"})
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

