/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;

class MethodCodec
implements ObjectCodec<Method> {
    MethodCodec() {
    }

    @Override
    public Class<Method> getEncodedClass() {
        return Method.class;
    }

    @Override
    public void serialize(SerializationContext context, Method obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        context.serialize(obj.getDeclaringClass(), codedOut);
        context.serialize(obj.getName(), codedOut);
        Class<?>[] parameterTypes = obj.getParameterTypes();
        codedOut.writeInt32NoTag(parameterTypes.length);
        for (Class<?> parameter : parameterTypes) {
            context.serialize(parameter, codedOut);
        }
    }

    @Override
    public Method deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Class clazz = (Class)context.deserialize(codedIn);
        String name = (String)context.deserialize(codedIn);
        Object[] parameters = new Class[codedIn.readInt32()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = (Class)context.deserialize(codedIn);
        }
        try {
            return clazz.getDeclaredMethod(name, (Class<?>[])parameters);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException("Couldn't get method " + name + " in " + String.valueOf(clazz) + " with parameters " + Arrays.toString(parameters), e);
        }
    }
}

