/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractBanUnsafeAPIChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;

@BugPattern(summary="Using dangerous ClassLoader APIs may deserialize untrusted user input into bytecode, leading to remote code execution vulnerabilities", severity=BugPattern.SeverityLevel.ERROR)
public final class BanClassLoader
extends AbstractBanUnsafeAPIChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodInvocationTree> METHOD_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.anyMethod().onDescendantOf("java.lang.ClassLoader").named("defineClass"), Matchers.anyMethod().onDescendantOf("java.lang.invoke.MethodHandles.Lookup").named("defineClass"), Matchers.anyMethod().onDescendantOf("java.rmi.server.RMIClassLoader").namedAnyOf(new String[]{"loadClass", "loadProxyClass"}), Matchers.anyMethod().onDescendantOf("java.rmi.server.RMIClassLoaderSpi").namedAnyOf(new String[]{"loadClass", "loadProxyClass"})});
    private static final Matcher<ExpressionTree> CONSTRUCTOR_MATCHER = Matchers.constructor().forClass(TypePredicates.allOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"java.net.URLClassLoader")}));
    private static final Matcher<ClassTree> EXTEND_CLASS_MATCHER = Matchers.isExtensionOf((String)"java.net.URLClassLoader");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchHelper(tree, state, METHOD_MATCHER);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchHelper(tree, state, CONSTRUCTOR_MATCHER);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.matchHelper(tree, state, EXTEND_CLASS_MATCHER);
    }
}

