/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="To get the tag number of a protocol buffer enum, use getNumber() instead.", severity=BugPattern.SeverityLevel.ERROR)
public class ProtocolBufferOrdinal
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.Internal.EnumLite";
    private static final Matcher<ExpressionTree> PROTO_MSG_ORDINAL_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.Internal.EnumLite").named("ordinal").withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return PROTO_MSG_ORDINAL_MATCHER.matches((Tree)methodInvocationTree, state) ? this.describeMatch(methodInvocationTree) : Description.NO_MATCH;
    }
}

