/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.util.DN;

public final class RDN
implements Serializable {
    static final long serialVersionUID = 7895454691174650321L;
    private String[] m_type = null;
    private String[] m_value = null;
    private boolean m_ismultivalued = false;
    private static Hashtable m_attributehash = new Hashtable();
    public static final String[] _cesAttributes = new String[]{"adminurl", "altserver", "automountinformation", "bootfile", "bootparameter", "cirbindcredentials", "generation", "homedirectory", "internationalisdnnumber", "labeleduri", "membercertificatedescription", "membernisnetgroup", "memberuid", "memberurl", "nismapentry", "nisnetgrouptriple", "nsaddressbooksyncurl", "presentationaddress", "ref", "replicaentryfilter", "searchguide", "subtreeaci", "vlvfilter", "vlvname", "x121address"};
    public static final String CES_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.26";

    public RDN(String string) {
        String string2 = RDN.neutralizeEscapes(string);
        if (string2 == null) {
            return;
        }
        int n = string2.indexOf("=");
        if (n <= 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string.substring(0, n).trim());
        int n2 = string2.indexOf(43, n);
        while (n2 != -1) {
            this.m_ismultivalued = true;
            vector.addElement(string.substring(n + 1, n2).trim());
            n = string2.indexOf("=", n2 + 1);
            if (n == -1) {
                return;
            }
            vector2.addElement(string.substring(n2 + 1, n).trim());
            n2 = string2.indexOf(43, n);
        }
        vector.addElement(string.substring(n + 1).trim());
        this.m_type = new String[vector2.size()];
        this.m_value = new String[vector.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            this.m_type[i] = (String)vector2.elementAt(i);
            if (!this.isValidType(this.m_type[i])) {
                this.m_value = null;
                this.m_type = null;
                return;
            }
            this.m_value[i] = (String)vector.elementAt(i);
            if (this.isValidValue(this.m_value[i])) continue;
            this.m_value = null;
            this.m_type = null;
            return;
        }
    }

    static String neutralizeEscapes(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (stringBuffer.charAt(n) != '\\') continue;
            stringBuffer.setCharAt(n, 'x');
            if (n < stringBuffer.length() - 1) {
                stringBuffer.setCharAt(n + 1, 'x');
                continue;
            }
            return null;
        }
        for (n = 0; n < stringBuffer.length(); ++n) {
            if (stringBuffer.charAt(n) == '\"') {
                bl = !bl;
                continue;
            }
            if (!bl) continue;
            stringBuffer.setCharAt(n, 'x');
        }
        return bl ? null : stringBuffer.toString();
    }

    private boolean isValidType(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 0; j < DN.ESCAPED_CHAR.length; ++j) {
                if (string.charAt(i) != DN.ESCAPED_CHAR[j]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidValue(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n2 >= 0 && n2 < string.length()) {
            if ((n2 = string.indexOf(34, n2)) < 0) continue;
            if (n2 == 0 || string.charAt(n2 - 1) != '\\') {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return true;
        }
        if (n != 2) {
            return false;
        }
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    public String[] explodeRDN(boolean bl) {
        if (this.m_type == null) {
            return null;
        }
        String[] stringArray = new String[]{bl ? this.getValue() : this.toString()};
        return stringArray;
    }

    public String getType() {
        if (this.m_type != null && this.m_type.length > 0) {
            return this.m_type[0];
        }
        return null;
    }

    public String[] getTypes() {
        return this.m_type;
    }

    public String getValue() {
        if (this.m_value != null && this.m_value.length > 0) {
            return this.m_value[0];
        }
        return null;
    }

    public String[] getValues() {
        return this.m_value;
    }

    public boolean isMultivalued() {
        return this.m_ismultivalued;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; this.m_type != null && i < this.m_type.length; ++i) {
            if (i != 0) {
                stringBuffer.append(" + ");
            }
            stringBuffer.append(this.m_type[i] + "=" + this.m_value[i]);
        }
        return stringBuffer.toString();
    }

    public static boolean isRDN(String string) {
        RDN rDN = new RDN(string);
        return rDN.getTypes() != null && rDN.getValues() != null;
    }

    public boolean equals(RDN rDN) {
        String[] stringArray = (String[])this.getTypes().clone();
        String[] stringArray2 = (String[])this.getValues().clone();
        String[] stringArray3 = (String[])rDN.getTypes().clone();
        String[] stringArray4 = (String[])rDN.getValues().clone();
        if (stringArray.length != stringArray3.length) {
            return false;
        }
        this.sortTypesAndValues(stringArray, stringArray2);
        this.sortTypesAndValues(stringArray3, stringArray4);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(stringArray3[i])) {
                return false;
            }
            if (!(CES_SYNTAX.equals(RDN.getAttributeSyntax(stringArray[i])) ? !stringArray2[i].equals(stringArray4[i]) : !stringArray2[i].equalsIgnoreCase(stringArray4[i]))) continue;
            return false;
        }
        return true;
    }

    void sortTypesAndValues(String[] stringArray, String[] stringArray2) {
        do {
            boolean bl = true;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].toLowerCase().compareTo(stringArray[i + 1].toLowerCase()) <= 0) continue;
                String string = stringArray[i];
                String string2 = stringArray2[i];
                stringArray[i] = stringArray[i + 1];
                stringArray2[i] = stringArray2[i + 1];
                stringArray[i + 1] = string;
                stringArray2[i + 1] = string2;
                bl = false;
            }
            bl = false;
        } while (false);
    }

    public static void registerAttributeSyntax(String string, String string2) {
        m_attributehash.put(string.toLowerCase(), string2);
    }

    public static void unregisterAttributeSyntax(String string) {
        m_attributehash.remove(string.toLowerCase());
    }

    public static String getAttributeSyntax(String string) {
        return (String)m_attributehash.get(string.toLowerCase());
    }

    public static String[] getAttributesForSyntax(String string) {
        Enumeration enumeration = m_attributehash.keys();
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.equals((String)m_attributehash.get(string2))) continue;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String((String)vector.elementAt(i));
        }
        return stringArray;
    }

    static {
        for (int i = 0; i < _cesAttributes.length; ++i) {
            RDN.registerAttributeSyntax(_cesAttributes[i], CES_SYNTAX);
        }
    }
}

