/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Type;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NegationExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.CSTNode;
import org.codehaus.groovy.syntax.parser.ParserException;

public class ASTBuilder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "groovy.lang.", "groovy.util."};
    private ClassLoader classLoader;
    private Map imports;
    private String packageName;

    public ASTBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.imports = new HashMap();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ModuleNode build(CSTNode unitRoot) throws ParserException {
        ModuleNode answer = new ModuleNode();
        CSTNode[] children = unitRoot.getChildren();
        this.packageName = this.packageDeclaration(children[0]);
        answer.setPackageName(this.packageName);
        this.importStatements(answer, children[1]);
        for (int i = 2; i < children.length; ++i) {
            this.datatypeDeclaration(answer, this.packageName, children[i]);
        }
        if (answer.isEmpty()) {
            answer.addStatement(new BlockStatement());
        }
        return answer;
    }

    protected String packageDeclaration(CSTNode packageRoot) {
        CSTNode nameRoot = packageRoot.getChild(0);
        if (nameRoot.getToken() == null) {
            return null;
        }
        return this.qualifiedName(nameRoot);
    }

    protected void importStatements(ModuleNode node, CSTNode importsRoot) {
        CSTNode[] importStatements = importsRoot.getChildren();
        for (int i = 0; i < importStatements.length; ++i) {
            this.importStatement(node, importStatements[i]);
        }
    }

    protected void importStatement(ModuleNode node, CSTNode importRoot) {
        CSTNode packageNode = importRoot.getChild(0);
        String packageName = null;
        packageName = packageNode.isEmpty() ? "" : this.qualifiedName(packageNode) + ".";
        int current = 1;
        if (importRoot.getChild(current).getToken().getType() == 280) {
            String[] classes = node.addImportPackage(packageName);
            for (int i = 0; i < classes.length; ++i) {
                this.addImport(packageName + classes[i], classes[i]);
            }
        } else {
            while (current < importRoot.children()) {
                CSTNode clause = importRoot.getChild(current);
                String name = this.identifier(clause);
                String as = clause.children() > 0 ? this.identifier(clause.getChild(0)) : name;
                this.addImport(packageName + name, as);
                node.addImport(as, name);
                ++current;
            }
        }
    }

    protected void addImport(String importName, String asName) {
        this.imports.put(asName, importName);
    }

    protected String resolveName(String name) {
        String original = name;
        name = this.removeTypeModifiers(name);
        String postfix = "";
        if (original.length() > name.length()) {
            postfix = original.substring(name.length());
        }
        if (name.indexOf(".") >= 0) {
            return original;
        }
        if (name.equals("void") || name.equals("int") || name.equals("boolean") || name.equals("long") || name.equals("short") || name.equals("char") || name.equals("byte") || name.equals("double") || name.equals("float")) {
            return original;
        }
        if (this.imports.containsKey(name)) {
            return (String)this.imports.get(name) + postfix;
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            try {
                this.getClassLoader().loadClass(this.packageName + "." + name);
                return this.packageName + "." + name + postfix;
            }
            catch (Exception e) {
            }
            catch (Error e) {
                // empty catch block
            }
        }
        for (int i = 0; i < DEFAULT_IMPORTS.length; ++i) {
            try {
                String fullName = DEFAULT_IMPORTS[i] + name;
                this.getClassLoader().loadClass(fullName);
                return fullName + postfix;
            }
            catch (Exception e) {
                continue;
            }
            catch (Error e) {
                // empty catch block
            }
        }
        return null;
    }

    protected String removeTypeModifiers(String name) {
        if (name.endsWith("[]")) {
            return this.removeTypeModifiers(name.substring(0, name.length() - 2));
        }
        return name;
    }

    protected boolean isDatatype(String name) {
        return this.resolveName(name) != null;
    }

    protected String qualifiedName(CSTNode nameRoot) {
        String qualifiedName = "";
        if (this.matches(nameRoot, 30)) {
            CSTNode child = nameRoot.getChild(0);
            return this.qualifiedName(child) + "[]";
        }
        if (this.matches(nameRoot, 70)) {
            CSTNode cur = nameRoot;
            while (this.matches(cur, 70)) {
                qualifiedName = "." + cur.getChild(1).getToken().getText() + qualifiedName;
                cur = cur.getChild(0);
            }
            qualifiedName = cur.getToken().getText() + qualifiedName;
        } else {
            if (this.matches(nameRoot, 543)) {
                return "void";
            }
            if (this.matches(nameRoot, 544)) {
                return "int";
            }
            if (this.matches(nameRoot, 545)) {
                return "float";
            }
            Token token = nameRoot.getToken();
            qualifiedName = token == null ? "java.lang.Object" : token.getText();
        }
        return qualifiedName;
    }

    protected String resolvedQualifiedName(CSTNode nameRoot) {
        return this.resolveName(this.qualifiedName(nameRoot));
    }

    protected String resolvedQualifiedNameNotNull(CSTNode child) throws ParserException {
        String answer = this.resolvedQualifiedName(child);
        if (answer == null) {
            return this.qualifiedName(child);
        }
        return answer;
    }

    protected String[] qualifiedNames(CSTNode[] nameRoots) {
        String[] qualifiedNames = new String[nameRoots.length];
        for (int i = 0; i < nameRoots.length; ++i) {
            qualifiedNames[i] = this.qualifiedName(nameRoots[i]);
        }
        return qualifiedNames;
    }

    protected String[] resolvedQualifiedNamesNotNull(CSTNode[] nameRoots) throws ParserException {
        String[] qualifiedNames = this.qualifiedNames(nameRoots);
        for (int i = 0; i < qualifiedNames.length; ++i) {
            qualifiedNames[i] = this.resolveName(qualifiedNames[i]);
            if (qualifiedNames[i] != null) continue;
            Token token = nameRoots[i].getToken();
            throw new ParserException("Unknown type: " + token.getText() + " could not be resolved", token);
        }
        return qualifiedNames;
    }

    protected void datatypeDeclaration(ModuleNode module, String packageName, CSTNode datatypeCst) throws ParserException {
        if (this.matches(datatypeCst, 506)) {
            module.addClass(this.classDeclaration(packageName, datatypeCst));
        } else if (this.matches(datatypeCst, 521)) {
            module.addClass(this.interfaceDeclaration(packageName, datatypeCst));
        } else if (this.matches(datatypeCst, 800)) {
            module.addMethod(this.methodDeclaration(datatypeCst));
        } else {
            module.addStatement(this.statement(datatypeCst));
        }
    }

    protected ClassNode classDeclaration(String packageName, CSTNode classRoot) throws ParserException {
        int i;
        int modifiers = this.modifiers(classRoot.getChild(0));
        String className = this.identifier(classRoot.getChild(1));
        String superClassName = "java.lang.Object";
        superClassName = this.matches(classRoot.getChild(2), 512) ? this.resolvedQualifiedNameNotNull(classRoot.getChild(2).getChild(0)) : "java.lang.Object";
        String[] interfaceNames = EMPTY_STRING_ARRAY;
        if (this.matches(classRoot.getChild(3), 518)) {
            interfaceNames = this.resolvedQualifiedNamesNotNull(classRoot.getChild(3).getChildren());
        }
        MixinNode[] mixinNames = MixinNode.EMPTY_ARRAY;
        String fqClassName = null;
        fqClassName = packageName == null || packageName.trim().equals("") ? className : packageName.trim() + "." + className;
        ClassNode classNode = new ClassNode(fqClassName, modifiers, superClassName, interfaceNames, mixinNames);
        classNode.setCSTNode(classRoot.getChild(1));
        CSTNode[] bodyRoots = classRoot.getChild(4).getChildren();
        for (i = 0; i < bodyRoots.length; ++i) {
            if (!this.matches(bodyRoots[i], 538)) continue;
            this.addPropertyDeclaration(classNode, bodyRoots[i]);
        }
        for (i = 0; i < bodyRoots.length; ++i) {
            if (!this.matches(bodyRoots[i], 800)) continue;
            this.methodDeclaration(classNode, bodyRoots[i]);
        }
        return classNode;
    }

    protected PropertyNode addPropertyDeclaration(ClassNode classNode, CSTNode propertyRoot) throws ParserException {
        int modifiers = this.modifiers(propertyRoot.getChild(0));
        String identifier = propertyRoot.getChild(1).getToken().getText();
        String typeName = this.resolvedQualifiedName(propertyRoot.getChild(2));
        Expression initialValue = null;
        if (propertyRoot.getChildren().length > 3) {
            initialValue = this.expression(propertyRoot.getChild(3));
        }
        PropertyNode propertyNode = classNode.addProperty(identifier, modifiers, typeName, initialValue, null, null);
        propertyNode.setCSTNode(propertyRoot.getChild(1));
        return propertyNode;
    }

    protected void methodDeclaration(ClassNode classNode, CSTNode methodRoot) throws ParserException {
        int modifiers = this.modifiers(methodRoot.getChild(0));
        String identifier = methodRoot.getChild(1).getToken().getText();
        String returnType = this.resolvedQualifiedName(methodRoot.getChild(2));
        Parameter[] parameters = this.parameters(methodRoot.getChild(3).getChildren());
        if (identifier.equals(classNode.getNameWithoutPackage())) {
            ConstructorNode constructorNode = new ConstructorNode(modifiers, parameters, this.statementBlock(methodRoot.getChild(4)));
            constructorNode.setCSTNode(methodRoot.getChild(1));
            classNode.addConstructor(constructorNode);
        } else {
            MethodNode methodNode = new MethodNode(identifier, modifiers, returnType, parameters, this.statementBlock(methodRoot.getChild(4)));
            methodNode.setCSTNode(methodRoot.getChild(1));
            classNode.addMethod(methodNode);
        }
    }

    protected MethodNode methodDeclaration(CSTNode methodRoot) throws ParserException {
        int modifiers = this.modifiers(methodRoot.getChild(0));
        String identifier = methodRoot.getChild(1).getToken().getText();
        String returnType = this.resolvedQualifiedName(methodRoot.getChild(2));
        Parameter[] parameters = this.parameters(methodRoot.getChild(3).getChildren());
        MethodNode methodNode = new MethodNode(identifier, modifiers, returnType, parameters, this.statementBlock(methodRoot.getChild(4)));
        methodNode.setCSTNode(methodRoot.getChild(1));
        return methodNode;
    }

    protected Parameter[] parameters(CSTNode[] paramRoots) throws ParserException {
        Parameter[] parameters = new Parameter[paramRoots.length];
        for (int i = 0; i < paramRoots.length; ++i) {
            String identifier = paramRoots[i].getChild(1).getToken().getText();
            String type = this.resolvedQualifiedName(paramRoots[i].getChild(0));
            CSTNode defaultNode = paramRoots[i].getChild(2);
            if (defaultNode == null || defaultNode.isEmpty()) {
                parameters[i] = new Parameter(type, identifier);
                continue;
            }
            Expression defaultExpression = this.expression(defaultNode);
            parameters[i] = new Parameter(type, identifier, defaultExpression);
        }
        return parameters;
    }

    protected ClassNode interfaceDeclaration(String packageName, CSTNode interfaceRoot) {
        return null;
    }

    protected BlockStatement statementOrStatementBlock(CSTNode blockRoot) throws ParserException {
        if (blockRoot.getToken() == null || blockRoot.getToken().getType() == 10) {
            return this.statementBlock(blockRoot, 0);
        }
        BlockStatement statementBlock = new BlockStatement();
        Statement statement = this.statement(blockRoot);
        statementBlock.addStatement(statement);
        statement.setCSTNode(blockRoot);
        return statementBlock;
    }

    protected BlockStatement statementBlock(CSTNode blockRoot) throws ParserException {
        return this.statementBlock(blockRoot, 0);
    }

    protected BlockStatement statementBlock(CSTNode blockRoot, int startIndex) throws ParserException {
        BlockStatement statementBlock = new BlockStatement();
        CSTNode[] statementRoots = blockRoot.getChildren();
        for (int i = startIndex; i < statementRoots.length; ++i) {
            CSTNode statementRoot = statementRoots[i];
            if (statementRoot.getToken() == null) continue;
            Statement statement = this.statement(statementRoot);
            statementBlock.addStatement(statement);
            statement.setCSTNode(statementRoot);
        }
        return statementBlock;
    }

    protected Statement statement(CSTNode statementRoot) throws ParserException {
        Statement statement = null;
        switch (statementRoot.getToken().getInterpretation()) {
            case 541: {
                statement = this.assertStatement(statementRoot);
                break;
            }
            case 515: {
                statement = this.forStatement(statementRoot);
                break;
            }
            case 537: {
                statement = this.whileStatement(statementRoot);
                break;
            }
            case 510: {
                statement = this.doWhileStatement(statementRoot);
                break;
            }
            case 536: {
                statement = this.tryStatement(statementRoot);
                break;
            }
            case 528: {
                statement = this.returnStatement(statementRoot);
                break;
            }
            case 531: {
                statement = this.switchStatement(statementRoot);
                break;
            }
            case 517: {
                statement = this.ifStatement(statementRoot);
                break;
            }
            case 534: {
                statement = this.throwStatement(statementRoot);
                break;
            }
            case 503: {
                statement = this.breakStatement(statementRoot);
                break;
            }
            case 508: {
                statement = this.continueStatement(statementRoot);
                break;
            }
            case 532: {
                statement = this.synchronizedStatement(statementRoot);
                break;
            }
            case 10: 
            case 816: {
                statement = this.statementBlock(statementRoot);
                break;
            }
            case 817: {
                statement = this.expressionStatement(statementRoot);
                break;
            }
            case 818: {
                statement = this.statement(statementRoot.getChild(1));
                statement.setStatementLabel(statementRoot.getChild(0).getToken().getText());
                break;
            }
            default: {
                statement = this.expressionStatement(statementRoot);
            }
        }
        statement.setCSTNode(statementRoot);
        return statement;
    }

    protected WhileStatement whileStatement(CSTNode statementRoot) throws ParserException {
        Expression expr = this.expression(statementRoot.getChild(0));
        BlockStatement statementBlock = this.statementOrStatementBlock(statementRoot.getChild(1));
        return new WhileStatement(new BooleanExpression(expr), statementBlock);
    }

    protected DoWhileStatement doWhileStatement(CSTNode statementRoot) throws ParserException {
        Expression expr = this.expression(statementRoot.getChild(1));
        BlockStatement statementBlock = this.statementOrStatementBlock(statementRoot.getChild(0));
        return new DoWhileStatement(new BooleanExpression(expr), statementBlock);
    }

    protected IfStatement ifStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        BooleanExpression expression = new BooleanExpression(this.expression(children[0]));
        BlockStatement ifBlock = this.statementOrStatementBlock(children[1]);
        Statement elseBlock = null;
        elseBlock = children.length == 3 && this.matches(children[2], 517) ? this.ifStatement(children[2]) : (children.length == 3 ? this.statementOrStatementBlock(children[2].getChild(0)) : EmptyStatement.INSTANCE);
        return new IfStatement(expression, ifBlock, elseBlock);
    }

    protected SwitchStatement switchStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        Expression expression = this.expression(children[0]);
        SwitchStatement answer = new SwitchStatement(expression);
        Object defaultBlock = null;
        for (int i = 1; i < children.length; ++i) {
            CSTNode child = children[i];
            if (this.matches(child, 504)) {
                answer.addCase(this.caseStatement(child));
                continue;
            }
            if (this.matches(child, 509)) {
                answer.setDefaultStatement(this.statementBlock(child));
                continue;
            }
            throw new ParserException("Expecting case or default block", child.getToken());
        }
        return answer;
    }

    protected CaseStatement caseStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        Expression expression = this.expression(children[0]);
        return new CaseStatement(expression, this.statementBlock(statementRoot, 1));
    }

    protected ThrowStatement throwStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        return new ThrowStatement(this.expression(children[0]));
    }

    protected BreakStatement breakStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        if (children != null && children.length > 0) {
            CSTNode identifier = children[0];
            String label = identifier.getToken().getText();
            return new BreakStatement(label);
        }
        return new BreakStatement();
    }

    protected ContinueStatement continueStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        if (children != null && children.length > 0) {
            CSTNode identifier = children[0];
            String label = identifier.getToken().getText();
            return new ContinueStatement(label);
        }
        return new ContinueStatement();
    }

    protected SynchronizedStatement synchronizedStatement(CSTNode statementRoot) throws ParserException {
        CSTNode[] children = statementRoot.getChildren();
        Expression expression = this.expression(children[0]);
        return new SynchronizedStatement(expression, this.statementBlock(statementRoot, 1));
    }

    protected TryCatchStatement tryStatement(CSTNode statementRoot) throws ParserException {
        TryCatchStatement tcf = new TryCatchStatement(this.statementBlock(statementRoot.getChild(0)), this.statementBlock(statementRoot.getChild(1)));
        CSTNode[] catchRoots = statementRoot.getChild(2).getChildren();
        for (int i = 0; i < catchRoots.length; ++i) {
            String exceptionType = this.resolvedQualifiedNameNotNull(catchRoots[i].getChild(0));
            String identifier = this.identifier(catchRoots[i].getChild(1));
            BlockStatement block = this.statementBlock(catchRoots[i].getChild(2));
            tcf.addCatch(new CatchStatement(exceptionType, identifier, block));
        }
        return tcf;
    }

    protected ReturnStatement returnStatement(CSTNode statementRoot) throws ParserException {
        if (statementRoot.children() > 0) {
            return new ReturnStatement(this.expression(statementRoot.getChild(0)));
        }
        return ReturnStatement.RETURN_VOID;
    }

    protected ForStatement forStatement(CSTNode statementRoot) throws ParserException {
        CSTNode variableNode = statementRoot.getChild(0);
        String variable = variableNode.getToken().getText();
        Type variableType = Type.DYNAMIC_TYPE;
        if (variableNode.getChildren().length > 0) {
            variableType = new Type(this.resolvedQualifiedNameNotNull(variableNode.getChild(0)));
        }
        Expression collectionExpr = this.expression(statementRoot.getChild(1));
        BlockStatement bodyBlock = this.statementOrStatementBlock(statementRoot.getChild(2));
        return new ForStatement(variable, variableType, collectionExpr, bodyBlock);
    }

    protected AssertStatement assertStatement(CSTNode statementRoot) throws ParserException {
        BooleanExpression assertExpr = new BooleanExpression(this.expression(statementRoot.getChild(0)));
        CSTNode messageRoot = statementRoot.getChild(1);
        Expression messageExpr = null;
        messageExpr = messageRoot.getToken() == null ? ConstantExpression.NULL : this.expression(messageRoot);
        return new AssertStatement(assertExpr, messageExpr);
    }

    protected Statement expressionStatement(CSTNode statementRoot) throws ParserException {
        Expression expression = this.expression(statementRoot);
        return new ExpressionStatement(expression);
    }

    protected Expression expression(CSTNode expressionRoot) throws ParserException {
        Expression expression = this.makeExpression(expressionRoot);
        expression.setCSTNode(expressionRoot);
        return expression;
    }

    protected Expression makeExpression(CSTNode expressionRoot) throws ParserException {
        switch (expressionRoot.getToken().getType()) {
            case 210: {
                if (expressionRoot.getChildren().length == 1) {
                    return this.negationExpression(expressionRoot);
                }
            }
            case 30: 
            case 90: 
            case 100: 
            case 105: 
            case 106: 
            case 110: 
            case 115: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 155: 
            case 160: 
            case 170: 
            case 180: 
            case 200: 
            case 230: 
            case 240: 
            case 250: 
            case 260: 
            case 270: 
            case 280: 
            case 290: 
            case 317: 
            case 318: 
            case 520: {
                return this.binaryExpression(expressionRoot);
            }
            case 310: {
                return this.ternaryExpression(expressionRoot);
            }
            case 810: {
                return this.postfixExpression(expressionRoot);
            }
            case 811: {
                return this.prefixExpression(expressionRoot);
            }
            case 75: {
                return this.rangeExpression(expressionRoot, true);
            }
            case 77: {
                return this.rangeExpression(expressionRoot, false);
            }
            case 330: 
            case 350: 
            case 351: 
            case 539: 
            case 540: 
            case 542: {
                return this.constantExpression(expressionRoot);
            }
            case 320: {
                GStringExpression gstring = this.compositeStringExpression(expressionRoot);
                if (gstring.isConstantString()) {
                    return gstring.asConstantString();
                }
                return gstring;
            }
            case 107: {
                Expression string = this.expression(expressionRoot.getChild(0));
                RegexExpression regex = new RegexExpression(string);
                return regex;
            }
            case 340: {
                Expression expression = this.variableOrClassExpression(expressionRoot);
                return expression;
            }
            case 530: 
            case 533: {
                return this.variableExpression(expressionRoot);
            }
            case 70: {
                return this.propertyExpression(expressionRoot);
            }
            case 158: {
                return this.safePropertyExpression(expressionRoot);
            }
            case 802: {
                return this.listExpression(expressionRoot);
            }
            case 803: {
                return this.mapExpression(expressionRoot);
            }
            case 50: {
                return this.methodCallExpression(expressionRoot);
            }
            case 10: {
                return this.closureExpression(expressionRoot);
            }
            case 523: {
                return this.newExpression(expressionRoot);
            }
            case 80: {
                return this.notExpression(expressionRoot);
            }
            case 815: {
                return this.castExpression(expressionRoot);
            }
        }
        throw new RuntimeException(expressionRoot.getToken().getStartLine() + ": cannot create expression for node: " + expressionRoot);
    }

    protected Expression castExpression(CSTNode root) throws ParserException {
        CSTNode typeExpression = root.getChild(0);
        CSTNode expressionRoot = root.getChild(1);
        return new CastExpression(this.resolveName(typeExpression.getToken().getText()), this.expression(expressionRoot));
    }

    protected Expression postfixExpression(CSTNode root) throws ParserException {
        CSTNode expressionRoot = root.getChild(0);
        return new PostfixExpression(this.expression(expressionRoot.getChild(0)), expressionRoot.getToken());
    }

    protected Expression prefixExpression(CSTNode root) throws ParserException {
        CSTNode expressionRoot = root.getChild(0);
        return new PrefixExpression(expressionRoot.getToken(), this.expression(expressionRoot.getChild(0)));
    }

    protected Expression notExpression(CSTNode expressionRoot) throws ParserException {
        NotExpression notExpression = new NotExpression(this.expression(expressionRoot.getChild(0)));
        return notExpression;
    }

    protected Expression negationExpression(CSTNode expressionRoot) throws ParserException {
        NegationExpression negationExpression = new NegationExpression(this.expression(expressionRoot.getChild(0)));
        return negationExpression;
    }

    protected GStringExpression compositeStringExpression(CSTNode expressionRoot) throws ParserException {
        GStringExpression expr = new GStringExpression(expressionRoot.getToken().getText());
        CSTNode[] children = expressionRoot.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.matches(children[i], 330)) {
                ConstantExpression constantExpression = this.constantExpression(children[i]);
                if (constantExpression == null) continue;
                expr.addString(constantExpression);
                continue;
            }
            Expression expression = this.expression(children[i]);
            expr.addValue(expression);
        }
        return expr;
    }

    protected Expression newExpression(CSTNode expressionRoot) throws ParserException {
        String datatype = this.resolvedQualifiedNameNotNull(expressionRoot.getChild(0));
        CSTNode node = expressionRoot.getChild(1);
        if (node.getToken().getType() == 30) {
            CSTNode next = expressionRoot.getChild(2);
            if (next.getToken().getType() == 10) {
                TupleExpression args = this.nonNamedActualParameterList(expressionRoot.getChild(3));
                return new ArrayExpression(datatype, args.getExpressions());
            }
            return new ArrayExpression(datatype, this.expression(next));
        }
        Expression args = this.actualParameterList(expressionRoot.getChild(1));
        return new ConstructorCallExpression(datatype, args);
    }

    protected ClosureExpression closureExpression(CSTNode expressionRoot) throws ParserException {
        Parameter[] parameters = this.parameters(expressionRoot.getChild(0).getChildren());
        ClosureExpression answer = new ClosureExpression(parameters, this.statementBlock(expressionRoot.getChild(1)));
        answer.setCSTNode(expressionRoot);
        return answer;
    }

    protected MethodCallExpression methodCallExpression(CSTNode expressionRoot) throws ParserException {
        CSTNode notExpr;
        CSTNode objectExpressionRoot = expressionRoot.getChild(0);
        Expression objectExpression = null;
        boolean implicitThis = false;
        if (objectExpressionRoot.getToken() == null) {
            objectExpression = VariableExpression.THIS_EXPRESSION;
            implicitThis = true;
        } else {
            objectExpression = this.expression(expressionRoot.getChild(0));
        }
        String methodName = expressionRoot.getChild(1).getToken().getText();
        Expression paramList = this.actualParameterList(expressionRoot.getChild(2));
        MethodCallExpression answer = new MethodCallExpression(objectExpression, methodName, paramList);
        answer.setImplicitThis(implicitThis);
        if (expressionRoot.getChildren().length > 3 && (notExpr = expressionRoot.getChild(3)) != null && notExpr.getToken().getType() == 158) {
            answer.setSafe(true);
        }
        return answer;
    }

    protected Expression actualParameterList(CSTNode paramRoot) throws ParserException {
        Expression paramList = null;
        CSTNode[] paramRoots = paramRoot.getChildren();
        paramList = paramRoots.length > 0 && this.matches(paramRoots[0], 300) ? this.namedActualParameterList(paramRoot) : this.nonNamedActualParameterList(paramRoot);
        return paramList;
    }

    protected Expression namedActualParameterList(CSTNode paramRoot) throws ParserException {
        TupleExpression paramList = new TupleExpression();
        CSTNode[] paramRoots = paramRoot.getChildren();
        MapExpression map = new MapExpression();
        paramList.addExpression(map);
        for (int i = 0; i < paramRoots.length; ++i) {
            if (!this.matches(paramRoots[i], 300)) {
                if (!this.matches(paramRoots[i], 10)) break;
                paramList.addExpression(this.closureExpression(paramRoots[i]));
                break;
            }
            CSTNode keyRoot = paramRoots[i].getChild(0);
            CSTNode valueRoot = paramRoots[i].getChild(1);
            ConstantExpression keyExpr = new ConstantExpression(keyRoot.getToken().getText());
            keyExpr.setCSTNode(keyRoot);
            Expression valueExpr = this.expression(valueRoot);
            map.addMapEntryExpression(keyExpr, valueExpr);
        }
        return paramList;
    }

    protected TupleExpression nonNamedActualParameterList(CSTNode paramRoot) throws ParserException {
        return this.tupleExpression(paramRoot);
    }

    protected TupleExpression tupleExpression(CSTNode expressionRoot) throws ParserException {
        TupleExpression tupleExpression = new TupleExpression();
        CSTNode[] exprRoots = expressionRoot.getChildren();
        for (int i = 0; i < exprRoots.length; ++i) {
            tupleExpression.addExpression(this.expression(exprRoots[i]));
        }
        return tupleExpression;
    }

    protected ListExpression listExpression(CSTNode expressionRoot) throws ParserException {
        ListExpression listExpression = new ListExpression();
        CSTNode[] exprRoots = expressionRoot.getChildren();
        for (int i = 0; i < exprRoots.length; ++i) {
            listExpression.addExpression(this.expression(exprRoots[i]));
        }
        return listExpression;
    }

    protected MapExpression mapExpression(CSTNode expressionRoot) throws ParserException {
        MapExpression mapExpression = new MapExpression();
        CSTNode[] entryRoots = expressionRoot.getChildren();
        for (int i = 0; i < entryRoots.length; ++i) {
            Expression keyExpression = this.expression(entryRoots[i].getChild(0));
            Expression valueExpression = this.expression(entryRoots[i].getChild(1));
            MapEntryExpression entryExpression = new MapEntryExpression(keyExpression, valueExpression);
            mapExpression.addMapEntryExpression(entryExpression);
        }
        return mapExpression;
    }

    protected RangeExpression rangeExpression(CSTNode expressionRoot, boolean inclusive) throws ParserException {
        Expression toExp = this.expression(expressionRoot.getChild(1));
        return new RangeExpression(this.expression(expressionRoot.getChild(0)), toExp, inclusive);
    }

    protected Expression propertyExpression(CSTNode expressionRoot) throws ParserException {
        Expression objectExpression = this.expression(expressionRoot.getChild(0));
        String propertyName = expressionRoot.getChild(1).getToken().getText();
        return new PropertyExpression(objectExpression, propertyName);
    }

    protected Expression safePropertyExpression(CSTNode expressionRoot) throws ParserException {
        Expression objectExpression = this.expression(expressionRoot.getChild(0));
        String propertyName = expressionRoot.getChild(1).getToken().getText();
        return new PropertyExpression(objectExpression, propertyName, true);
    }

    protected Expression variableOrClassExpression(CSTNode expressionRoot) {
        String text = expressionRoot.getToken().getText();
        if (this.isDatatype(text)) {
            return new ClassExpression(this.resolveName(text));
        }
        return this.variableExpression(expressionRoot);
    }

    protected VariableExpression variableExpression(CSTNode expressionRoot) {
        VariableExpression answer = new VariableExpression(expressionRoot.getToken().getText());
        if (expressionRoot.getChildren().length > 0) {
            answer.setType(this.resolveName(expressionRoot.getChild(0).getToken().getText()));
        }
        return answer;
    }

    protected ConstantExpression constantExpression(CSTNode expressionRoot) {
        ConstantExpression expr = null;
        switch (expressionRoot.getToken().getType()) {
            case 542: {
                expr = ConstantExpression.NULL;
                break;
            }
            case 539: {
                expr = ConstantExpression.TRUE;
                break;
            }
            case 540: {
                expr = ConstantExpression.FALSE;
                break;
            }
            case 330: {
                expr = new ConstantExpression(expressionRoot.getToken().getText());
                break;
            }
            case 320: {
                expr = new ConstantExpression(expressionRoot.getToken().getText());
                break;
            }
            case 350: {
                expr = new ConstantExpression(this.createInteger(expressionRoot.getToken().getText()));
                break;
            }
            case 351: {
                expr = new ConstantExpression(new Double(expressionRoot.getToken().getText()));
            }
        }
        return expr;
    }

    protected Number createInteger(String text) {
        Long answer = new Long(text);
        long l = answer;
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return new Integer((int)l);
        }
        return answer;
    }

    protected BinaryExpression binaryExpression(CSTNode expressionRoot) throws ParserException {
        Expression lhsExpression = this.expression(expressionRoot.getChild(0));
        Expression rhsExpression = null;
        CSTNode classNode = expressionRoot.getChild(1);
        if (expressionRoot.getToken().getType() == 520) {
            String name = this.resolvedQualifiedName(classNode);
            if (name == null) {
                name = this.identifier(classNode);
            }
            rhsExpression = new ClassExpression(name);
        } else {
            rhsExpression = this.expression(classNode);
        }
        return new BinaryExpression(lhsExpression, expressionRoot.getToken(), rhsExpression);
    }

    protected TernaryExpression ternaryExpression(CSTNode expressionRoot) throws ParserException {
        BooleanExpression booleanExpression = new BooleanExpression(this.expression(expressionRoot.getChild(0)));
        Expression trueExpression = this.expression(expressionRoot.getChild(1));
        Expression falseExpression = this.expression(expressionRoot.getChild(2));
        return new TernaryExpression(booleanExpression, trueExpression, falseExpression);
    }

    protected int modifiers(CSTNode modifiersRoot) {
        CSTNode[] modifierNodes = modifiersRoot.getChildren();
        int modifiers = 0;
        block7: for (int i = 0; i < modifierNodes.length; ++i) {
            switch (modifierNodes[i].getToken().getType()) {
                case 527: {
                    modifiers |= 1;
                    continue block7;
                }
                case 526: {
                    modifiers |= 4;
                    continue block7;
                }
                case 525: {
                    modifiers |= 2;
                    continue block7;
                }
                case 529: {
                    modifiers |= 8;
                    continue block7;
                }
                case 501: {
                    modifiers |= 0x400;
                    continue block7;
                }
            }
        }
        if ((modifiers & 6) == 0) {
            modifiers |= 1;
        }
        return modifiers;
    }

    protected String identifier(CSTNode identifierRoot) {
        return identifierRoot.getToken().getText();
    }

    boolean matches(CSTNode root, int rootType) {
        return root.getToken() != null && root.getToken().getType() == rootType;
    }

    boolean matches(CSTNode root, int rootType, int c1Type) {
        return this.matches(root, rootType) && root.getChild(1) != null && root.getChild(1).getToken() != null && root.getChild(1).getToken().getType() == c1Type;
    }

    boolean matches(CSTNode root, int rootType, int c1Type, int c2Type) {
        return this.matches(root, rootType, c1Type) && root.getChild(2) != null && root.getChild(2).getToken() != null && root.getChild(2).getToken().getType() == c2Type;
    }

    boolean matches(CSTNode root, int rootType, int c1Type, int c2Type, int c3Type) {
        return this.matches(root, rootType, c1Type) && root.getChild(3) != null && root.getChild(3).getToken() != null && root.getChild(3).getToken().getType() == c3Type;
    }
}

