/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.servlet.HTML;
import ccl.util.DBUtil;
import ccl.util.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * This abstract servlet gets a connection and then looks
 * for all user tables in that database and prints them
 * out. The user can then select a single table to see all
 * column definition on a dedicated html page.
 *
 * @author Chr. Clemens Lee
 * @version $Header: /home/clemens/src/java/ccl/src/ccl/servlet/RCS/TableHelpServlet.java,v 1.9 2003/05/01 16:44:04 clemens Exp clemens $
 */
abstract public class TableHelpServlet extends HttpServlet
{
    /**
     * The main servlet method. It uses the parent class
     * to receive a db connection and to print the 
     * application layout.
     *
     * @exception   IOException    in case anything goes wrong
     *                             writing output to the http
     *                             servlet response.
     * @exception   ServletException   in case the servlet has a failure.
     */
    public void doGet(  HttpServletRequest  request
                       ,HttpServletResponse response )
        throws  IOException
               ,ServletException
    {
        try
        {
            HTML html = new HTML( response );

            printTitle( html );

            printTOC( html );

            Connection connection = createConnection();

            Vector vTables = DBUtil.getUserTables( connection );
            Enumeration eTables = vTables.elements();
            while( eTables.hasMoreElements() )
            {
                String sTable = (String)eTables.nextElement();
                html.printBR( "<a href=\"" 
                              + this.getClass().getName()
                              + "?table="
                              + sTable
                              + "\">"
                              + sTable
                              + "</a>" );
            }

            String sTable = request.getParameter( "table" );
            if ( !Util.isEmpty( sTable ) )
            {

                DatabaseMetaData metaData = connection.getMetaData();

                ResultSet result = metaData.getColumns( null
                                                        , null
                                                        , sTable
                                                        , null );
                html.println( "<h2>Table '" + sTable + "'</h2>" );
                html.printDataTableStart( "#ffc000", "#c8c8c8" );
                html.printDataTableHeader( "Nr.", "right" );
                html.printDataTableHeader( "Name" );
                html.printDataTableHeader( "Type" );
                html.printDataTableHeader( "Null" );
                html.endDataTableLine();
                int row = 1;
                while( result.next() ) 
                {
                    String sColumn = result.getString( "COLUMN_NAME" );
                    html.printDataTableValue( Util.itoa( row ), "right" );
                    html.printDataTableValue( sColumn );
                    html.printDataTableValue( result.getString( "TYPE_NAME" ) );
                    html.printDataTableValue( result.getString( "IS_NULLABLE" ) );
                    html.endDataTableLine();
                    row++;
                }
                html.printTableEnd();
                result.close();
            }

            connection.close();

            close( html );
        }
        catch( Exception exception )
        {
            new ServletException( Util.getStackTrace( exception ) );
        }
    }

    /**
     * The parent class knows how to print its title.
     */
    abstract public void printTitle( HTML html );

    /**
     * The parent class knows how to print its table of 
     * content.
     *
     * @exception   Exception   if anything goes wrong.
     */
    abstract public void printTOC( HTML html )
        throws Exception;

    /**
     * The parent class knows how to close the html code.
     */
    abstract public void close( HTML html );

    /**
     * Returns the connection to find all db tables.
     * Connection will be closed by this class after usage.
     *
     * @exception   SQLException   if anything goes wrong.
     */
    abstract public Connection createConnection()
        throws SQLException;
}
