/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.asm.OrderInnerOutterInsnNodeClassAdapter;
import com.googlecode.dex2jar.v3.AnnotationNode;
import com.googlecode.dex2jar.v3.DexExceptionHandler;
import com.googlecode.dex2jar.v3.V3FieldAdapter;
import com.googlecode.dex2jar.v3.V3InnerClzGather;
import com.googlecode.dex2jar.v3.V3MethodAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class V3ClassAdapter
implements DexClassVisitor {
    protected int access_flags;
    protected Map<String, Object> annotationDefaults;
    protected List<AnnotationNode> anns = new ArrayList<AnnotationNode>();
    protected boolean build = false;
    protected String className;
    protected V3InnerClzGather.Clz clz;
    protected int config;
    protected ClassVisitor cv;
    protected DexExceptionHandler exceptionHandler;
    protected String file;
    protected String[] interfaceNames;
    protected String superClass;

    public V3ClassAdapter(V3InnerClzGather.Clz clz, DexExceptionHandler exceptionHandler, ClassVisitor cv, int access_flags, String className, String superClass, String[] interfaceNames) {
        this(clz, exceptionHandler, cv, access_flags, className, superClass, interfaceNames, 0);
    }

    public V3ClassAdapter(V3InnerClzGather.Clz clz, DexExceptionHandler exceptionHandler, ClassVisitor cv, int access_flags, String className, String superClass, String[] interfaceNames, int config) {
        this.clz = clz;
        this.cv = new OrderInnerOutterInsnNodeClassAdapter(cv);
        this.access_flags = access_flags;
        this.className = className;
        this.superClass = superClass;
        this.interfaceNames = interfaceNames;
        this.exceptionHandler = exceptionHandler;
        this.config = config;
    }

    static String buildSignature(AnnotationNode ann) {
        for (AnnotationNode.Item item : ann.items) {
            if (!item.name.equals("value")) continue;
            List values = (List)item.value;
            StringBuilder sb = new StringBuilder();
            for (Object i : values) {
                sb.append(i.toString());
            }
            return sb.toString();
        }
        return null;
    }

    protected void build() {
        if (!this.build) {
            String signature = null;
            Iterator<AnnotationNode> it = this.anns.iterator();
            while (it.hasNext()) {
                AnnotationNode ann = it.next();
                if (!"Ldalvik/annotation/Signature;".equals(ann.type)) continue;
                it.remove();
                signature = V3ClassAdapter.buildSignature(ann);
            }
            V3InnerClzGather.Clz clz = this.clz;
            int access = clz.access;
            boolean isInnerClass = clz.enclosingClass != null || clz.enclosingMethod != null;
            int accessInClass = this.clearClassAccess(isInnerClass, access);
            String[] nInterfaceNames = null;
            if (this.interfaceNames != null) {
                nInterfaceNames = new String[this.interfaceNames.length];
                int i = 0;
                while (i < this.interfaceNames.length) {
                    nInterfaceNames[i] = Type.getType((String)this.interfaceNames[i]).getInternalName();
                    ++i;
                }
            }
            this.cv.visit(50, accessInClass, Type.getType((String)this.className).getInternalName(), signature, this.superClass == null ? null : Type.getType((String)this.superClass).getInternalName(), nInterfaceNames);
            this.searchInnerClass(clz);
            if (isInnerClass) {
                if (clz.innerName == null) {
                    Method enclosingMethod = clz.enclosingMethod;
                    if (enclosingMethod != null) {
                        this.cv.visitOuterClass(Type.getType((String)enclosingMethod.getOwner()).getInternalName(), enclosingMethod.getName(), enclosingMethod.getDesc());
                    } else {
                        V3InnerClzGather.Clz enclosingClass = clz.enclosingClass;
                        this.cv.visitOuterClass(Type.getType((String)enclosingClass.name).getInternalName(), null, null);
                    }
                }
                this.searchEnclosing(clz);
            }
            for (AnnotationNode ann : this.anns) {
                ann.accept(this.cv);
            }
            if (this.file != null) {
                this.cv.visitSource(this.file, null);
            }
            this.build = true;
        }
    }

    private void searchEnclosing(V3InnerClzGather.Clz clz) {
        HashSet<V3InnerClzGather.Clz> visited = new HashSet<V3InnerClzGather.Clz>();
        V3InnerClzGather.Clz p = clz;
        while (p != null) {
            V3InnerClzGather.Clz enclosingClass = p.enclosingClass;
            if (enclosingClass == null || visited.contains(enclosingClass)) break;
            visited.add(enclosingClass);
            int accessInInner = this.clearInnerAccess(p.access);
            if (p.innerName != null) {
                this.cv.visitInnerClass(Type.getType((String)p.name).getInternalName(), Type.getType((String)enclosingClass.name).getInternalName(), p.innerName, accessInInner);
            } else {
                this.cv.visitInnerClass(Type.getType((String)p.name).getInternalName(), null, null, accessInInner);
            }
            p = p.enclosingClass;
        }
    }

    private void searchInnerClass(V3InnerClzGather.Clz clz) {
        HashSet<V3InnerClzGather.Clz> visited = new HashSet<V3InnerClzGather.Clz>();
        Stack<V3InnerClzGather.Clz> stack = new Stack<V3InnerClzGather.Clz>();
        stack.push(clz);
        while (!stack.empty()) {
            clz = (V3InnerClzGather.Clz)stack.pop();
            if (visited.contains(clz)) continue;
            visited.add(clz);
            if (clz.inners == null) continue;
            for (V3InnerClzGather.Clz inner : clz.inners) {
                if (inner.innerName == null) {
                    this.cv.visitInnerClass(Type.getType((String)inner.name).getInternalName(), null, null, this.clearInnerAccess(inner.access));
                } else {
                    this.cv.visitInnerClass(Type.getType((String)inner.name).getInternalName(), Type.getType((String)this.className).getInternalName(), inner.innerName, this.clearInnerAccess(inner.access));
                }
                stack.push(inner);
            }
        }
    }

    private int clearClassAccess(boolean isInner, int access) {
        if ((access & 0x200) == 0) {
            access |= 0x20;
        }
        if (isInner && ((access &= 0xFFFFFFF5) & 4) != 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        return access;
    }

    private int clearInnerAccess(int access) {
        if (((access &= 0xFFFFFFDF) & 2) != 0) {
            access &= 0xFFFFFFFA;
        } else if ((access & 4) != 0) {
            access &= 0xFFFFFFFE;
        }
        return access;
    }

    void putDefault(String name, Object value) {
        if (this.annotationDefaults == null) {
            this.annotationDefaults = new HashMap<String, Object>();
        }
        this.annotationDefaults.put(name, value);
    }

    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        if (name.equals("Ldalvik/annotation/EnclosingClass;") || name.equals("Ldalvik/annotation/EnclosingMethod;") || "Ldalvik/annotation/InnerClass;".equals(name) || "Ldalvik/annotation/MemberClasses;".equals(name)) {
            return null;
        }
        if (name.equals("Ldalvik/annotation/AnnotationDefault;")) {
            return new EmptyVisitor(){

                public DexAnnotationVisitor visitAnnotation(String name, String desc) {
                    return new AnnotationNode(){

                        @Override
                        public void visitEnd() {
                            for (AnnotationNode.Item item : this.items) {
                                V3ClassAdapter.this.putDefault(item.name, item.value);
                            }
                        }
                    };
                }
            };
        }
        AnnotationNode ann = new AnnotationNode(name, visible);
        this.anns.add(ann);
        return ann;
    }

    public void visitEnd() {
        this.build();
        this.cv.visitEnd();
    }

    public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
        this.build();
        if (value instanceof DexType) {
            value = Type.getType((String)((DexType)value).desc);
        }
        return new V3FieldAdapter(this.cv, accessFlags, field, value);
    }

    public DexMethodVisitor visitMethod(int accessFlags, Method method) {
        this.build();
        return new V3MethodAdapter(accessFlags, method, this.exceptionHandler, this.config){

            @Override
            public void visitEnd() {
                AnnotationVisitor av;
                Object value;
                super.visitEnd();
                if (V3ClassAdapter.this.annotationDefaults != null && (value = V3ClassAdapter.this.annotationDefaults.get(this.method.getName())) != null && (av = this.methodNode.visitAnnotationDefault()) != null) {
                    AnnotationNode.accept(null, value, av);
                    av.visitEnd();
                }
                this.methodNode.accept(V3ClassAdapter.this.cv);
            }
        };
    }

    public void visitSource(String file) {
        this.file = file;
    }
}

