/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.v3.AnnotationNode;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class V3InnerClzGather
implements DexFileVisitor {
    private Map<String, Clz> classes = new HashMap<String, Clz>();
    private static final int ACC_INTERFACE_ABSTRACT = 1536;

    private Clz get(String name) {
        Clz clz = this.classes.get(name);
        if (clz == null) {
            clz = new Clz(name);
            this.classes.put(name, clz);
        }
        return clz;
    }

    public Map<String, Clz> getClasses() {
        return this.classes;
    }

    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        final Clz clz = this.get(className);
        clz.access = clz.access & 0xFFFFF9FF | access_flags;
        return new EmptyVisitor(){
            protected List<AnnotationNode> anns = new ArrayList<AnnotationNode>();

            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                AnnotationNode ann = new AnnotationNode(name, visible);
                this.anns.add(ann);
                return ann;
            }

            public void visitEnd() {
                for (AnnotationNode ann : this.anns) {
                    if (ann.type.equals("Ldalvik/annotation/EnclosingClass;")) {
                        for (AnnotationNode.Item i : ann.items) {
                            if (!i.name.equals("value")) continue;
                            String value = i.value.toString();
                            if (value.equals(clz.name)) {
                                System.out.println("WARN: bad EnclosingClass find in " + clz.name + ", ignored");
                                continue;
                            }
                            clz.enclosingClass = V3InnerClzGather.this.get(value);
                            clz.enclosingClass.addInner(clz);
                        }
                        continue;
                    }
                    if (ann.type.equals("Ldalvik/annotation/EnclosingMethod;")) {
                        for (AnnotationNode.Item i : ann.items) {
                            Method m;
                            if (!"value".equals(i.name) || (m = (Method)i.value) == null) continue;
                            clz.enclosingMethod = m;
                            clz.enclosingClass = V3InnerClzGather.this.get(clz.enclosingMethod.getOwner());
                            clz.enclosingClass.addInner(clz);
                        }
                        continue;
                    }
                    if ("Ldalvik/annotation/InnerClass;".equals(ann.type)) {
                        for (AnnotationNode.Item it : ann.items) {
                            if ("accessFlags".equals(it.name)) {
                                clz.access |= (Integer)it.value & 0xFFFFF9FF;
                                continue;
                            }
                            if (!"name".equals(it.name)) continue;
                            clz.innerName = (String)it.value;
                        }
                        continue;
                    }
                    if (!"Ldalvik/annotation/MemberClasses;".equals(ann.type)) continue;
                    for (AnnotationNode.Item it : ann.items) {
                        if (!"value".equals(it.name)) continue;
                        List members = (List)it.value;
                        for (Object member : members) {
                            DexType type = (DexType)member;
                            Clz inner = V3InnerClzGather.this.get(type.desc);
                            clz.addInner(inner);
                            inner.enclosingClass = clz;
                        }
                    }
                }
            }
        };
    }

    public void visitEnd() {
    }

    public static class Clz {
        public int access;
        public Clz enclosingClass;
        public Method enclosingMethod;
        public String innerName;
        public Set<Clz> inners = null;
        public final String name;

        public Clz(String name) {
            this.name = name;
        }

        void addInner(Clz clz) {
            if (this.inners == null) {
                this.inners = new HashSet<Clz>();
            }
            this.inners.add(clz);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Clz other = (Clz)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            return this.name;
        }
    }
}

