/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.expr;

import com.googlecode.dex2jar.ir.ToStringUtil;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import org.objectweb.asm.Type;

public class TypeExpr
extends Value.E1Expr {
    public Type type;

    public TypeExpr(Value.VT vt, Value value, Type type) {
        super(vt, new ValueBox(value));
        this.type = type;
    }

    @Override
    public Value clone() {
        return new TypeExpr(this.vt, this.op.value.clone(), this.type);
    }

    public String toString() {
        switch (this.vt) {
            case CHECK_CAST: {
                return "((" + ToStringUtil.toShortClassName(this.type) + ")" + this.op + ")";
            }
            case INSTANCE_OF: {
                return "(" + this.op + " instanceof " + ToStringUtil.toShortClassName(this.type) + ")";
            }
            case NEW_ARRAY: {
                if (this.type.getSort() == 9) {
                    StringBuilder sb = new StringBuilder("new ").append(ToStringUtil.toShortClassName(this.type.getElementType())).append("[").append(this.op).append("]");
                    int i = 0;
                    while (i < this.type.getDimensions()) {
                        sb.append("[]");
                        ++i;
                    }
                    return sb.toString();
                }
                return "new " + ToStringUtil.toShortClassName(this.type) + "[" + this.op + "]";
            }
        }
        return "UNKNOW";
    }
}

