/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.BinopExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.UnopExpr;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.Type;

public class TypeAnalyze {
    protected IrMethod method;
    List<DefTypeRef> refs = new ArrayList<DefTypeRef>();

    public TypeAnalyze(IrMethod method) {
        this.method = method;
    }

    public List<DefTypeRef> analyze() {
        this.sxStmt();
        this.fixProvidAs();
        return this.refs;
    }

    private void e0expr(Value.E0Expr op) {
        switch (op.vt) {
            case LOCAL: {
                break;
            }
            case NEW: {
                NewExpr newExpr = (NewExpr)op;
                this.provideAs(newExpr, newExpr.type);
                break;
            }
            case EXCEPTION_REF: 
            case PARAMETER_REF: 
            case THIS_REF: {
                RefExpr refExpr = (RefExpr)op;
                Type refType = refExpr.type;
                if (refType == null && op.vt == Value.VT.EXCEPTION_REF) {
                    refType = Type.getType(Throwable.class);
                }
                this.provideAs(refExpr, refType);
                break;
            }
            case CONSTANT: {
                Constant cst = (Constant)op;
                Object value = cst.value;
                if (value instanceof String) {
                    this.provideAs(cst, Type.getType(String.class));
                    break;
                }
                if (value instanceof Type) {
                    this.provideAs(cst, Type.getType(Class.class));
                    break;
                }
                if (!(value instanceof Number)) break;
                if (value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Character) {
                    int a = ((Number)value).intValue();
                    if (a >= 0 && a <= 1) {
                        this.provideAs(cst, Type.BOOLEAN_TYPE);
                        break;
                    }
                    if (a >= -128 && a <= 127) {
                        this.provideAs(cst, Type.BYTE_TYPE);
                        break;
                    }
                    if (a >= Short.MIN_VALUE && a <= Short.MAX_VALUE) {
                        this.provideAs(cst, Type.SHORT_TYPE);
                        break;
                    }
                    if (a >= 0 && a <= 65535) {
                        this.provideAs(cst, Type.CHAR_TYPE);
                        break;
                    }
                    this.provideAs(cst, Type.INT_TYPE);
                    break;
                }
                if (value instanceof Long) {
                    this.provideAs(cst, Type.LONG_TYPE);
                    break;
                }
                if (value instanceof Float) {
                    this.provideAs(cst, Type.FLOAT_TYPE);
                    break;
                }
                if (!(value instanceof Double)) break;
                this.provideAs(cst, Type.DOUBLE_TYPE);
            }
        }
    }

    private void e1expr(Value.E1Expr e1, boolean getValue) {
        Value v = e1.op != null ? e1.op.value : null;
        switch (e1.vt) {
            case CAST: {
                CastExpr ce = (CastExpr)e1;
                this.useAs(v, ce.from);
                this.provideAs(e1, ce.to);
                break;
            }
            case FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                if (getValue) {
                    this.provideAs(fe, fe.fieldType);
                } else {
                    this.useAs(fe, fe.fieldType);
                }
                if (v == null) break;
                this.useAs(v, fe.fieldOwnerType);
                break;
            }
            case CHECK_CAST: {
                TypeExpr te = (TypeExpr)e1;
                this.provideAs(te, te.type);
                this.useAs(v, Type.getType(Object.class));
                break;
            }
            case INSTANCE_OF: {
                TypeExpr te = (TypeExpr)e1;
                this.provideAs(te, Type.BOOLEAN_TYPE);
                this.useAs(v, Type.getType(Object.class));
                break;
            }
            case NEW_ARRAY: {
                TypeExpr te = (TypeExpr)e1;
                this.provideAs(te, Type.getType((String)("[" + te.type.getDescriptor())));
                this.useAs(v, Type.INT_TYPE);
                break;
            }
            case LENGTH: {
                UnopExpr ue = (UnopExpr)e1;
                this.provideAs(ue, Type.INT_TYPE);
                this.useAs(v, Type.getType(Object.class));
                break;
            }
            case NEG: 
            case NOT: {
                UnopExpr ue = (UnopExpr)e1;
                this.provideAs(ue, ue.type);
                this.useAs(v, ue.type);
            }
        }
        if (v != null) {
            this.exExpr(v);
        }
    }

    private void e2expr(Value.E2Expr e2) {
        Value a = e2.op1.value;
        Value b = e2.op2.value;
        switch (e2.vt) {
            case ARRAY: {
                this.useAs(b, Type.INT_TYPE);
                this.useAs(a, Type.getType(Object.class));
                this.linkArray(a, e2);
                break;
            }
            case LCMP: 
            case FCMPG: 
            case FCMPL: 
            case DCMPG: 
            case DCMPL: {
                BinopExpr be = (BinopExpr)e2;
                this.useAs(a, be.type);
                this.useAs(b, be.type);
                this.provideAs(e2, Type.INT_TYPE);
                break;
            }
            case EQ: 
            case NE: {
                if (a.vt == Value.VT.CONSTANT && Integer.valueOf(0).equals(((Constant)a).value) || b.vt == Value.VT.CONSTANT && Integer.valueOf(0).equals(((Constant)b).value)) {
                    this.useAs(a, Type.BOOLEAN_TYPE);
                    this.useAs(b, Type.BOOLEAN_TYPE);
                    this.sameAs(a, b);
                } else {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                }
                this.provideAs(e2, Type.BOOLEAN_TYPE);
                break;
            }
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                BinopExpr be = (BinopExpr)e2;
                this.useAs(a, be.type);
                this.useAs(b, be.type);
                this.provideAs(e2, Type.BOOLEAN_TYPE);
                break;
            }
            case ADD: 
            case AND: 
            case DIV: 
            case MUL: 
            case OR: 
            case REM: 
            case SUB: 
            case XOR: {
                BinopExpr be = (BinopExpr)e2;
                this.useAs(a, be.type);
                this.useAs(b, be.type);
                this.provideAs(e2, be.type);
                break;
            }
            case SHL: 
            case SHR: 
            case USHR: {
                BinopExpr be = (BinopExpr)e2;
                this.useAs(a, be.type);
                this.useAs(b, Type.INT_TYPE);
                this.provideAs(e2, be.type);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (a != null) {
            this.exExpr(a);
        }
        if (b != null) {
            this.exExpr(b);
        }
    }

    private void sameAs(Value a, Value b) {
        DefTypeRef aa = this.getDefTypeRef(a);
        DefTypeRef bb = this.getDefTypeRef(b);
        aa.sameValues.add(bb);
        bb.sameValues.add(aa);
    }

    private void enexpr(Value.EnExpr enExpr) {
        ValueBox[] vbs = enExpr.ops;
        switch (enExpr.vt) {
            case INVOKE_INTERFACE: 
            case INVOKE_NEW: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: 
            case INVOKE_VIRTUAL: {
                InvokeExpr ie = (InvokeExpr)enExpr;
                this.provideAs(enExpr, ie.vt == Value.VT.INVOKE_NEW ? ie.methodOwnerType : ie.methodReturnType);
                int start = 0;
                if (ie.vt != Value.VT.INVOKE_STATIC && ie.vt != Value.VT.INVOKE_NEW) {
                    start = 1;
                    this.useAs(vbs[0].value, ie.methodOwnerType);
                }
                int i = 0;
                while (start < vbs.length) {
                    this.useAs(vbs[start].value, ie.argmentTypes[i]);
                    ++start;
                    ++i;
                }
                break;
            }
            case FILLED_ARRAY: {
                FilledArrayExpr fae = (FilledArrayExpr)enExpr;
                ValueBox[] valueBoxArray = vbs;
                int n3 = vbs.length;
                int n2 = 0;
                while (n2 < n3) {
                    ValueBox vb = valueBoxArray[n2];
                    this.useAs(vb.value, fae.type);
                    ++n2;
                }
                this.provideAs(fae, Type.getType((String)("[" + fae.type.getDescriptor())));
                break;
            }
            case NEW_MUTI_ARRAY: {
                NewMutiArrayExpr nmae = (NewMutiArrayExpr)enExpr;
                ValueBox[] valueBoxArray = vbs;
                int n = vbs.length;
                int n3 = 0;
                while (n3 < n) {
                    ValueBox vb = valueBoxArray[n3];
                    this.useAs(vb.value, Type.INT_TYPE);
                    ++n3;
                }
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < nmae.dimension) {
                    sb.append('[');
                    ++i;
                }
                sb.append(nmae.baseType.getDescriptor());
                this.provideAs(nmae, Type.getType((String)sb.toString()));
            }
        }
        ValueBox[] valueBoxArray = enExpr.ops;
        int n = enExpr.ops.length;
        int n4 = 0;
        while (n4 < n) {
            ValueBox vb = valueBoxArray[n4];
            this.exExpr(vb.value);
            ++n4;
        }
    }

    private void exExpr(Value op) {
        this.exExpr(op, true);
    }

    private void exExpr(Value op, boolean getValue) {
        switch (op.et) {
            case E0: {
                this.e0expr((Value.E0Expr)op);
                break;
            }
            case E1: {
                this.e1expr((Value.E1Expr)op, getValue);
                break;
            }
            case E2: {
                this.e2expr((Value.E2Expr)op);
                break;
            }
            case En: {
                this.enexpr((Value.EnExpr)op);
            }
        }
    }

    void fixProvidAs() {
        LinkedList<DefTypeRef> queue = new LinkedList<DefTypeRef>();
        queue.addAll(this.refs);
        HashSet<DefTypeRef> cache = new HashSet<DefTypeRef>();
        while (!queue.isEmpty()) {
            Type t;
            DefTypeRef ref = (DefTypeRef)queue.poll();
            if (ref.providerAs.size() > 0) {
                t = ref.providerAs.iterator().next();
                for (DefTypeRef subref : ref.tos) {
                    if (!subref.providerAs.addAll(ref.providerAs)) continue;
                    cache.add(subref);
                }
                if (ref.arrayValues.size() > 0 && t.getSort() == 9) {
                    Type elementType = Type.getType((String)t.getDescriptor().substring(1));
                    boolean object = false;
                    switch (elementType.getSort()) {
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            object = true;
                        }
                    }
                    for (DefTypeRef subref : ref.arrayValues) {
                        boolean needAdd = subref.providerAs.add(elementType);
                        if (object) {
                            boolean bl = needAdd = subref.useAs.add(elementType) || needAdd;
                        }
                        if (!needAdd) continue;
                        cache.add(subref);
                    }
                }
                switch (t.getSort()) {
                    case 9: 
                    case 10: {
                        t = Type.getType(Object.class);
                    }
                    case 6: 
                    case 8: {
                        ref.useAs.add(t);
                    }
                }
            }
            if (ref.useAs.size() > 0) {
                for (DefTypeRef subref : ref.froms) {
                    if (!subref.useAs.addAll(ref.useAs)) continue;
                    cache.add(subref);
                }
                t = ref.useAs.iterator().next();
                for (DefTypeRef subref : ref.sameValues) {
                    if (!subref.useAs.add(t)) continue;
                    cache.add(subref);
                }
            }
            for (DefTypeRef subref : cache) {
                if (queue.contains(subref)) continue;
                queue.add(subref);
            }
            cache.clear();
        }
    }

    private DefTypeRef getDefTypeRef(Value v) {
        DefTypeRef typeRef = (DefTypeRef)v.typeRef;
        if (typeRef == null) {
            typeRef = new DefTypeRef();
            typeRef.value = v;
            this.refs.add(typeRef);
            v.typeRef = typeRef;
        }
        return typeRef;
    }

    private void linkArray(Value array, Value v) {
        DefTypeRef root = this.getDefTypeRef(array);
        DefTypeRef value = this.getDefTypeRef(v);
        root.arrayValues.add(value);
        value.arryRoots.add(root);
    }

    private void linkFromTo(Value from, Value to) {
        DefTypeRef tFrom = this.getDefTypeRef(from);
        DefTypeRef tTo = this.getDefTypeRef(to);
        tFrom.tos.add(tTo);
        tTo.froms.add(tFrom);
    }

    private void provideAs(Value op, Type type) {
        this.getDefTypeRef((Value)op).providerAs.add(type);
    }

    private void s1stmt(Stmt.E1Stmt s) {
        if (s.st == Stmt.ST.GOTO) {
            return;
        }
        Value op = s.op.value;
        switch (s.st) {
            case LOOKUP_SWITCH: 
            case TABLE_SWITCH: {
                this.useAs(op, Type.INT_TYPE);
                break;
            }
            case GOTO: {
                break;
            }
            case IF: {
                this.useAs(op, Type.BOOLEAN_TYPE);
                break;
            }
            case LOCK: 
            case UNLOCK: {
                this.useAs(op, Type.getType(Object.class));
                break;
            }
            case THROW: {
                this.useAs(op, Type.getType(Throwable.class));
                break;
            }
            case RETURN: {
                this.useAs(op, this.method.ret);
            }
        }
        if (op != null) {
            this.exExpr(op);
        }
    }

    private void s2stmt(Stmt.E2Stmt s) {
        Value from = s.op2.value;
        Value to = s.op1.value;
        this.linkFromTo(from, to);
        this.exExpr(from);
        this.exExpr(to, false);
    }

    private void sxStmt() {
        Stmt p = this.method.stmts.getFirst();
        while (p != null) {
            switch (p.et) {
                case E0: {
                    break;
                }
                case E1: {
                    this.s1stmt((Stmt.E1Stmt)p);
                    break;
                }
                case E2: {
                    this.s2stmt((Stmt.E2Stmt)p);
                    break;
                }
            }
            p = p.getNext();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (DefTypeRef ref : this.refs) {
            sb.append(ref).append("\n");
        }
        return sb.toString();
    }

    private void useAs(Value op, Type type) {
        this.getDefTypeRef((Value)op).useAs.add(type);
    }

    public static class DefTypeRef
    implements Value.TypeRef {
        static Comparator<Type> c = new Comparator<Type>(){
            int[] x = new int[]{999, 1, 4, 2, 3, 5, 6, 7, 8, 10, 9};

            @Override
            public int compare(Type o1, Type o2) {
                int s2;
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                int s1 = o1.getSort();
                if (s1 == (s2 = o2.getSort())) {
                    switch (s1) {
                        case 10: {
                            if (o1.equals((Object)Type.getType(Object.class))) {
                                return 1;
                            }
                            if (o2.equals((Object)Type.getType(Object.class))) {
                                return -1;
                            }
                            return o1.getDescriptor().compareTo(o2.getDescriptor());
                        }
                        case 9: {
                            int a = o1.getDimensions();
                            int b = o2.getDimensions();
                            if (a == b) {
                                if (o1.getElementType().equals((Object)Type.getType(Object.class))) {
                                    return 1;
                                }
                                if (o2.getElementType().equals((Object)Type.getType(Object.class))) {
                                    return -1;
                                }
                                return o1.getElementType().getDescriptor().compareTo(o2.getElementType().getDescriptor());
                            }
                            return b - a;
                        }
                    }
                } else {
                    return this.x[s2] - this.x[s1];
                }
                return 0;
            }
        };
        public Set<DefTypeRef> sameValues = new HashSet<DefTypeRef>();
        public Set<DefTypeRef> arrayValues = new HashSet<DefTypeRef>();
        public Set<DefTypeRef> arryRoots = new HashSet<DefTypeRef>();
        public Set<DefTypeRef> froms = new HashSet<DefTypeRef>();
        public Set<Type> providerAs = new TreeSet<Type>(c);
        public Set<DefTypeRef> tos = new HashSet<DefTypeRef>();
        public Type type;
        public Set<Type> useAs = new TreeSet<Type>(c);
        Value value;

        private static String getShort(String desc) {
            char c = desc.charAt(0);
            if (c == '[') {
                StringBuilder sb = new StringBuilder();
                sb.append(c);
                int i = 1;
                while (i < desc.length()) {
                    c = desc.charAt(i);
                    if (c != '[') break;
                    sb.append(c);
                    ++i;
                }
                sb.append(c);
                return sb.toString();
            }
            return Character.toString(c);
        }

        @Override
        public Type get() {
            return this.type;
        }

        public String toString() {
            if (this.type != null) {
                return this.type.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.value).append(": ");
            if (this.providerAs != null) {
                for (Type t : this.providerAs) {
                    sb.append(DefTypeRef.getShort(t.getDescriptor()));
                }
            }
            sb.append(" > ");
            if (this.useAs != null) {
                for (Type t : this.useAs) {
                    sb.append(DefTypeRef.getShort(t.getDescriptor()));
                }
            }
            return sb.toString();
        }
    }
}

