/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.classify.Classification;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;

public class MaxEntConfidenceEstimator
extends TransducerConfidenceEstimator {
    MaxEntTrainer meTrainer;
    MaxEnt meClassifier;
    Pipe pipe;
    String correct;
    String incorrect;

    public MaxEntConfidenceEstimator(Transducer model, double gaussianVariance) {
        super(model);
        this.meTrainer = new MaxEntTrainer(gaussianVariance);
    }

    public MaxEntConfidenceEstimator(Transducer model) {
        this(model, 10.0);
    }

    public MaxEnt trainClassifier(InstanceList ilist, String correct, String incorrect) {
        this.meClassifier = this.meTrainer.train(ilist);
        this.pipe = ilist.getPipe();
        this.correct = correct;
        this.incorrect = incorrect;
        InfoGain ig = new InfoGain(ilist);
        int igl = Math.min(30, ig.numLocations());
        for (int i = 0; i < igl; ++i) {
            System.out.println("InfoGain[" + ig.getObjectAtRank(i) + "]=" + ig.getValueAtRank(i));
        }
        return this.meClassifier;
    }

    public double estimateConfidenceFor(Segment segment, SumLatticeDefault cachedLattice) {
        Classification c = this.meClassifier.classify(this.pipe.instanceFrom(new Instance(segment, segment.getTruth(), null, null)));
        return c.getLabelVector().value(this.correct);
    }
}

