/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharSubsequence
extends Pipe
implements Serializable {
    Pattern regex;
    int groupIndex;
    public static final Pattern SKIP_HEADER = Pattern.compile("\\n\\n(.*)\\z", 32);
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public CharSubsequence(Pattern regex, int groupIndex) {
        this.regex = regex;
        this.groupIndex = groupIndex;
    }

    public CharSubsequence(Pattern regex) {
        this(regex, 1);
    }

    public Instance pipe(Instance carrier) {
        CharSequence string = (CharSequence)carrier.getData();
        Matcher m = this.regex.matcher(string);
        if (m.find()) {
            carrier.setData(m.group(this.groupIndex));
            return carrier;
        }
        carrier.setData("");
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.regex);
        out.writeInt(this.groupIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.regex = (Pattern)in.readObject();
        this.groupIndex = in.readInt();
    }
}

