/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;

public class Input2CharSequence
extends Pipe
implements Serializable {
    String encoding = null;
    private static final long serialVersionUID = 2L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Input2CharSequence() {
    }

    public Input2CharSequence(String encoding) {
        this.encoding = encoding;
    }

    public Instance pipe(Instance carrier) {
        try {
            if (carrier.getData() instanceof URI) {
                carrier.setData(this.pipe((URI)carrier.getData()));
            } else if (carrier.getData() instanceof File) {
                carrier.setData(this.pipe((File)carrier.getData()));
            } else if (carrier.getData() instanceof Reader) {
                carrier.setData(this.pipe((Reader)carrier.getData()));
            } else if (!(carrier.getData() instanceof CharSequence)) {
                throw new IllegalArgumentException("Does not handle class " + carrier.getData().getClass());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException " + e);
        }
        return carrier;
    }

    public CharSequence pipe(URI uri) throws FileNotFoundException, IOException {
        if (!uri.getScheme().equals("file")) {
            throw new UnsupportedOperationException("Only file: scheme implemented.");
        }
        return this.pipe(new File(uri.getPath()));
    }

    public CharSequence pipe(File file) throws FileNotFoundException, IOException {
        BufferedReader br = null;
        br = this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        CharSequence cs = this.pipe(br);
        br.close();
        return cs;
    }

    public CharSequence pipe(Reader reader) throws IOException {
        int count;
        int BUFSIZE = 2048;
        char[] buf = new char[2048];
        StringBuffer sb = new StringBuffer(2048);
        while ((count = reader.read(buf, 0, 2048)) != -1) {
            sb.append(buf, 0, count);
            if (count == 2048) continue;
        }
        return sb;
    }

    public CharSequence pipe(CharSequence cs) {
        return cs;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        if (this.encoding == null) {
            out.writeObject("null");
        } else {
            out.writeObject(this.encoding);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.encoding = (String)in.readObject();
        if (this.encoding.equals("null")) {
            this.encoding = null;
        }
    }
}

