/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileLineIterator
implements Iterator<Instance> {
    BufferedReader reader = null;
    int index = -1;
    String currentLine = null;
    boolean hasNextUsed = false;
    int progressDisplayInterval = 0;

    public SimpleFileLineIterator(String filename) {
        try {
            this.reader = new BufferedReader(new FileReader(filename));
            this.index = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleFileLineIterator(File file) {
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.index = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setProgressDisplayInterval(int interval) {
        this.progressDisplayInterval = interval;
    }

    @Override
    public Instance next() {
        URI uri = null;
        try {
            uri = new URI("array:" + this.index++);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.hasNextUsed) {
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hasNextUsed = false;
        }
        if (this.progressDisplayInterval != 0 && this.index > 0 && this.index % this.progressDisplayInterval == 0) {
            System.out.println(this.index);
        }
        return new Instance(this.currentLine, null, uri, null);
    }

    @Override
    public boolean hasNext() {
        this.hasNextUsed = true;
        try {
            this.currentLine = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.currentLine != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

