/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRolloverAction
extends TransportMasterNodeAction<RolloverRequest, RolloverResponse> {
    private static final Pattern INDEX_NAME_PATTERN = Pattern.compile("^.*-\\d+$");
    private final MetaDataCreateIndexService createIndexService;
    private final MetaDataIndexAliasesService indexAliasesService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;

    @Inject
    public TransportRolloverAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetaDataIndexAliasesService indexAliasesService, Client client) {
        super(settings, "indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, RolloverRequest::new);
        this.createIndexService = createIndexService;
        this.indexAliasesService = indexAliasesService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(settings, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected RolloverResponse newResponse() {
        return new RolloverResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(final RolloverRequest rolloverRequest, ClusterState state, final ActionListener<RolloverResponse> listener) {
        final MetaData metaData = state.metaData();
        TransportRolloverAction.validate(metaData, rolloverRequest);
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(rolloverRequest.getAlias());
        IndexMetaData indexMetaData = aliasOrIndex.getIndices().get(0);
        String sourceProvidedName = indexMetaData.getSettings().get("index.provided_name", indexMetaData.getIndex().getName());
        final String sourceIndexName = indexMetaData.getIndex().getName();
        final String unresolvedName = rolloverRequest.getNewIndexName() != null ? rolloverRequest.getNewIndexName() : TransportRolloverAction.generateRolloverIndexName(sourceProvidedName, this.indexNameExpressionResolver);
        final String rolloverIndexName = this.indexNameExpressionResolver.resolveDateMathExpression(unresolvedName);
        MetaDataCreateIndexService.validateIndexName(rolloverIndexName, state);
        this.client.admin().indices().prepareStats(sourceIndexName).clear().setDocs(true).execute(new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse statsResponse) {
                Set<Condition.Result> conditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions(), metaData.index(sourceIndexName), statsResponse);
                if (rolloverRequest.isDryRun()) {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, true, false, false, false));
                    return;
                }
                if (conditionResults.size() == 0 || conditionResults.stream().anyMatch(result -> result.matched)) {
                    CreateIndexClusterStateUpdateRequest updateRequest = TransportRolloverAction.prepareCreateIndexRequest(unresolvedName, rolloverIndexName, rolloverRequest);
                    TransportRolloverAction.this.createIndexService.createIndex(updateRequest, ActionListener.wrap(createIndexClusterStateUpdateResponse -> TransportRolloverAction.this.indexAliasesService.indicesAliases(TransportRolloverAction.prepareRolloverAliasesUpdateRequest(sourceIndexName, rolloverIndexName, rolloverRequest), ActionListener.wrap(aliasClusterStateUpdateResponse -> {
                        if (aliasClusterStateUpdateResponse.isAcknowledged()) {
                            TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), rolloverRequest.masterNodeTimeout(), isShardsAcked -> listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, true, (boolean)isShardsAcked)), listener::onFailure);
                        } else {
                            listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, false, false));
                        }
                    }, listener::onFailure)), listener::onFailure));
                } else {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, false, false, false));
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static IndicesAliasesClusterStateUpdateRequest prepareRolloverAliasesUpdateRequest(String oldIndex, String newIndex, RolloverRequest request) {
        List<AliasAction> actions = Collections.unmodifiableList(Arrays.asList(new AliasAction.Add(newIndex, request.getAlias(), null, null, null), new AliasAction.Remove(oldIndex, request.getAlias())));
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(actions).ackTimeout(request.ackTimeout())).masterNodeTimeout(request.masterNodeTimeout());
        return updateRequest;
    }

    static String generateRolloverIndexName(String sourceIndexName, IndexNameExpressionResolver indexNameExpressionResolver) {
        boolean isDateMath;
        String resolvedName = indexNameExpressionResolver.resolveDateMathExpression(sourceIndexName);
        boolean bl = isDateMath = !sourceIndexName.equals(resolvedName);
        if (INDEX_NAME_PATTERN.matcher(resolvedName).matches()) {
            int numberIndex = sourceIndexName.lastIndexOf("-");
            assert (numberIndex != -1) : "no separator '-' found";
            int counter = Integer.parseInt(sourceIndexName.substring(numberIndex + 1, isDateMath ? sourceIndexName.length() - 1 : sourceIndexName.length()));
            String newName = sourceIndexName.substring(0, numberIndex) + "-" + String.format(Locale.ROOT, "%06d", ++counter) + (isDateMath ? ">" : "");
            return newName;
        }
        throw new IllegalArgumentException("index name [" + sourceIndexName + "] does not match pattern '^.*-\\d+$'");
    }

    static Set<Condition.Result> evaluateConditions(Set<Condition> conditions, DocsStats docsStats, IndexMetaData metaData) {
        long numDocs = docsStats == null ? 0L : docsStats.getCount();
        long indexSize = docsStats == null ? 0L : docsStats.getTotalSizeInBytes();
        Condition.Stats stats = new Condition.Stats(numDocs, metaData.getCreationDate(), new ByteSizeValue(indexSize));
        return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toSet());
    }

    static Set<Condition.Result> evaluateConditions(Set<Condition> conditions, IndexMetaData metaData, IndicesStatsResponse statsResponse) {
        return TransportRolloverAction.evaluateConditions(conditions, statsResponse.getPrimaries().getDocs(), metaData);
    }

    static void validate(MetaData metaData, RolloverRequest request) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(request.getAlias());
        if (aliasOrIndex == null) {
            throw new IllegalArgumentException("source alias does not exist");
        }
        if (!aliasOrIndex.isAlias()) {
            throw new IllegalArgumentException("source alias is a concrete index");
        }
        if (aliasOrIndex.getIndices().size() != 1) {
            throw new IllegalArgumentException("source alias maps to multiple indices");
        }
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(String providedIndexName, String targetIndexName, RolloverRequest rolloverRequest) {
        CreateIndexRequest createIndexRequest = rolloverRequest.getCreateIndexRequest();
        createIndexRequest.cause("rollover_index");
        createIndexRequest.index(targetIndexName);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(createIndexRequest, "rollover_index", targetIndexName, providedIndexName, true).ackTimeout(createIndexRequest.timeout())).masterNodeTimeout(createIndexRequest.masterNodeTimeout())).settings(createIndexRequest.settings()).aliases(createIndexRequest.aliases()).waitForActiveShards(ActiveShardCount.NONE).mappings(createIndexRequest.mappings());
    }
}

