/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.SynonymGraphTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private final Environment environment;
    private CustomAnalyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings, Environment environment) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
        this.environment = environment;
    }

    public void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        String tokenizerName = this.analyzerSettings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] must be configured with a tokenizer");
        }
        TokenizerFactory tokenizer = tokenizers.get(tokenizerName);
        if (tokenizer == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        List<String> charFilterNames = this.analyzerSettings.getAsList("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.size());
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            charFiltersList.add(charFilter);
        }
        int positionIncrementGap = 100;
        positionIncrementGap = this.analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = this.analyzerSettings.getAsInt("offset_gap", -1);
        List<String> tokenFilterNames = this.analyzerSettings.getAsList("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.size());
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            tokenFilter = CustomAnalyzerProvider.checkAndApplySynonymFilter(tokenFilter, tokenizerName, tokenizer, tokenFilterList, charFiltersList, this.environment);
            tokenFilterList.add(tokenFilter);
        }
        this.customAnalyzer = new CustomAnalyzer(tokenizerName, tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]), positionIncrementGap, offsetGap);
    }

    public static TokenFilterFactory checkAndApplySynonymFilter(TokenFilterFactory tokenFilter, String tokenizerName, TokenizerFactory tokenizer, List<TokenFilterFactory> tokenFilterList, List<CharFilterFactory> charFiltersList, Environment env) {
        if (tokenFilter instanceof SynonymGraphTokenFilterFactory) {
            ArrayList<TokenFilterFactory> tokenFiltersListForSynonym = new ArrayList<TokenFilterFactory>(tokenFilterList);
            try (CustomAnalyzer analyzer = new CustomAnalyzer(tokenizerName, tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFiltersListForSynonym.toArray(new TokenFilterFactory[tokenFiltersListForSynonym.size()]), 100, -1);){
                tokenFilter = ((SynonymGraphTokenFilterFactory)tokenFilter).createPerAnalyzerSynonymGraphFactory(analyzer, env);
            }
        }
        if (tokenFilter instanceof SynonymTokenFilterFactory) {
            ArrayList<TokenFilterFactory> tokenFiltersListForSynonym = new ArrayList<TokenFilterFactory>(tokenFilterList);
            try (CustomAnalyzer analyzer = new CustomAnalyzer(tokenizerName, tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFiltersListForSynonym.toArray(new TokenFilterFactory[tokenFiltersListForSynonym.size()]), 100, -1);){
                tokenFilter = ((SynonymTokenFilterFactory)tokenFilter).createPerAnalyzerSynonymFactory(analyzer, env);
            }
        }
        return tokenFilter;
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

