/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public abstract class ListIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator,
ReversibleIterator {
    @Override
    public boolean supportsHasNext() {
        return true;
    }

    public static class OfAtomic<A extends AtomicValue>
    extends Of<A>
    implements AtomicIterator {
        public OfAtomic(List<A> nodes) {
            super(nodes);
        }

        @Override
        public AtomicValue next() {
            return (AtomicValue)super.next();
        }
    }

    public static class Of<T extends Item>
    extends ListIterator {
        private int index = 0;
        protected List<T> list;

        public Of(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public Item next() {
            if (this.index >= this.list.size()) {
                return null;
            }
            return (Item)this.list.get(this.index++);
        }

        @Override
        public boolean supportsGetLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public boolean isActuallyGrounded() {
            return true;
        }

        @Override
        public GroundedValue materialize() {
            return new SequenceExtent.Of<T>(this.list);
        }

        @Override
        public GroundedValue getResidue() {
            List<T> l2 = this.list;
            if (this.index != 0) {
                l2 = l2.subList(this.index, l2.size());
            }
            return new SequenceExtent.Of<T>(l2);
        }

        @Override
        public SequenceIterator getReverseIterator() {
            return Reverse.reverseIterator(this.list);
        }
    }
}

