/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.ObjEncoder;

public final class FanBool {
    public static final boolean defVal = false;

    public static Boolean fromStr(String string) {
        return FanBool.fromStr(string, true);
    }

    public static Boolean fromStr(String string, boolean bl) {
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        if (!bl) {
            return null;
        }
        throw ParseErr.make("Bool", string);
    }

    public static boolean equals(boolean bl, Object object) {
        if (object instanceof Boolean) {
            return bl == (Boolean)object;
        }
        return false;
    }

    public static long hash(boolean bl) {
        return bl ? 1231L : 1237L;
    }

    public static Type typeof(boolean bl) {
        return Sys.BoolType;
    }

    public static boolean not(boolean bl) {
        return !bl;
    }

    public static boolean and(boolean bl, boolean bl2) {
        return bl & bl2;
    }

    public static boolean or(boolean bl, boolean bl2) {
        return bl | bl2;
    }

    public static boolean xor(boolean bl, boolean bl2) {
        return bl ^ bl2;
    }

    public static String toStr(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String toLocale(boolean bl) {
        return Env.cur().locale(Sys.sysPod, bl ? "boolTrue" : "boolFalse", FanBool.toStr(bl));
    }

    public static void encode(boolean bl, ObjEncoder objEncoder) {
        objEncoder.w(bl ? "true" : "false");
    }

    public static String toCode(boolean bl) {
        return bl ? "true" : "false";
    }
}

