/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.DateTime;
import fan.sys.Enum;
import fan.sys.Env;
import fan.sys.FanInt;
import fan.sys.FanStr;
import fan.sys.List;
import fan.sys.Locale;
import fan.sys.Sys;
import fan.sys.Type;

public final class Month
extends Enum {
    public static final Month jan = new Month(0, "jan");
    public static final Month feb = new Month(1, "feb");
    public static final Month mar = new Month(2, "mar");
    public static final Month apr = new Month(3, "apr");
    public static final Month may = new Month(4, "may");
    public static final Month jun = new Month(5, "jun");
    public static final Month jul = new Month(6, "jul");
    public static final Month aug = new Month(7, "aug");
    public static final Month sep = new Month(8, "sep");
    public static final Month oct = new Month(9, "oct");
    public static final Month nov = new Month(10, "nov");
    public static final Month dec = new Month(11, "dec");
    static final Month[] array = new Month[]{jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec};
    public static final List vals = (List)new List(Sys.MonthType, array).toImmutable();
    final int ord;
    final String localeAbbrKey;
    final String localeFullKey;

    private Month(int n, String string) {
        Enum.make$(this, FanInt.pos[n], string.intern());
        this.ord = n;
        this.localeAbbrKey = string + "Abbr";
        this.localeFullKey = string + "Full";
    }

    public static Month fromStr(String string) {
        return Month.fromStr(string, true);
    }

    public static Month fromStr(String string, boolean bl) {
        return (Month)Month.doFromStr(Sys.MonthType, string, bl);
    }

    public Type typeof() {
        return Sys.MonthType;
    }

    public Month increment() {
        return array[(this.ord + 1) % array.length];
    }

    public Month decrement() {
        return this.ord == 0 ? array[array.length - 1] : array[this.ord - 1];
    }

    public long numDays(long l) {
        if (DateTime.isLeapYear((int)l)) {
            return DateTime.daysInMonLeap[this.ord];
        }
        return DateTime.daysInMon[this.ord];
    }

    public String toLocale() {
        return this.toLocale(null);
    }

    public String toLocale(String string) {
        if (string == null) {
            return this.localeAbbr();
        }
        if (FanStr.isEveryChar(string, 77)) {
            switch (string.length()) {
                case 1: {
                    return String.valueOf(this.ord + 1);
                }
                case 2: {
                    return this.ord < 9 ? "0" + (this.ord + 1) : String.valueOf(this.ord + 1);
                }
                case 3: {
                    return this.localeAbbr();
                }
                case 4: {
                    return this.localeFull();
                }
            }
        }
        throw ArgErr.make("Invalid pattern: " + string);
    }

    public String localeAbbr() {
        return this.abbr(Locale.cur());
    }

    public String abbr(Locale locale) {
        return Env.cur().locale(Sys.sysPod, this.localeAbbrKey, this.name(), locale);
    }

    public String localeFull() {
        return this.full(Locale.cur());
    }

    public String full(Locale locale) {
        return Env.cur().locale(Sys.sysPod, this.localeFullKey, this.name(), locale);
    }
}

