/*
 * Decompiled with CFR 0.152.
 */
package fanx.emit;

import fan.sys.Err;
import fan.sys.Sys;
import fanx.emit.AttrEmit;
import fanx.emit.CodeEmit;
import fanx.emit.EmitConst;
import fanx.emit.Emitter;
import fanx.emit.FTypeEmit;
import fanx.fcode.FBuf;
import fanx.fcode.FConst;
import fanx.fcode.FMethod;
import fanx.fcode.FMethodVar;
import fanx.fcode.FPod;
import fanx.fcode.FTypeRef;
import fanx.util.Box;
import java.io.IOException;
import java.util.HashMap;

public class FCodeEmit
implements EmitConst,
FConst {
    FPod pod;
    FTypeEmit parent;
    FMethod fmethod;
    Reg[] regs;
    FTypeRef ret;
    byte[] buf;
    int len;
    int pos;
    Emitter emit;
    CodeEmit code;
    String podClass;
    int[] reloc;
    JumpNode jumps;
    int finallyEx = -1;
    int finallySp = -1;

    public FCodeEmit(FTypeEmit fTypeEmit, FMethod fMethod, CodeEmit codeEmit) {
        this(fTypeEmit, fMethod.code, codeEmit, FCodeEmit.initRegs(fTypeEmit, fMethod.isStatic(), fMethod.vars), fTypeEmit.pod.typeRef(fMethod.ret));
        this.fmethod = fMethod;
        codeEmit.maxStack = fMethod.maxStack * 2;
    }

    public FCodeEmit(FTypeEmit fTypeEmit, FBuf fBuf, CodeEmit codeEmit, Reg[] regArray, FTypeRef fTypeRef) {
        this.pod = fTypeEmit.pod;
        this.parent = fTypeEmit;
        this.buf = fBuf.buf;
        this.len = fBuf.len;
        this.emit = codeEmit.emit;
        this.code = codeEmit;
        this.podClass = "fan/" + this.pod.podName + "/$Pod";
        this.reloc = new int[this.len];
        this.regs = regArray;
        this.ret = fTypeRef;
        codeEmit.maxLocals = FCodeEmit.maxLocals(regArray);
    }

    public void emit() {
        this.emitInstructions();
        this.backpatch();
        this.errTable();
        this.lineTable();
        this.localVarTable();
    }

    private void emitInstructions() {
        block58: while (this.pos < this.len) {
            int n = this.consumeOp();
            switch (n) {
                case 0: {
                    continue block58;
                }
                case 1: {
                    this.code.op(1);
                    continue block58;
                }
                case 2: {
                    this.loadFalse();
                    continue block58;
                }
                case 3: {
                    this.loadTrue();
                    continue block58;
                }
                case 4: {
                    this.loadInt();
                    continue block58;
                }
                case 5: {
                    this.loadFloat();
                    continue block58;
                }
                case 6: {
                    this.loadDecimal();
                    continue block58;
                }
                case 7: {
                    this.loadStr();
                    continue block58;
                }
                case 8: {
                    this.loadDuration();
                    continue block58;
                }
                case 10: {
                    this.loadUri();
                    continue block58;
                }
                case 9: {
                    this.loadType();
                    continue block58;
                }
                case 11: {
                    this.loadVar();
                    continue block58;
                }
                case 12: {
                    this.storeVar();
                    continue block58;
                }
                case 13: {
                    this.pod.fieldRef(this.u2()).emitLoadInstance(this.code);
                    continue block58;
                }
                case 14: {
                    this.pod.fieldRef(this.u2()).emitStoreInstance(this.code);
                    continue block58;
                }
                case 15: {
                    this.pod.fieldRef(this.u2()).emitLoadStatic(this.code);
                    continue block58;
                }
                case 16: {
                    this.pod.fieldRef(this.u2()).emitStoreStatic(this.code);
                    continue block58;
                }
                case 17: {
                    this.pod.fieldRef(this.u2()).emitLoadMixinStatic(this.code);
                    continue block58;
                }
                case 18: {
                    this.pod.fieldRef(this.u2()).emitStoreMixinStatic(this.code);
                    continue block58;
                }
                case 19: {
                    this.pod.methodRef(this.u2()).emitCallNew(this.code);
                    continue block58;
                }
                case 20: {
                    this.pod.methodRef(this.u2()).emitCallCtor(this.code);
                    continue block58;
                }
                case 21: {
                    this.pod.methodRef(this.u2()).emitCallStatic(this.code);
                    continue block58;
                }
                case 22: {
                    this.pod.methodRef(this.u2()).emitCallVirtual(this.code);
                    continue block58;
                }
                case 23: {
                    this.pod.methodRef(this.u2()).emitCallNonVirtual(this.code);
                    continue block58;
                }
                case 24: {
                    this.pod.methodRef(this.u2()).emitCallMixinStatic(this.code);
                    continue block58;
                }
                case 25: {
                    this.pod.methodRef(this.u2()).emitCallMixinVirtual(this.code);
                    continue block58;
                }
                case 26: {
                    this.pod.methodRef(this.u2()).emitCallMixinNonVirtual(this.code);
                    continue block58;
                }
                case 27: {
                    this.jump();
                    continue block58;
                }
                case 28: {
                    this.jumpTrue();
                    continue block58;
                }
                case 29: {
                    this.jumpFalse();
                    continue block58;
                }
                case 30: {
                    this.compareEQ();
                    continue block58;
                }
                case 31: {
                    this.compareNE();
                    continue block58;
                }
                case 32: {
                    this.compare();
                    continue block58;
                }
                case 34: {
                    this.compareLT();
                    continue block58;
                }
                case 33: {
                    this.compareLE();
                    continue block58;
                }
                case 36: {
                    this.compareGE();
                    continue block58;
                }
                case 35: {
                    this.compareGT();
                    continue block58;
                }
                case 37: {
                    this.compareSame();
                    continue block58;
                }
                case 38: {
                    this.compareNotSame();
                    continue block58;
                }
                case 39: {
                    this.compareNull();
                    continue block58;
                }
                case 40: {
                    this.compareNotNull();
                    continue block58;
                }
                case 41: {
                    this.returnOp();
                    continue block58;
                }
                case 42: {
                    this.pop();
                    continue block58;
                }
                case 43: {
                    this.dup();
                    continue block58;
                }
                case 44: {
                    this.is();
                    continue block58;
                }
                case 45: {
                    this.as();
                    continue block58;
                }
                case 46: {
                    this.coerce();
                    continue block58;
                }
                case 47: {
                    this.tableswitch();
                    continue block58;
                }
                case 48: {
                    this.doThrow();
                    continue block58;
                }
                case 49: {
                    this.jump();
                    continue block58;
                }
                case 50: {
                    this.jumpFinally();
                    continue block58;
                }
                case 51: {
                    this.code.op(87);
                    continue block58;
                }
                case 52: {
                    this.catchErrStart();
                    continue block58;
                }
                case 53: {
                    continue block58;
                }
                case 54: {
                    this.finallyStart();
                    continue block58;
                }
                case 55: {
                    this.finallyEnd();
                    continue block58;
                }
            }
            throw new IllegalStateException(n < OpNames.length ? OpNames[n] : "bad opcode=" + n);
        }
    }

    private void backpatch() {
        JumpNode jumpNode = this.jumps;
        while (jumpNode != null) {
            int n;
            int n2 = this.reloc[jumpNode.fcodeLoc];
            int n3 = n = jumpNode.isFinally ? 8 : 0;
            if (jumpNode.size == 2) {
                this.code.info.u2(jumpNode.javaMark + 8, n2 - jumpNode.javaFrom + n);
            } else {
                this.code.info.u4(jumpNode.javaMark + 8, n2 - jumpNode.javaFrom);
            }
            jumpNode = jumpNode.next;
        }
    }

    private void errTable() {
        if (this.fmethod == null) {
            return;
        }
        FBuf fBuf = this.fmethod.attrs.errTable;
        if (fBuf == null) {
            return;
        }
        int n = fBuf.len;
        byte[] byArray = fBuf.buf;
        int n2 = (n - 2) / 8;
        Box box = new Box(new byte[n], 0);
        box.u2(n2);
        for (int i = 2; i < n; i += 8) {
            int n3 = this.reloc[(byArray[i + 0] & 0xFF) << 8 | byArray[i + 1] & 0xFF];
            int n4 = this.reloc[(byArray[i + 2] & 0xFF) << 8 | byArray[i + 3] & 0xFF];
            int n5 = this.reloc[(byArray[i + 4] & 0xFF) << 8 | byArray[i + 5] & 0xFF];
            box.u2(n3);
            box.u2(n4);
            box.u2(n5);
            int n6 = (byArray[i + 6] & 0xFF) << 8 | byArray[i + 7] & 0xFF;
            FTypeRef fTypeRef = this.pod.typeRef(n6);
            if (fTypeRef.isErr()) {
                box.u2(0);
                continue;
            }
            int n7 = this.emit.cls(fTypeRef.jname());
            box.u2(n7);
            String string = Err.fanToJava(fTypeRef.jname());
            if (string == null) continue;
            box.u2(0, ++n2);
            box.u2(n3);
            box.u2(n4);
            box.u2(n5);
            box.u2(this.emit.cls(string));
        }
        this.code.exceptionTable = box;
    }

    private void lineTable() {
        if (this.fmethod == null) {
            return;
        }
        FBuf fBuf = this.fmethod.attrs.lineNums;
        if (fBuf == null) {
            this.code.emitLineNumber(this.fmethod.attrs.lineNum);
            return;
        }
        int n = fBuf.len;
        byte[] byArray = fBuf.buf;
        for (int i = 2; i < n; i += 4) {
            this.reloc(byArray, i);
        }
        AttrEmit attrEmit = this.code.emitAttr("LineNumberTable");
        attrEmit.info.len = n;
        attrEmit.info.buf = byArray;
    }

    private void reloc(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        int n3 = this.reloc[n2];
        byArray[n + 0] = (byte)(n3 >>> 8);
        byArray[n + 1] = (byte)(n3 >>> 0);
    }

    private void localVarTable() {
        if (!Sys.debug) {
            return;
        }
        if (this.fmethod == null) {
            return;
        }
        AttrEmit attrEmit = this.code.emitAttr("LocalVariableTable");
        Box box = attrEmit.info;
        int n = 0;
        int n2 = this.code.info.len - 2 - 2 - 4;
        box.u2(this.regs.length);
        box.grow(box.len + this.regs.length * 10);
        for (int i = 0; i < this.regs.length; ++i) {
            Reg reg = this.regs[i];
            box.u2(n);
            box.u2(n2);
            box.u2(this.code.emit.utf(reg.name));
            box.u2(this.code.emit.utf(reg.typeRef.jsig()));
            box.u2(reg.jindex);
        }
    }

    private void loadFalse() {
        this.code.op(3);
    }

    private void loadTrue() {
        this.code.op(4);
    }

    private void loadInt() {
        try {
            Long l = this.pod.readLiterals().integer(this.u2());
            long l2 = l;
            if (l2 == 0L) {
                this.code.op(9);
            } else if (l2 == 1L) {
                this.code.op(10);
            } else {
                this.code.op2(20, this.emit.longConst(l));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
    }

    private void loadFloat() {
        try {
            Double d = this.pod.readLiterals().floats(this.u2());
            double d2 = d;
            if (d2 == 0.0) {
                this.code.op(14);
            } else if (d2 == 1.0) {
                this.code.op(15);
            } else {
                this.code.op2(20, this.emit.doubleConst(d));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
    }

    private void loadStr() {
        try {
            String string = this.pod.readLiterals().str(this.u2());
            int n = this.emit.strConst(string);
            if (n < 255) {
                this.code.op1(18, n);
            } else {
                this.code.op2(19, n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
    }

    private void loadDecimal() {
        int n = this.u2();
        int n2 = this.emit.field(this.podClass + ".D" + n + ":Ljava/math/BigDecimal;");
        this.code.op2(178, n2);
    }

    private void loadDuration() {
        int n = this.u2();
        int n2 = this.emit.field(this.podClass + ".Dur" + n + ":Lfan/sys/Duration;");
        this.code.op2(178, n2);
    }

    private void loadUri() {
        int n = this.u2();
        int n2 = this.emit.field(this.podClass + ".U" + n + ":Lfan/sys/Uri;");
        this.code.op2(178, n2);
    }

    private void loadType() {
        this.loadType(this.pod.typeRef(this.u2()));
    }

    private void loadType(FTypeRef fTypeRef) {
        String string;
        HashMap hashMap;
        String string2;
        String string3 = fTypeRef.podName;
        String string4 = fTypeRef.typeName;
        if (!fTypeRef.isGenericInstance() && string3.equals("sys")) {
            this.code.op2(178, this.emit.field("fan/sys/Sys." + string4 + "Type:Lfan/sys/Type;"));
            if (fTypeRef.isNullable()) {
                this.typeToNullable();
            }
            return;
        }
        if (fTypeRef.isFFI()) {
            this.code.op2(178, this.emit.field(this.podClass + ".Type" + fTypeRef.id + ":Lfan/sys/Type;"));
            if (fTypeRef.isNullable()) {
                this.typeToNullable();
            }
            return;
        }
        if (this.parent.typeLiteralFields == null) {
            this.parent.typeLiteralFields = new HashMap();
        }
        if ((string2 = (String)(hashMap = this.parent.typeLiteralFields).get(string = fTypeRef.signature)) == null) {
            string2 = "type$" + hashMap.size();
            hashMap.put(string, string2);
        }
        int n = this.emit.field(this.parent.className + "." + string2 + ":Lfan/sys/Type;");
        this.code.op2(178, n);
        this.code.op(89);
        int n2 = this.code.branch(199);
        this.code.op(87);
        this.code.op2(19, this.emit.strConst(string));
        this.code.op(4);
        this.code.op2(184, this.parent.typeFind());
        this.code.op(89);
        this.code.op2(179, n);
        this.code.mark(n2);
    }

    private void loadVar() {
        Reg reg = this.reg(this.u2());
        FCodeEmit.loadVar(this.code, reg.stackType, reg.jindex);
    }

    static int loadVar(CodeEmit codeEmit, int n, int n2) {
        switch (n) {
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                return FCodeEmit.loadVarInt(codeEmit, n2);
            }
            case 74: {
                return FCodeEmit.loadVarLong(codeEmit, n2);
            }
            case 70: {
                return FCodeEmit.loadVarFloat(codeEmit, n2);
            }
            case 68: {
                return FCodeEmit.loadVarDouble(codeEmit, n2);
            }
            case 65: {
                return FCodeEmit.loadVarObj(codeEmit, n2);
            }
        }
        throw new IllegalStateException("Register " + n2 + " " + (char)n);
    }

    private static int loadVarInt(CodeEmit codeEmit, int n) {
        switch (n) {
            case 0: {
                codeEmit.op(26);
                break;
            }
            case 1: {
                codeEmit.op(27);
                break;
            }
            case 2: {
                codeEmit.op(28);
                break;
            }
            case 3: {
                codeEmit.op(29);
                break;
            }
            default: {
                codeEmit.op1(21, n);
            }
        }
        return n + 1;
    }

    private static int loadVarLong(CodeEmit codeEmit, int n) {
        switch (n) {
            case 0: {
                codeEmit.op(30);
                break;
            }
            case 1: {
                codeEmit.op(31);
                break;
            }
            case 2: {
                codeEmit.op(32);
                break;
            }
            case 3: {
                codeEmit.op(33);
                break;
            }
            default: {
                codeEmit.op1(22, n);
            }
        }
        return n + 2;
    }

    private static int loadVarFloat(CodeEmit codeEmit, int n) {
        switch (n) {
            case 0: {
                codeEmit.op(34);
                break;
            }
            case 1: {
                codeEmit.op(35);
                break;
            }
            case 2: {
                codeEmit.op(36);
                break;
            }
            case 3: {
                codeEmit.op(37);
                break;
            }
            default: {
                codeEmit.op1(23, n);
            }
        }
        return n + 2;
    }

    private static int loadVarDouble(CodeEmit codeEmit, int n) {
        switch (n) {
            case 0: {
                codeEmit.op(38);
                break;
            }
            case 1: {
                codeEmit.op(39);
                break;
            }
            case 2: {
                codeEmit.op(40);
                break;
            }
            case 3: {
                codeEmit.op(41);
                break;
            }
            default: {
                codeEmit.op1(24, n);
            }
        }
        return n + 2;
    }

    private static int loadVarObj(CodeEmit codeEmit, int n) {
        switch (n) {
            case 0: {
                codeEmit.op(42);
                break;
            }
            case 1: {
                codeEmit.op(43);
                break;
            }
            case 2: {
                codeEmit.op(44);
                break;
            }
            case 3: {
                codeEmit.op(45);
                break;
            }
            default: {
                codeEmit.op1(25, n);
            }
        }
        return n + 1;
    }

    private void storeVar() {
        Reg reg = this.reg(this.u2());
        this.storeVar(reg.stackType, reg.jindex);
    }

    private void storeVar(int n, int n2) {
        switch (n) {
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                this.storeVarInt(n2);
                break;
            }
            case 74: {
                this.storeVarLong(n2);
                break;
            }
            case 70: {
                this.storeVarFloat(n2);
                break;
            }
            case 68: {
                this.storeVarDouble(n2);
                break;
            }
            case 65: {
                this.storeVarObj(n2);
                break;
            }
            default: {
                throw new IllegalStateException("Register " + n2 + " " + (char)n);
            }
        }
    }

    private void storeVarInt(int n) {
        switch (n) {
            case 0: {
                this.code.op(59);
                break;
            }
            case 1: {
                this.code.op(60);
                break;
            }
            case 2: {
                this.code.op(61);
                break;
            }
            case 3: {
                this.code.op(62);
                break;
            }
            default: {
                this.code.op1(54, n);
            }
        }
    }

    private void storeVarLong(int n) {
        switch (n) {
            case 0: {
                this.code.op(63);
                break;
            }
            case 1: {
                this.code.op(64);
                break;
            }
            case 2: {
                this.code.op(65);
                break;
            }
            case 3: {
                this.code.op(66);
                break;
            }
            default: {
                this.code.op1(55, n);
            }
        }
    }

    private void storeVarFloat(int n) {
        switch (n) {
            case 0: {
                this.code.op(67);
                break;
            }
            case 1: {
                this.code.op(68);
                break;
            }
            case 2: {
                this.code.op(69);
                break;
            }
            case 3: {
                this.code.op(70);
                break;
            }
            default: {
                this.code.op1(56, n);
            }
        }
    }

    private void storeVarDouble(int n) {
        switch (n) {
            case 0: {
                this.code.op(71);
                break;
            }
            case 1: {
                this.code.op(72);
                break;
            }
            case 2: {
                this.code.op(73);
                break;
            }
            case 3: {
                this.code.op(74);
                break;
            }
            default: {
                this.code.op1(57, n);
            }
        }
    }

    private void storeVarObj(int n) {
        switch (n) {
            case 0: {
                this.code.op(75);
                break;
            }
            case 1: {
                this.code.op(76);
                break;
            }
            case 2: {
                this.code.op(77);
                break;
            }
            case 3: {
                this.code.op(78);
                break;
            }
            default: {
                this.code.op1(58, n);
            }
        }
    }

    private void jumpTrue() {
        this.code.op(154);
        this.branch();
    }

    private void jumpFalse() {
        this.code.op(153);
        this.branch();
    }

    private void jump() {
        this.code.op(167);
        this.branch();
    }

    private JumpNode branch() {
        JumpNode jumpNode = new JumpNode();
        jumpNode.fcodeLoc = this.u2();
        jumpNode.javaFrom = this.code.pos() - 1;
        jumpNode.javaMark = this.code.pos();
        jumpNode.next = this.jumps;
        this.jumps = jumpNode;
        this.code.info.u2(65535);
        return jumpNode;
    }

    private void compareEQ() {
        FTypeRef fTypeRef = this.pod.typeRef(this.u2());
        FTypeRef fTypeRef2 = this.pod.typeRef(this.u2());
        if (fTypeRef.isRef() && !fTypeRef.isNullable() && fTypeRef2.isRef()) {
            this.code.op2(182, this.emit.method("java/lang/Object.equals(Ljava/lang/Object;)Z"));
            return;
        }
        this.doCompare("EQ", fTypeRef, fTypeRef2);
    }

    private void compareNE() {
        this.doCompare("NE");
    }

    private void compareLT() {
        this.doCompare("LT");
    }

    private void compareLE() {
        this.doCompare("LE");
    }

    private void compareGE() {
        this.doCompare("GE");
    }

    private void compareGT() {
        this.doCompare("GT");
    }

    private void compare() {
        this.doCompare("");
    }

    private void doCompare(String string) {
        this.doCompare(string, this.pod.typeRef(this.u2()), this.pod.typeRef(this.u2()));
    }

    private void doCompare(String string, FTypeRef fTypeRef, FTypeRef fTypeRef2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("fanx/util/OpUtil.compare").append(string).append('(');
        if (fTypeRef.isRef()) {
            stringBuilder.append("Ljava/lang/Object;");
        } else {
            fTypeRef.jsig(stringBuilder);
        }
        if (fTypeRef2.isRef()) {
            stringBuilder.append("Ljava/lang/Object;");
        } else {
            fTypeRef2.jsig(stringBuilder);
        }
        stringBuilder.append(')');
        if (string == "") {
            stringBuilder.append('J');
        } else {
            stringBuilder.append('Z');
        }
        this.code.op2(184, this.emit.method(stringBuilder.toString()));
    }

    private void compareSame() {
        int n = this.peekOp();
        switch (n) {
            case 29: {
                this.consumeOp();
                this.code.op(166);
                this.branch();
                break;
            }
            case 28: {
                this.consumeOp();
                this.code.op(165);
                this.branch();
                break;
            }
            default: {
                int n2 = this.code.branch(165);
                this.code.op(3);
                int n3 = this.code.branch(167);
                this.code.mark(n2);
                this.code.op(4);
                this.code.mark(n3);
            }
        }
    }

    private void compareNotSame() {
        int n = this.peekOp();
        switch (n) {
            case 29: {
                this.consumeOp();
                this.code.op(165);
                this.branch();
                break;
            }
            case 28: {
                this.consumeOp();
                this.code.op(166);
                this.branch();
                break;
            }
            default: {
                int n2 = this.code.branch(166);
                this.code.op(3);
                int n3 = this.code.branch(167);
                this.code.mark(n2);
                this.code.op(4);
                this.code.mark(n3);
            }
        }
    }

    private void compareNull() {
        this.u2();
        int n = this.peekOp();
        switch (n) {
            case 29: {
                this.consumeOp();
                this.code.op(199);
                this.branch();
                break;
            }
            case 28: {
                this.consumeOp();
                this.code.op(198);
                this.branch();
                break;
            }
            default: {
                int n2 = this.code.branch(198);
                this.code.op(3);
                int n3 = this.code.branch(167);
                this.code.mark(n2);
                this.code.op(4);
                this.code.mark(n3);
            }
        }
    }

    private void compareNotNull() {
        this.u2();
        int n = this.peekOp();
        switch (n) {
            case 29: {
                this.consumeOp();
                this.code.op(198);
                this.branch();
                break;
            }
            case 28: {
                this.consumeOp();
                this.code.op(199);
                this.branch();
                break;
            }
            default: {
                int n2 = this.code.branch(199);
                this.code.op(3);
                int n3 = this.code.branch(167);
                this.code.mark(n2);
                this.code.op(4);
                this.code.mark(n3);
            }
        }
    }

    private void returnOp() {
        this.code.op(FCodeEmit.returnOp(this.ret));
    }

    static int returnOp(FTypeRef fTypeRef) {
        return FCodeEmit.returnOp(fTypeRef.stackType);
    }

    static int returnOp(int n) {
        switch (n) {
            case 65: {
                return 176;
            }
            case 70: {
                return 174;
            }
            case 68: {
                return 175;
            }
            case 74: {
                return 173;
            }
            case 66: 
            case 67: 
            case 73: 
            case 83: 
            case 90: {
                return 172;
            }
            case 86: {
                return 177;
            }
        }
        throw new IllegalStateException("" + (char)n);
    }

    private void dup() {
        FTypeRef fTypeRef = this.pod.typeRef(this.u2());
        this.code.op(fTypeRef.isWide() ? 92 : 89);
    }

    private void pop() {
        FTypeRef fTypeRef = this.pod.typeRef(this.u2());
        this.code.op(fTypeRef.isWide() ? 88 : 87);
    }

    private void is() {
        FTypeRef fTypeRef = this.pod.typeRef(this.u2());
        if (fTypeRef.isGenericInstance()) {
            if (this.parent.IsViaType == 0) {
                this.parent.IsViaType = this.emit.method("fanx/util/OpUtil.is(Ljava/lang/Object;Lfan/sys/Type;)Z");
            }
            this.loadType(fTypeRef);
            this.code.op2(184, this.parent.IsViaType);
        } else {
            int n = this.emit.cls(fTypeRef.jnameBoxed());
            this.code.op2(193, n);
        }
    }

    private void as() {
        FTypeRef fTypeRef = this.pod.typeRef(this.u2());
        int n = this.emit.cls(fTypeRef.jnameBoxed());
        this.code.op(89);
        this.code.op2(193, n);
        int n2 = this.code.branch(154);
        this.code.op(87);
        this.code.op(1);
        int n3 = this.code.branch(167);
        this.code.mark(n2);
        this.code.op2(192, n);
        this.code.mark(n3);
    }

    private void tableswitch() {
        int n = this.u2();
        this.code.op(136);
        int n2 = this.code.pos();
        this.code.op(170);
        int n3 = this.code.padAlign4();
        this.code.info.u4(1 + n3 + 12 + n * 4);
        this.code.info.u4(0);
        this.code.info.u4(n - 1);
        for (int i = 0; i < n; ++i) {
            JumpNode jumpNode = new JumpNode();
            jumpNode.fcodeLoc = this.u2();
            jumpNode.size = 4;
            jumpNode.javaFrom = n2;
            jumpNode.javaMark = this.code.info.len - 8;
            jumpNode.next = this.jumps;
            this.jumps = jumpNode;
            this.code.info.u4(-1);
        }
    }

    private void coerce() {
        FTypeRef fTypeRef;
        FTypeRef fTypeRef2 = this.pod.typeRef(this.u2());
        if (fTypeRef2 == (fTypeRef = this.pod.typeRef(this.u2()))) {
            System.out.println("WARNING: " + this.parent.selfName + " " + this.fmethod.name + " Coerce: " + fTypeRef2 + " => " + fTypeRef);
            return;
        }
        if (fTypeRef.isPrimitive()) {
            this.coerceToPrimitive(fTypeRef2, fTypeRef);
            return;
        }
        if (fTypeRef2.isPrimitive()) {
            this.coerceFromPrimitive(fTypeRef2, fTypeRef);
            return;
        }
        if (fTypeRef2.isNullable() && !fTypeRef.isNullable()) {
            this.code.op(89);
            int n = this.code.branch(199);
            if (this.parent.NullErrMakeCoerce == 0) {
                this.parent.NullErrMakeCoerce = this.emit.method("fan/sys/NullErr.makeCoerce()Lfan/sys/NullErr;");
            }
            this.code.op2(184, this.parent.NullErrMakeCoerce);
            this.code.op(191);
            this.code.mark(n);
        }
        if (fTypeRef.isObj()) {
            return;
        }
        this.code.op2(192, this.emit.cls(fTypeRef.jname()));
    }

    private void coerceToPrimitive(FTypeRef fTypeRef, FTypeRef fTypeRef2) {
        if (fTypeRef2.isPrimitiveBool() && fTypeRef.isRef()) {
            this.boolUnbox(!fTypeRef.isBool());
            return;
        }
        if (fTypeRef2.isPrimitiveLong()) {
            if (fTypeRef.isRef()) {
                this.intUnbox(!fTypeRef.isInt());
                return;
            }
            if (fTypeRef.isPrimitiveIntLike()) {
                this.code.op(133);
                return;
            }
        }
        if (fTypeRef2.isPrimitiveDouble()) {
            if (fTypeRef.isRef()) {
                this.floatUnbox(!fTypeRef.isFloat());
                return;
            }
            if (fTypeRef.isPrimitiveFloat()) {
                this.code.op(141);
                return;
            }
        }
        if (fTypeRef2.isPrimitiveIntLike() && (fTypeRef.isRef() || fTypeRef.isPrimitiveLong())) {
            if (fTypeRef.isRef()) {
                this.intUnbox(!fTypeRef.isInt());
            }
            this.code.op(136);
            if (fTypeRef2.isPrimitiveByte()) {
                this.code.op(145);
            } else if (fTypeRef2.isPrimitiveShort()) {
                this.code.op(147);
            } else if (fTypeRef2.isPrimitiveChar()) {
                this.code.op(146);
            }
            return;
        }
        if (fTypeRef2.isPrimitiveFloat()) {
            if (fTypeRef.isPrimitiveDouble()) {
                this.code.op(144);
                return;
            }
            if (fTypeRef.isRef()) {
                this.floatUnbox(!fTypeRef.isFloat());
                this.code.op(144);
                return;
            }
        }
        throw new IllegalStateException("Coerce " + fTypeRef + " => " + fTypeRef2);
    }

    private void coerceFromPrimitive(FTypeRef fTypeRef, FTypeRef fTypeRef2) {
        if (fTypeRef.isPrimitiveBool() && fTypeRef2.isRef()) {
            this.boolBox();
            return;
        }
        if (fTypeRef.isPrimitiveLong() && fTypeRef2.isRef()) {
            this.intBox();
            return;
        }
        if (fTypeRef.isPrimitiveDouble() && fTypeRef2.isRef()) {
            this.floatBox();
            return;
        }
        if (fTypeRef.isPrimitiveIntLike() && fTypeRef2.isRef()) {
            this.code.op(133);
            this.intBox();
            return;
        }
        if (fTypeRef.isPrimitiveFloat() && fTypeRef2.isRef()) {
            this.code.op(141);
            this.floatBox();
            return;
        }
        throw new IllegalStateException("Coerce " + fTypeRef + " => " + fTypeRef2);
    }

    private void cast() {
        int n = this.emit.cls(this.pod.typeRef(this.u2()).jname());
        this.code.op2(192, n);
    }

    private void doThrow() {
        this.code.op(191);
    }

    private void catchErrStart() {
        if (this.parent.ErrMake == 0) {
            this.parent.ErrMake = this.emit.method("fan/sys/Err.make(Ljava/lang/Throwable;)Lfan/sys/Err;");
        }
        this.code.op2(184, this.parent.ErrMake);
        this.cast();
    }

    private void jumpFinally() {
        this.code.op(168);
        JumpNode jumpNode = this.branch();
        jumpNode.isFinally = true;
    }

    private void finallyStart() {
        if (this.finallyEx < 0) {
            this.finallyEx = this.code.maxLocals;
            this.finallySp = this.code.maxLocals + 1;
            this.code.maxLocals += 2;
        }
        this.code.op1(58, this.finallyEx);
        this.code.op2(168, 6);
        this.code.op1(25, this.finallyEx);
        this.code.op(191);
        this.code.op1(58, this.finallySp);
    }

    private void finallyEnd() {
        this.code.op1(169, this.finallySp);
    }

    private void boolBox() {
        if (this.parent.BoolBox == 0) {
            this.parent.BoolBox = this.emit.method("java/lang/Boolean.valueOf(Z)Ljava/lang/Boolean;");
        }
        this.code.op2(184, this.parent.BoolBox);
    }

    private void boolUnbox(boolean bl) {
        if (bl) {
            this.code.op2(192, this.emit.cls("java/lang/Boolean"));
        }
        if (this.parent.BoolUnbox == 0) {
            this.parent.BoolUnbox = this.emit.method("java/lang/Boolean.booleanValue()Z");
        }
        this.code.op2(182, this.parent.BoolUnbox);
    }

    private void intBox() {
        if (this.parent.IntBox == 0) {
            this.parent.IntBox = this.emit.method("java/lang/Long.valueOf(J)Ljava/lang/Long;");
        }
        this.code.op2(184, this.parent.IntBox);
    }

    private void intUnbox(boolean bl) {
        if (bl) {
            this.code.op2(192, this.emit.cls("java/lang/Long"));
        }
        if (this.parent.IntUnbox == 0) {
            this.parent.IntUnbox = this.emit.method("java/lang/Long.longValue()J");
        }
        this.code.op2(182, this.parent.IntUnbox);
    }

    private void floatBox() {
        if (this.parent.FloatBox == 0) {
            this.parent.FloatBox = this.emit.method("java/lang/Double.valueOf(D)Ljava/lang/Double;");
        }
        this.code.op2(184, this.parent.FloatBox);
    }

    private void floatUnbox(boolean bl) {
        if (bl) {
            this.code.op2(192, this.emit.cls("java/lang/Double"));
        }
        if (this.parent.FloatUnbox == 0) {
            this.parent.FloatUnbox = this.emit.method("java/lang/Double.doubleValue()D");
        }
        this.code.op2(182, this.parent.FloatUnbox);
    }

    private void typeToNullable() {
        if (this.parent.TypeToNullable == 0) {
            this.parent.TypeToNullable = this.emit.method("fan/sys/Type.toNullable()Lfan/sys/Type;");
        }
        this.code.op2(182, this.parent.TypeToNullable);
    }

    private int consumeOp() {
        this.reloc[this.pos] = this.code.pos();
        return this.u1();
    }

    private int peekOp() {
        if (this.pos < this.len) {
            return this.buf[this.pos];
        }
        return -1;
    }

    private int u1() {
        return this.buf[this.pos++];
    }

    private int u2() {
        return (this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF;
    }

    private int u4() {
        return (this.buf[this.pos++] & 0xFF) << 24 | (this.buf[this.pos++] & 0xFF) << 16 | (this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF;
    }

    static int maxLocals(Reg[] regArray) {
        if (regArray.length == 0) {
            return 0;
        }
        Reg reg = regArray[regArray.length - 1];
        return reg.jindex + (reg.isWide() ? 2 : 1);
    }

    static Reg[] initRegs(FTypeEmit fTypeEmit, boolean bl, FMethodVar[] fMethodVarArray) {
        FPod fPod = fTypeEmit.pod;
        Reg[] regArray = new Reg[bl ? fMethodVarArray.length : fMethodVarArray.length + 1];
        int n = 0;
        for (int i = 0; i < regArray.length; ++i) {
            Reg reg = new Reg();
            if (i == 0 && !bl) {
                reg.typeRef = fPod.typeRef(fTypeEmit.type.self);
                reg.name = "this";
                reg.stackType = 65;
                reg.jindex = n++;
            } else {
                FMethodVar fMethodVar = fMethodVarArray[bl ? i : i - 1];
                reg.typeRef = fPod.typeRef(fMethodVar.type);
                reg.name = fMethodVar.name;
                reg.stackType = reg.typeRef.stackType;
                reg.jindex = n;
                n += reg.typeRef.isWide() ? 2 : 1;
            }
            regArray[i] = reg;
        }
        return regArray;
    }

    private Reg reg(int n) {
        if (this.regs == null) {
            throw new IllegalStateException("Use of variable with undefined regs");
        }
        return this.regs[n];
    }

    static class JumpNode {
        int fcodeLoc;
        int javaMark;
        int javaFrom;
        int size = 2;
        boolean isFinally;
        JumpNode next;

        JumpNode() {
        }
    }

    static class Reg {
        String name;
        FTypeRef typeRef;
        int stackType;
        int jindex;

        Reg() {
        }

        public String toString() {
            return "Reg " + this.jindex + " " + (char)this.stackType;
        }

        public boolean isWide() {
            return FTypeRef.isWide(this.stackType);
        }
    }
}

