@if "%_echo%"=="" echo off
echo ------------------------------------------------------------------------
echo --- Installing the F# runtime libraries onto this machine.           ---
echo ---                                                                  ---
echo --- Use "install-fsharp.bat --sscli" to force use of the Rotor SSCLI ---
echo ------------------------------------------------------------------------


setlocal

set _SCRIPT_DRIVE=%~d0
set _SCRIPT_PATH=%~p0
set _ROOT=%_SCRIPT_DRIVE%%_SCRIPT_PATH%

%_SCRIPT_DRIVE%
pushd %_ROOT%

REM rem Try to find ngen.exe if we can.  It won't exist for the SSCLI
set NGEN=
REM 
for /f %%i in ('setup\cordir %1') do ( 
  if exist %%i\ngen.exe ( set NGEN=%%i\ngen.exe )
  if exist %%i\ngen.exe ( set CORDIR=%%i )
)

rem Don't ngen anything on .net v2.0 beta 1, since ngen of tailcalls was busted on that version
rem Test this by seeing if the latest clr version string contains 2.0.40607.
if NOT "%CORDIR:2.0.40607=X%" == "%CORDIR%" ( set NGEN=)

rem We use our own little mini-gacutil to install assemblies because
rem gacutil.exe doesn't exist for the .NET Framework Redist and
rem exists in strange locations for the .NET Framework SDK and
rem Visual Studio

rem i =
rem j =
rem k =
rem l = name of fsc compiler
rem m = name of fsi 
rem n = suffix
for /f "tokens=1,2,3,4,5,6 delims=," %%i in (setup\installed-ilx-configs) do (
   if exist "%_ROOT%\bin\FSharp.Core%%n.dll" ( 
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Core%%n.dll"
       REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Core%%n.dll") )
     )
     if NOT "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       if "FSharp.Core10.dll" == "FSharp.Core%%n.dll" (
         "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Core%%n.dll"
         REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Core%%n.dll") )
      )
     )
   )

   if exist "%_ROOT%\bin\FSharp.Compatibility%%n.dll" ( 
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Compatibility%%n.dll"
       REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Compatibility%%n.dll") )
     )
     if NOT "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       if "FSharp.Compatibility10.dll" == "FSharp.Compatibility%%n.dll" (
         "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Compatibility%%n.dll"
         REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Compatibility%%n.dll") )
      )
     )
   )

   if exist "%_ROOT%\bin\FSharp.Compiler%%n.dll" ( 
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Compiler%%n.dll"
       if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" install /queue:1 "%_ROOT%\bin\FSharp.Compiler%%n.dll") )
     )
   )

   if exist "%_ROOT%\bin\FSharp.Compiler.CodeDom%%n.dll" ( 
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Compiler.CodeDom%%n.dll"
       REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Compiler.CodeDom%%n.dll") )
     )
     if NOT "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       if "FSharp.Compiler.CodeDom10.dll" == "FSharp.Compiler.CodeDom%%n.dll" (
         "%_ROOT%\setup\gac" %1 "%_ROOT%\bin\FSharp.Compiler.CodeDom%%n.dll"
         REM if ERRORLEVEL 0 ( if NOT "%NGEN%"=="" (  "%NGEN%" /nologo "%_ROOT%\bin\FSharp.Compiler.CodeDom%%n.dll") )
      )
     )
   )

  if NOT "%%l" == "NOTAVAIL" ( 
   if exist "%_ROOT%\bin\fsc%%n.exe" ( 
    if "fsc.exe" == "fsc%%n.exe" (
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       if NOT "%NGEN%"=="" (  "%NGEN%" install /queue:1 "%_ROOT%\bin\fsc%%n.exe")
     )
    )
   )
  )

  if NOT "%%m" == "NOTAVAIL" ( 
   if exist "%_ROOT%\bin\fsi%%n.exe" ( 
    if "fsi.exe" == "fsi%%n.exe" (
     if "%CORDIR:v1.=X%" == "%CORDIR%" ( 
       if NOT "%NGEN%"=="" (  "%NGEN%" install /queue:1 "%_ROOT%\bin\FSharp.Compiler%%n.dll")
     )
    )
   )
  )


  REG ADD HKLM\SOFTWARE\Microsoft\.NETFramework\AssemblyFolders\Microsoft.FSharp-1.9.4.19 /f /v Description /t REG_EXPAND_SZ /d "FSharp Compiler and Libraries Assembly Directory"
  REG ADD HKLM\SOFTWARE\Microsoft\.NETFramework\AssemblyFolders\Microsoft.FSharp-1.9.4.19 /f /ve /d "%_ROOT%\bin" /t REG_EXPAND_SZ 
)


echo ------------------------------------------------------------------------
ECHO --- The F# library and the ML compatibility library have 
ECHO --- been installed on your machine.  Several flavours of these
ECHO --- library may have been installed, e.g. for use with early versions
ECHO --- of the .NET Common Language Runtime.   F# will select the appropriate
ECHO --- library based on the command line switches you use.  You may install the
ECHO --- libraries on other machines by copying them and running the 
ECHO --- %_ROOT%install-fsharp.bat script.
ECHO ---
ECHO --- Debugging information for the libraries may be found in %_ROOT%bin.
ECHO --- You may need to use the "Options" menu in Visual Studio to disable 
ECHO --- "Just My Code" debugging.  You can also set the appropriate symbol path
ECHO --- there or you can add that path to the _NT_SYMBOL_PATH environment
ECHO --- variable.
ECHO ---
ECHO --- You can now also install 'F# for Visual Studio' if you have an
ECHO --- appropriate version of Visual Studio.  The installation steps
ECHO --- are outlined in the README-fsharp.html file in the distribution.
echo ------------------------------------------------------------------------


popd

endlocal