// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
/// Basic operations on options.  
module Option =

    /// Returns true if the option is not None
    val is_some: 'a option -> bool

    /// Returns true if the option is None
    val is_none: 'a option -> bool

    /// Gets the value associated with the option.  If the option is None then
    /// raises Invalid_argument "Option.get"
    val get: 'a option -> 'a

    /// "length inp" evaluates to "match inp with None -> 0 | Some _ -> 1"
    val length: 'a option -> int

    /// "fold_left f s inp " evaluates to "match inp with None -> s | Some x -> f s x"
    val fold_left: ('b -> 'a -> 'b) -> 'b -> 'a option -> 'b

    /// "fold_right f inp s" evaluates to "match inp with None -> s | Some x -> f x s"
    val fold_right: ('a -> 'b -> 'b) -> 'a option -> 'b -> 'b

    /// "exists p inp" evaluates to "match inp with None -> false | Some x -> p x"
    val exists: ('a -> bool) -> 'a option -> bool

    /// "forall p inp" evaluates to "match inp with None -> true | Some x -> p x"
    val for_all: ('a -> bool) -> 'a option -> bool

    /// "filter p inp" evaluates to "match inp with None -> None | Some x -> if p x then inp else None"
    val filter: ('a -> bool) -> 'a option -> 'a option

    /// "partition p inp" evaluates to 
    /// "match inp with None -> None,None | Some x -> if p x then inp,None else None,inp"
    val partition: ('a -> bool) -> 'a option -> ('a option * 'a option)

    /// "iter f inp" executes "match inp with None -> () | Some x -> f x"
    val iter: ('a -> unit) -> 'a option -> unit

    /// "map f inp" evaluates to "match inp with None -> None | Some x -> Some (f x)"
    val map: ('a -> 'b) -> 'a option -> 'b option

    /// "bind f inp" evaluates to "match inp with None -> None | Some x -> f x"
    val bind: ('a -> 'b option) -> 'a option -> 'b option

    /// Convert the option to an array of length 0 or 1
    val to_array: 'a option -> 'a array

    /// Convert the option to a list of length 0 or 1
    val to_list: 'a option -> 'a list

