(* (c) Microsoft Corporation 2005-2007.  *)


module Microsoft.FSharp.Compatibility.OCaml.Bytearray
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives
open Microsoft.FSharp.Compatibility

let compare (x:byte[]) y = compare x y

type bytearray = byte[]
let length (arr: byte[]) =  CompatArray.length arr
let get (arr: byte[]) (n:int) =  CompatArray.get arr n
let set (arr: byte[]) (n:int) (x:byte) =  CompatArray.set arr n x
let zero_create (n:int) : byte[]= CompatArray.zero_create n
let make  (n:int) = (zero_create n : byte[]) 
let create (n:int)  = make n
let init (n:int) (f: int -> byte) =  CompatArray.init n f
let concat (arrs:byte[] list) = CompatArray.concat arrs
let append arr1 arr2 = concat [arr1; arr2]
let sub (arr:byte[]) (start:int) (len:int) = CompatArray.sub arr start len
let fill (arr:byte[]) (start:int) (len:int) (x:byte) = CompatArray.fill arr start len x
let copy (arr:byte[]) = CompatArray.copy arr
let blit (arr1:byte[]) (start1:int) (arr2: byte[]) (start2:int) (len:int) = CompatArray.blit arr1 start1 arr2 start2 len
let to_list (arr:byte[]) = CompatArray.to_list arr  
let of_list (l:byte list) = CompatArray.of_list l
let iter (f : byte -> unit) (arr:byte[]) = CompatArray.iter f arr
let map (f: byte -> byte) (arr:byte[]) = CompatArray.map f arr
let iteri (f : int -> byte -> unit) (arr:byte[]) = CompatArray.iteri f arr
let mapi (f: int -> byte -> byte) (arr:byte[]) = CompatArray.mapi f arr
let fold_left (f : 'a -> byte -> 'a) (acc: 'a) (arr:byte[]) = CompatArray.fold_left f acc arr
let fold_right (f : byte -> 'a -> 'a) (arr:byte[]) (acc: 'a) = CompatArray.fold_right f arr acc

type encoding = System.Text.Encoding

let ascii_to_string (b:byte[]) = System.Text.Encoding.ASCII.GetString(b)
  
let string_to_ascii (s:string) = System.Text.Encoding.ASCII.GetBytes(s)
