(* (c) Microsoft Corporation. All rights reserved *)
(*F# 
module Microsoft.Research.AbstractIL.Extensions.ILX.Ilxerase
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.Research.AbstractIL.Extensions.ILX
module Ilprint = Microsoft.Research.AbstractIL.AsciiWriter 
module Il = Microsoft.Research.AbstractIL.IL 
F#*)  

open Il
open Msilxlib
open Ilxsettings

let set_generic () = 
    Pubclo.erase_method_pointers := true;
    pp_implementation := FullGenerics

let set_no_generics () = 
    Pubclo.erase_method_pointers := false; 
    pp_implementation := NoGenerics

let set_notailcalls () = Msilxlib.tailcall_implementation := Ilxsettings.NoTailcalls; Ilprint.print_tailcall := false
let set_alltailcalls () = Msilxlib.tailcall_implementation := Ilxsettings.AllTailcalls; Ilprint.print_tailcall := true
let set_callvirt () = call_implementation := VirtEntriesVirtCode

let conv_module_fragment ilg m modFragName modul = 
    (* Note the default entries may be overriden by user entries *)
    let modul = if  !cu_erase then Cu_erase.conv_module ilg m modul else modul in 
    let modul = if  !clo_erase then Pubclo.conv_module ilg m modul else modul in
    let modul = if  !pp_implementation <> FullGenerics then Pp_erase.conv_module ilg modFragName modul else modul in 
    let modul = if  !pp_implementation <> FullGenerics && !pp_implementation <> TyrepGenerics then Nupp_erase.conv_module ilg modul else modul in 
    modul

let conv_module ilg m modul = conv_module_fragment ilg m modul.modulName modul

let advancedUsageFlags = 
    [  "--compiling-ilxlib", Arg.Unit (fun _ -> ()), ""; ] 

let usage = 
    [ "--generics", Arg.Unit set_generic, ""; 
      "--no-generics", Arg.Unit set_no_generics, "\n\tFine grained control over whether to produce code for a .NET CLR\n\tthat supports generics."; 
      "--all-tailcalls", Arg.Unit set_alltailcalls, "";
      "--no-tailcalls", Arg.Unit set_notailcalls, "\n\tFine grained control over whether to emit tailcall annotations.";
      "--closures-as-virtuals", Arg.Unit set_callvirt, "\n\tFine grained control over the implementaion of closures."; 
      "--multi-entrypoint-closures", Arg.Unit (fun () -> entrypoint_implementation := MultiEntryPoints), ""; ]
