/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.model.DomainObjectListener;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import org.apache.commons.collections4.ComparatorUtils;

public class DebuggerLocationLabel
extends JLabel {
    protected final ForLocationLabelTraceListener listener = new ForLocationLabelTraceListener();
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Address address = null;

    protected boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        return Objects.equals(a.getTime(), b.getTime());
    }

    protected void addNewListeners() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.addListener((DomainObjectListener)this.listener);
        }
    }

    protected void removeOldListeners() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.removeListener((DomainObjectListener)this.listener);
        }
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        boolean doListeners;
        if (this.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean bl = doListeners = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        if (doListeners) {
            this.removeOldListeners();
        }
        this.current = coordinates;
        if (doListeners) {
            this.addNewListeners();
        }
        this.updateLabel();
    }

    public void goToAddress(Address address) {
        this.address = address;
        this.updateLabel();
    }

    protected TraceSection getNearestSectionContaining() {
        if (this.current.getView() == null) {
            return null;
        }
        Trace trace = this.current.getTrace();
        ArrayList sections = new ArrayList(trace.getModuleManager().getSectionsAt(this.current.getSnap().longValue(), this.address));
        if (sections.isEmpty()) {
            return null;
        }
        sections.sort(ComparatorUtils.chainedComparator(List.of(Comparator.comparing(s -> s.getRange().getMinAddress()), Comparator.comparing(s -> -s.getRange().getLength()))));
        return (TraceSection)sections.get(sections.size() - 1);
    }

    protected TraceModule getNearestModuleContaining() {
        if (this.current.getView() == null) {
            return null;
        }
        Trace trace = this.current.getTrace();
        ArrayList modules = new ArrayList(trace.getModuleManager().getModulesAt(this.current.getSnap().longValue(), this.address));
        if (modules.isEmpty()) {
            return null;
        }
        modules.sort(ComparatorUtils.chainedComparator(List.of(Comparator.comparing(m -> m.getRange().getMinAddress()), Comparator.comparing(m -> -m.getRange().getLength()))));
        return (TraceModule)modules.get(modules.size() - 1);
    }

    protected TraceMemoryRegion getRegionContaining() {
        if (this.current.getView() == null) {
            return null;
        }
        Trace trace = this.current.getTrace();
        return trace.getMemoryManager().getRegionContaining(this.current.getSnap().longValue(), this.address);
    }

    protected String computeLocationString() {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return "";
        }
        if (this.address == null) {
            return "(nowhere)";
        }
        try {
            TraceSection section = this.getNearestSectionContaining();
            if (section != null) {
                return section.getModule().getName() + ":" + section.getName();
            }
            TraceModule module = this.getNearestModuleContaining();
            if (module != null) {
                return module.getName();
            }
            TraceMemoryRegion region = this.getRegionContaining();
            if (region != null) {
                return region.getName();
            }
            return "(unknown)";
        }
        catch (Throwable t) {
            return "(error) " + t.getMessage();
        }
    }

    public void updateLabel() {
        this.setText(this.computeLocationString());
    }

    protected class ForLocationLabelTraceListener
    extends TraceDomainObjectListener {
        private final AsyncDebouncer<Void> updateLabelDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);

        public ForLocationLabelTraceListener() {
            this.updateLabelDebouncer.addListener(__ -> Swing.runIfSwingOrRunLater(() -> this.doUpdateLabel()));
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.ADDED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.DELETED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.LIFESPAN_CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.DELETED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.ADDED, this::sectionChanged);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.CHANGED, this::sectionChanged);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.DELETED, this::sectionChanged);
        }

        private void doUpdateLabel() {
            DebuggerLocationLabel.this.updateLabel();
        }

        private void regionChanged(TraceMemoryRegion region) {
            this.updateLabelDebouncer.contact(null);
        }

        private void moduleChanged(TraceModule module) {
            this.updateLabelDebouncer.contact(null);
        }

        private void sectionChanged(TraceSection section) {
            this.updateLabelDebouncer.contact(null);
        }
    }
}

