/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui;

import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.MultiStateActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsPlugin;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsolePlugin;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingPlugin;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesPlugin;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingPlugin;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.pcode.DebuggerPcodeStepperPlugin;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersPlugin;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPlugin;
import ghidra.app.plugin.core.debug.gui.target.DebuggerTargetsPlugin;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsPlugin;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimePlugin;
import ghidra.app.plugin.core.debug.gui.watch.DebuggerWatchesPlugin;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.program.database.ProgramContentHandler;
import ghidra.trace.model.Trace;
import ghidra.util.ColorUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.RotateIcon;

public interface DebuggerResources {
    public static final String OPTIONS_CATEGORY_WORKFLOW = "Debugger.Workflow";
    public static final ImageIcon ICON_DEBUGGER = ResourceManager.loadImage((String)"images/debugger.png");
    public static final ImageIcon ICON_CONNECTION = ResourceManager.loadImage((String)"images/connect.png");
    public static final ImageIcon ICON_DISCONNECT = ResourceManager.loadImage((String)"images/disconnect.png");
    public static final ImageIcon ICON_PROCESS = ResourceManager.loadImage((String)"images/process.png");
    public static final ImageIcon ICON_TRACE = Trace.TRACE_ICON;
    public static final ImageIcon ICON_THREAD = ResourceManager.loadImage((String)"images/thread.png");
    public static final ImageIcon ICON_PROGRAM = ProgramContentHandler.PROGRAM_ICON;
    public static final ImageIcon ICON_LAUNCH = ResourceManager.loadImage((String)"images/launch.png");
    public static final ImageIcon ICON_ATTACH = ResourceManager.loadImage((String)"images/attach.png");
    public static final ImageIcon ICON_RESUME = ResourceManager.loadImage((String)"images/continue.png");
    public static final ImageIcon ICON_TERMINATE = ResourceManager.loadImage((String)"images/stop.png");
    public static final ImageIcon ICON_KILL = ResourceManager.loadImage((String)"images/kill.png");
    public static final ImageIcon ICON_DETACH = ResourceManager.loadImage((String)"images/detach.png");
    public static final ImageIcon ICON_RECORD = ResourceManager.loadImage((String)"images/record.png");
    public static final ImageIcon ICON_STEP_INTO = ResourceManager.loadImage((String)"images/stepinto.png");
    public static final ImageIcon ICON_STEP_OVER = ResourceManager.loadImage((String)"images/stepover.png");
    public static final ImageIcon ICON_STEP_FINISH = ResourceManager.loadImage((String)"images/stepout.png");
    public static final ImageIcon ICON_STEP_BACK = ResourceManager.loadImage((String)"images/stepback.png");
    public static final ImageIcon ICON_SNAP_FORWARD = ResourceManager.loadImage((String)"images/2rightarrow.png");
    public static final ImageIcon ICON_SNAP_BACKWARD = ResourceManager.loadImage((String)"images/2leftarrow.png");
    public static final ImageIcon ICON_SEEK_PRESENT = ICON_RESUME;
    public static final boolean altIcons = Boolean.getBoolean("debugger.breakpoints.alt.icons");
    public static final ImageIcon ICON_SET_BREAKPOINT = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-set.png") : ResourceManager.loadImage((String)"images/breakpoint-set.png");
    public static final ImageIcon ICON_CLEAR_BREAKPOINT = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-clear.png") : ResourceManager.loadImage((String)"images/breakpoint-clear.png");
    public static final ImageIcon ICON_ENABLE_BREAKPOINT = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-enable.png") : ResourceManager.loadImage((String)"images/breakpoint-enable.png");
    public static final ImageIcon ICON_ENABLE_ALL_BREAKPOINTS = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoints-enable-all.png") : ResourceManager.loadImage((String)"images/breakpoints-enable-all.png");
    public static final ImageIcon ICON_DISABLE_BREAKPOINT = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-disable.png") : ResourceManager.loadImage((String)"images/breakpoint-disable.png");
    public static final ImageIcon ICON_DISABLE_ALL_BREAKPOINTS = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoints-disable-all.png") : ResourceManager.loadImage((String)"images/breakpoints-disable-all.png");
    public static final ImageIcon ICON_CLEAR_ALL_BREAKPOINTS = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoints-clear-all.png") : ResourceManager.loadImage((String)"images/breakpoints-clear-all.png");
    public static final ImageIcon ICON_MAKE_BREAKPOINTS_EFFECTIVE = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoints-make-effective.png") : ResourceManager.loadImage((String)"images/breakpoints-make-effective.png");
    public static final ImageIcon ICON_LISTING = ResourceManager.loadImage((String)"images/Browser.gif");
    public static final ImageIcon ICON_MEMORY_BYTES = ResourceManager.loadImage((String)"images/binaryData.gif");
    public static final ImageIcon ICON_CONSOLE = ResourceManager.loadImage((String)"images/console.png");
    public static final ImageIcon ICON_REGISTERS = ResourceManager.loadImage((String)"images/registers.png");
    public static final ImageIcon ICON_STACK = ResourceManager.loadImage((String)"images/stack.png");
    public static final ImageIcon ICON_BREAKPOINTS = ResourceManager.loadImage((String)"images/breakpoints.png");
    public static final ImageIcon ICON_MODULES = ResourceManager.loadImage((String)"images/modules.png");
    public static final ImageIcon ICON_MAPPINGS = ICON_PROGRAM;
    public static final ImageIcon ICON_PCODE = ResourceManager.loadImage((String)"images/stepinto.png");
    public static final ImageIcon ICON_REGIONS = ResourceManager.loadImage((String)"images/memory16.gif");
    public static final ImageIcon ICON_TIME = ResourceManager.loadImage((String)"images/time.png");
    public static final ImageIcon ICON_OBJECTS = ResourceManager.loadImage((String)"images/object-populated.png");
    public static final ImageIcon ICON_SAVE = ResourceManager.loadImage((String)"images/disk.png");
    public static final ImageIcon ICON_CLOSE = ResourceManager.loadImage((String)"images/x.gif");
    public static final ImageIcon ICON_ADD = ResourceManager.loadImage((String)"images/add.png");
    public static final ImageIcon ICON_DELETE = ResourceManager.loadImage((String)"images/delete.png");
    public static final ImageIcon ICON_CLEAR = ResourceManager.loadImage((String)"images/erase16.png");
    public static final ImageIcon ICON_REFRESH = ResourceManager.loadImage((String)"images/view-refresh.png");
    public static final ImageIcon ICON_FILTER = ResourceManager.loadImage((String)"images/filter_off.png");
    public static final ImageIcon ICON_SELECT_ROWS = ResourceManager.loadImage((String)"images/table_go.png");
    public static final ImageIcon ICON_AUTOREAD = ResourceManager.loadImage((String)"images/autoread.png");
    public static final ImageIcon ICON_READ_MEMORY = ICON_REGIONS;
    public static final ImageIcon ICON_RENAME_SNAPSHOT = ICON_TIME;
    public static final ImageIcon ICON_MAP_IDENTICALLY = ResourceManager.loadImage((String)"images/doubleArrow.png");
    public static final ImageIcon ICON_MAP_MODULES;
    public static final ImageIcon ICON_MAP_SECTIONS;
    public static final ImageIcon ICON_BLOCK;
    public static final ImageIcon ICON_SELECT_ADDRESSES;
    public static final ImageIcon ICON_DATA_TYPES;
    public static final ImageIcon ICON_CAPTURE_SYMBOLS;
    public static final ImageIcon ICON_LOG_FATAL;
    public static final ImageIcon ICON_LOG_ERROR;
    public static final ImageIcon ICON_LOG_WARN;
    public static final ImageIcon ICON_SYNC;
    public static final ImageIcon ICON_VISIBILITY;
    public static final ImageIcon ICON_PIN;
    public static final ImageIcon ICON_IMPORT;
    public static final ImageIcon ICON_BLANK;
    public static final ImageIcon ICON_PACKAGE;
    public static final ImageIcon ICON_EMULATE;
    public static final ImageIcon ICON_CONFIG;
    public static final ImageIcon ICON_TOGGLE;
    public static final ImageIcon ICON_DIFF;
    public static final ImageIcon ICON_DIFF_PREV;
    public static final ImageIcon ICON_DIFF_NEXT;
    public static final HelpLocation HELP_PACKAGE;
    public static final String HELP_ANCHOR_PLUGIN = "plugin";
    public static final String TITLE_PROVIDER_BREAKPOINTS = "Breakpoints";
    public static final ImageIcon ICON_PROVIDER_BREAKPOINTS;
    public static final HelpLocation HELP_PROVIDER_BREAKPOINTS;
    public static final String TITLE_PROVIDER_CONSOLE = "Debug Console";
    public static final ImageIcon ICON_PROVIDER_CONSOLE;
    public static final HelpLocation HELP_PROVIDER_CONSOLE;
    public static final String TITLE_PROVIDER_LISTING = "Dynamic";
    public static final ImageIcon ICON_PROVIDER_LISTING;
    public static final HelpLocation HELP_PROVIDER_LISTING;
    public static final String TITLE_PROVIDER_MAPPINGS = "Static Mappings";
    public static final ImageIcon ICON_PROVIDER_MAPPINGS;
    public static final HelpLocation HELP_PROVIDER_MAPPINGS;
    public static final String TITLE_PROVIDER_MEMORY_BYTES = "Memory";
    public static final ImageIcon ICON_PROVIDER_MEMORY_BYTES;
    public static final HelpLocation HELP_PROVIDER_MEMORY_BYTES;
    public static final String TITLE_PROVIDER_MODULES = "Modules";
    public static final ImageIcon ICON_PROVIDER_MODULES;
    public static final HelpLocation HELP_PROVIDER_MODULES;
    public static final String TITLE_PROVIDER_PCODE = "Pcode Stepper";
    public static final ImageIcon ICON_PROVIDER_PCODE;
    public static final HelpLocation HELP_PROVIDER_PCODE;
    public static final String TITLE_PROVIDER_REGIONS = "Regions";
    public static final ImageIcon ICON_PROVIDER_REGIONS;
    public static final HelpLocation HELP_PROVIDER_REGIONS;
    public static final String TITLE_PROVIDER_REGISTERS = "Registers";
    public static final ImageIcon ICON_PROVIDER_REGISTERS;
    public static final HelpLocation HELP_PROVIDER_REGISTERS;
    public static final String TITLE_PROVIDER_TARGETS = "Debugger Targets";
    public static final ImageIcon ICON_PROVIDER_TARGETS;
    public static final HelpLocation HELP_PROVIDER_TARGETS;
    public static final String TITLE_PROVIDER_STACK = "Stack";
    public static final ImageIcon ICON_PROVIDER_STACK;
    public static final HelpLocation HELP_PROVIDER_STACK;
    public static final String TITLE_PROVIDER_THREADS = "Threads";
    public static final ImageIcon ICON_PROVIDER_THREADS;
    public static final HelpLocation HELP_PROVIDER_THREADS;
    public static final String TITLE_PROVIDER_TIME = "Time";
    public static final ImageIcon ICON_PROVIDER_TIME;
    public static final HelpLocation HELP_PROVIDER_TIME;
    public static final String TITLE_PROVIDER_OBJECTS = "Objects";
    public static final ImageIcon ICON_PROVIDER_OBJECTS;
    public static final HelpLocation HELP_PROVIDER_OBJECTS;
    public static final String TITLE_PROVIDER_WATCHES = "Watches";
    public static final ImageIcon ICON_PROVIDER_WATCHES;
    public static final HelpLocation HELP_PROVIDER_WATCHES;
    public static final String TITLE_PROVIDER_INTERPRETER = "Interpreter";
    public static final String BOOKMARK_CATEGORY_MEMORY_READ_ERROR = "Debugger Memory Read Error";
    public static final String OPTION_NAME_COLORS_STALE_MEMORY = "Colors.Stale Memory";
    public static final Color DEFAULT_COLOR_BACKGROUND_STALE;
    public static final String OPTION_NAME_COLORS_ERROR_MEMORY = "Colors.Error Memory";
    public static final Color DEFAULT_COLOR_BACKGROUND_ERROR;
    public static final int PRIORITY_REGISTER_MARKER = 10;
    public static final String OPTION_NAME_COLORS_TRACKING_MARKERS = "Colors.Tracking Markers";
    public static final Color DEFAULT_COLOR_REGISTER_MARKERS;
    public static final ImageIcon ICON_REGISTER_MARKER;
    public static final String OPTION_NAME_COLORS_REGISTER_STALE = "Colors.Stale Registers";
    public static final Color DEFAULT_COLOR_REGISTER_STALE;
    public static final String OPTION_NAME_COLORS_REGISTER_STALE_SEL = "Colors.Stale Registers (selected)";
    public static final Color DEFAULT_COLOR_REGISTER_STALE_SEL;
    public static final String OPTION_NAME_COLORS_REGISTER_CHANGED = "Colors.Changed Registers";
    public static final Color DEFAULT_COLOR_REGISTER_CHANGED;
    public static final String OPTION_NAME_COLORS_REGISTER_CHANGED_SEL = "Colors.Changed Registers (selected)";
    public static final Color DEFAULT_COLOR_REGISTER_CHANGED_SEL;
    public static final String OPTION_NAME_COLORS_WATCH_STALE = "Colors.Stale Watches";
    public static final Color DEFAULT_COLOR_WATCH_STALE;
    public static final String OPTION_NAME_COLORS_WATCH_STALE_SEL = "Colors.Stale Watches (selected)";
    public static final Color DEFAULT_COLOR_WATCH_STALE_SEL;
    public static final String OPTION_NAME_COLORS_WATCH_CHANGED = "Colors.Changed Watches";
    public static final Color DEFAULT_COLOR_WATCH_CHANGED;
    public static final String OPTION_NAME_COLORS_WATCH_CHANGED_SEL = "Colors.Changed Watches (selected)";
    public static final Color DEFAULT_COLOR_WATCH_CHANGED_SEL;
    public static final String OPTION_NAME_COLORS_PCODE_COUNTER = "Colors.Pcode Counter";
    public static final Color DEFAULT_COLOR_PCODE_COUNTER;
    public static final String MARKER_NAME_BREAKPOINT_ENABLED = "Enabled Breakpoint";
    public static final String MARKER_NAME_BREAKPOINT_DISABLED = "Disabled Breakpoint";
    public static final String MARKER_NAME_BREAKPOINT_INEFFECTIVE_E = "Ineffective Enabled Breakpoint";
    public static final String MARKER_NAME_BREAKPOINT_INEFFECTIVE_D = "Ineffective Disabled Breakpoint";
    public static final String MARKER_NAME_BREAKPOINT_MIXED_ED = "Mixed Enabled-Disabled Breakpont";
    public static final String MARKER_NAME_BREAKPOINT_MIXED_DE = "Mixed Disabled-Enabled Breakpont";
    public static final int PRIORITY_BREAKPOINT_ENABLED_MARKER = 50;
    public static final int PRIORITY_BREAKPOINT_DISABLED_MARKER = 50;
    public static final int PRIORITY_BREAKPOINT_INEFFECTIVE_E_MARKER = 50;
    public static final int PRIORITY_BREAKPOINT_INEFFECTIVE_D_MARKER = 50;
    public static final int PRIORITY_BREAKPOINT_MIXED_ED_MARKER = 50;
    public static final int PRIORITY_BREAKPOINT_MIXED_DE_MARKER = 50;
    public static final ImageIcon ICON_BREAKPOINT_ENABLED_MARKER;
    public static final ImageIcon ICON_BREAKPOINT_DISABLED_MARKER;
    public static final ImageIcon ICON_BREAKPOINT_MIXED_ED_MARKER;
    public static final ImageIcon ICON_BREAKPOINT_MIXED_DE_MARKER;
    public static final ImageIcon ICON_BREAKPOINT_INEFFECTIVE_E_MARKER;
    public static final ImageIcon ICON_BREAKPOINT_INEFFECTIVE_D_MARKER;
    public static final Icon ICON_UNIQUE_REF_READ;
    public static final ImageIcon ICON_UNIQUE_REF_WRITE;
    public static final Icon ICON_UNIQUE_REF_RW;
    public static final String OPTION_NAME_COLORS_ENABLED_BREAKPOINT_MARKERS = "Colors.Enabled Breakpoint Markers";
    public static final Color DEFAULT_COLOR_ENABLED_BREAKPOINT_MARKERS;
    public static final String OPTION_NAME_COLORS_DISABLED_BREAKPOINT_MARKERS = "Colors.Disabled Breakpoint Markers";
    public static final Color DEFAULT_COLOR_DISABLED_BREAKPOINT_MARKERS;
    public static final String OPTION_NAME_COLORS_INEFFECTIVE_E_BREAKPOINT_MARKERS = "Colors.Ineffective Enabled Breakpoint Markers";
    public static final Color DEFAULT_COLOR_INEFFECTIVE_E_BREAKPOINT_MARKERS;
    public static final String OPTION_NAME_COLORS_INEFFECTIVE_D_BREAKPOINT_MARKERS = "Colors.Ineffective Disabled Breakpoint Markers";
    public static final Color DEFAULT_COLOR_INEFFECTIVE_D_BREAKPOINT_MARKERS;
    public static final String OPTION_NAME_COLORS_ENABLED_BREAKPOINT_COLORING_BACKGROUND = "Colors.Enabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_ENABLED_BREAKPOINT_COLORING_BACKGROUND = true;
    public static final String OPTION_NAME_COLORS_DISABLED_BREAKPOINT_COLORING_BACKGROUND = "Colors.Disabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_DISABLED_BREAKPOINT_COLORING_BACKGROUND = false;
    public static final String OPTION_NAME_COLORS_INEFFECTIVE_E_BREAKPOINT_COLORING_BACKGROUND = "Colors.Ineffective Enabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_INEFFECTIVE_E_BREAKPOINT_COLORING_BACKGROUND = true;
    public static final String OPTION_NAME_COLORS_INEFFECTIVE_D_BREAKPOINT_COLORING_BACKGROUND = "Colors.Ineffective Disabled Breakpoint Markers Have Background";
    public static final boolean DEFAULT_COLOR_INEFFECTIVE_D_BREAKPOINT_COLORING_BACKGROUND = false;
    public static final String OPTION_NAME_LOG_BUFFER_LIMIT = "Log Buffer Size";
    public static final int DEFAULT_LOG_BUFFER_LIMIT = 100;
    public static final String GROUP_GENERAL = "Dbg1. General";
    public static final String GROUP_CONNECTION = "Dbg2. Connection";
    public static final String GROUP_VIEWS = "Dbg3. Views";
    public static final String GROUP_TRANSIENT_VIEWS = "Dbg3a. Transient Views";
    public static final String GROUP_CONTROL = "Dbg4. Control";
    public static final String GROUP_TARGET = "Dbg5. Target";
    public static final String GROUP_BREAKPOINTS = "Dbg6. Breakpoints";
    public static final String GROUP_TRACE = "Dbg7. Trace";
    public static final String GROUP_TRACE_TOGGLES = "Dbg7.a. Trace Toggles";
    public static final String GROUP_TRACE_CLOSE = "Dbg7.b. Trace Close";
    public static final String GROUP_MAINTENANCE = "Dbg8. Maintenance";
    public static final String GROUP_MAPPING = "Dbg9. Map Modules/Sections";
    public static final String GROUP_DIFF_NAV = "DiffNavigate";

    public static void tableRowActivationAction(GTable table, final Runnable runnable) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                runnable.run();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
                    runnable.run();
                }
            }
        });
    }

    public static <T> Function<Throwable, T> showError(Component parent, String message) {
        return e -> {
            Throwable t = AsyncUtils.unwrapThrowable((Throwable)e);
            if (t instanceof CancelledException || t instanceof CancellationException) {
                Msg.error((Object)parent, (Object)("Cancelled: " + message));
            } else {
                Msg.showError((Object)parent, (Component)parent, (String)"Debugger", (Object)message, (Throwable)e);
            }
            return null;
        };
    }

    public static <V, R> void setSelectedRows(Set<V> sel, Function<V, R> rowMapper, GTable table, RowObjectTableModel<R> model, GTableFilterPanel<R> filterPanel) {
        table.clearSelection();
        for (V v : sel) {
            R row = rowMapper.apply(v);
            if (row == null) continue;
            int modelRow = model.getRowIndex(row);
            int viewRow = filterPanel.getViewRow(modelRow);
            table.getSelectionModel().addSelectionInterval(viewRow, viewRow);
        }
        table.scrollToSelectedRow();
    }

    public static <V, R> void setSelectedRows(Set<V> sel, Function<R, V> getter, GTable table, GTableFilterPanel<R> filterPanel) {
        List data = filterPanel.getTableFilterModel().getModelData();
        for (int i = 0; i < data.size(); ++i) {
            if (!sel.contains(getter.apply(data.get(i)))) continue;
            table.getSelectionModel().addSelectionInterval(i, i);
        }
        table.scrollToSelectedRow();
    }

    static {
        ICON_BLOCK = ICON_MAP_SECTIONS = (ICON_MAP_MODULES = ResourceManager.loadImage((String)"images/modules.png"));
        ICON_SELECT_ADDRESSES = ResourceManager.loadImage((String)"images/text_align_justify.png");
        ICON_DATA_TYPES = ResourceManager.loadImage((String)"images/dataTypes.png");
        ICON_CAPTURE_SYMBOLS = ResourceManager.loadImage((String)"images/closedFolderLabels.png");
        ICON_LOG_FATAL = ResourceManager.loadImage((String)"images/edit-bomg.png");
        ICON_LOG_ERROR = ResourceManager.loadImage((String)"images/dialog-warning_red.png");
        ICON_LOG_WARN = ResourceManager.loadImage((String)"images/dialog-warning.png");
        ICON_SYNC = ResourceManager.loadImage((String)"images/sync_enabled.png");
        ICON_VISIBILITY = ResourceManager.loadImage((String)"images/format-text-bold.png");
        ICON_PIN = ResourceManager.loadImage((String)"images/pin.png");
        ICON_IMPORT = ResourceManager.loadImage((String)"images/imported_bookmark.gif");
        ICON_BLANK = ResourceManager.loadImage((String)"images/blank.png");
        ICON_PACKAGE = ResourceManager.loadImage((String)"images/debugger32.png");
        ICON_EMULATE = ICON_PROCESS;
        ICON_CONFIG = ResourceManager.loadImage((String)"images/conf.png");
        ICON_TOGGLE = ResourceManager.loadImage((String)"images/system-switch-user.png");
        ICON_DIFF = ResourceManager.loadImage((String)"images/table_relationship.png");
        ICON_DIFF_PREV = ResourceManager.loadImage((String)"images/up.png");
        ICON_DIFF_NEXT = ResourceManager.loadImage((String)"images/down.png");
        HELP_PACKAGE = new HelpLocation("Debugger", "package");
        ICON_PROVIDER_BREAKPOINTS = ICON_BREAKPOINTS;
        HELP_PROVIDER_BREAKPOINTS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerBreakpointsPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_CONSOLE = ICON_CONSOLE;
        HELP_PROVIDER_CONSOLE = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerConsolePlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_LISTING = ICON_LISTING;
        HELP_PROVIDER_LISTING = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerListingPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_MAPPINGS = ICON_MAPPINGS;
        HELP_PROVIDER_MAPPINGS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerStaticMappingPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_MEMORY_BYTES = ICON_MEMORY_BYTES;
        HELP_PROVIDER_MEMORY_BYTES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerMemoryBytesPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_MODULES = ICON_MODULES;
        HELP_PROVIDER_MODULES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerModulesPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_PCODE = ICON_PCODE;
        HELP_PROVIDER_PCODE = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerPcodeStepperPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_REGIONS = ICON_REGIONS;
        HELP_PROVIDER_REGIONS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerRegionsPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_REGISTERS = ICON_REGISTERS;
        HELP_PROVIDER_REGISTERS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerRegistersPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_TARGETS = ICON_CONNECTION;
        HELP_PROVIDER_TARGETS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerTargetsPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_STACK = ICON_STACK;
        HELP_PROVIDER_STACK = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerStackPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_THREADS = ICON_DEBUGGER;
        HELP_PROVIDER_THREADS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerThreadsPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_TIME = ICON_TIME;
        HELP_PROVIDER_TIME = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerTimePlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_OBJECTS = ResourceManager.loadImage((String)"images/time.png");
        HELP_PROVIDER_OBJECTS = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerObjectsPlugin.class), HELP_ANCHOR_PLUGIN);
        ICON_PROVIDER_WATCHES = ICON_AUTOREAD;
        HELP_PROVIDER_WATCHES = new HelpLocation(PluginUtils.getPluginNameFromClass(DebuggerWatchesPlugin.class), HELP_ANCHOR_PLUGIN);
        DEFAULT_COLOR_BACKGROUND_STALE = Color.LIGHT_GRAY;
        DEFAULT_COLOR_BACKGROUND_ERROR = new Color(1.0f, 0.75f, 0.75f);
        DEFAULT_COLOR_REGISTER_MARKERS = new Color(0.75f, 0.875f, 0.75f);
        ICON_REGISTER_MARKER = ResourceManager.loadImage((String)"images/register-marker.png");
        DEFAULT_COLOR_REGISTER_STALE = Color.GRAY;
        DEFAULT_COLOR_REGISTER_STALE_SEL = Color.LIGHT_GRAY;
        DEFAULT_COLOR_REGISTER_CHANGED = Color.RED;
        DEFAULT_COLOR_REGISTER_CHANGED_SEL = ColorUtils.blend((Color)Color.RED, (Color)Color.WHITE, (float)0.5f);
        DEFAULT_COLOR_WATCH_STALE = Color.GRAY;
        DEFAULT_COLOR_WATCH_STALE_SEL = Color.LIGHT_GRAY;
        DEFAULT_COLOR_WATCH_CHANGED = Color.RED;
        DEFAULT_COLOR_WATCH_CHANGED_SEL = ColorUtils.blend((Color)Color.RED, (Color)Color.WHITE, (float)0.5f);
        DEFAULT_COLOR_PCODE_COUNTER = new Color(0.75f, 0.875f, 0.75f);
        ICON_BREAKPOINT_ENABLED_MARKER = ICON_ENABLE_BREAKPOINT;
        ICON_BREAKPOINT_DISABLED_MARKER = ICON_DISABLE_BREAKPOINT;
        ICON_BREAKPOINT_MIXED_ED_MARKER = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-mixed-ed.png") : ResourceManager.loadImage((String)"images/breakpoint-mixed-ed.png");
        ICON_BREAKPOINT_MIXED_DE_MARKER = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-mixed-de.png") : ResourceManager.loadImage((String)"images/breakpoint-mixed-de.png");
        ICON_BREAKPOINT_INEFFECTIVE_E_MARKER = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-ineffective-e.png") : ResourceManager.loadImage((String)"images/breakpoint-ineffective-e.png");
        ICON_BREAKPOINT_INEFFECTIVE_D_MARKER = altIcons ? ResourceManager.loadImage((String)"images/alt-breakpoint-ineffective-d.png") : ResourceManager.loadImage((String)"images/breakpoint-ineffective-d.png");
        ICON_UNIQUE_REF_READ = new RotateIcon((Icon)ResourceManager.loadImage((String)"images/cursor_arrow.gif"), 180);
        ICON_UNIQUE_REF_WRITE = ResourceManager.loadImage((String)"images/cursor_arrow.gif");
        ICON_UNIQUE_REF_RW = new MultiIcon(ICON_UNIQUE_REF_READ, new Icon[]{ICON_UNIQUE_REF_WRITE});
        DEFAULT_COLOR_DISABLED_BREAKPOINT_MARKERS = DEFAULT_COLOR_ENABLED_BREAKPOINT_MARKERS = new Color(0.875f, 0.75f, 0.75f);
        DEFAULT_COLOR_INEFFECTIVE_D_BREAKPOINT_MARKERS = DEFAULT_COLOR_INEFFECTIVE_E_BREAKPOINT_MARKERS = new Color(0.75f, 0.75f, 0.75f);
    }

    public static class ToToggleSelectionListener
    implements DebuggerTraceManagerService.BooleanChangeAdapter {
        private final ToggleDockingAction action;

        public ToToggleSelectionListener(ToggleDockingAction action) {
            this.action = action;
        }

        @Override
        public void changed(Boolean value) {
            if (this.action.isSelected() == value.booleanValue()) {
                return;
            }
            this.action.setSelected(value.booleanValue());
        }
    }

    public static abstract class AbstractDebuggerModelNode
    extends GTreeNode {
        public Icon getIcon(boolean expanded) {
            return ICON_CONNECTION;
        }

        public String getToolTip() {
            return "A connected debugger client";
        }
    }

    public static abstract class AbstractDebuggerConnectionsNode
    extends GTreeNode {
        public String getName() {
            return "Connections";
        }

        public Icon getIcon(boolean expanded) {
            return ICON_DEBUGGER;
        }

        public String getToolTip() {
            return "Established debugger connections";
        }
    }

    public static interface NextDifferenceAction {
        public static final String NAME = "Next Difference";
        public static final String DESCRIPTION = "Go to the next highlighted difference";
        public static final String GROUP = "DiffNavigate";
        public static final Icon ICON = ICON_DIFF_NEXT;
        public static final String HELP_ANCHOR = "next_diff";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("DiffNavigate")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface PrevDifferenceAction {
        public static final String NAME = "Previous Difference";
        public static final String DESCRIPTION = "Go to the previous highlighted difference";
        public static final String GROUP = "DiffNavigate";
        public static final Icon ICON = ICON_DIFF_PREV;
        public static final String HELP_ANCHOR = "prev_diff";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("DiffNavigate")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CompareTimesAction {
        public static final String NAME = "Compare";
        public static final String DESCRIPTION = "Compare this point in time to another";
        public static final String GROUP = "zzz";
        public static final Icon ICON = ICON_DIFF;
        public static final String HELP_ANCHOR = "compare";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ForceFullViewAction {
        public static final String NAME = "Force Full View";
        public static final String DESCRIPTION = "Ignore regions and fiew full address spaces";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "force_full_view";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg1. General")).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface HideScratchSnapshotsAction {
        public static final String NAME = "Hide Scratch";
        public static final String DESCRIPTION = "Hide negative snaps, typically used as emulation scratch space";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "hide_scratch";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg1. General")).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectWatchReadsAction {
        public static final String NAME = "Select Reads";
        public static final String DESCRIPTION = "Select every memory range read evaluating this watch";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_REGIONS;
        public static final String HELP_ANCHOR = "select_reads";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectWatchRangeAction {
        public static final String NAME = "Select Range";
        public static final String DESCRIPTION = "For memory watches, select the range comprising the value";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_SELECT_ADDRESSES;
        public static final String HELP_ANCHOR = "select_addresses";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ApplyDataTypeAction {
        public static final String NAME = "Apply Data to Listing ";
        public static final String DESCRIPTION = "Apply the selected data type at the address of this value in the listing";
        public static final String GROUP = "Dbg1. General";
        public static final Icon ICON = ICON_DATA_TYPES;
        public static final String HELP_ANCHOR = "apply_data_type";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup("Dbg1. General")).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CloseDeadTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  Dead Traces";
        public static final String DESCRIPTION = "Close all traces not being recorded";
        public static final String HELP_ANCHOR = "close_dead_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseDeadTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{"Debugger", NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseDeadTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseOtherTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  Other Traces";
        public static final String DESCRIPTION = "Close all traces except the current one";
        public static final String HELP_ANCHOR = "close_other_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseOtherTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{"Debugger", NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseOtherTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseAllTracesAction
    extends CloseTraceAction {
        public static final String NAME = "Close  All Traces";
        public static final String DESCRIPTION = "Close all traces";
        public static final String HELP_ANCHOR = "close_all_traces";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseAllTracesAction.builderCommon(owner).menuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).menuIcon(ICON)).menuPath(new String[]{"Debugger", NAME});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseAllTracesAction.builderCommon(owner).popupMenuGroup(DebuggerResources.GROUP_TRACE_CLOSE)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME});
        }
    }

    public static interface CloseTraceAction {
        public static final String NAME_PREFIX = "Close ";
        public static final String DESCRIPTION = "Close the current or selected trace";
        public static final String GROUP = "Dbg7.b. Trace Close";
        public static final String SUB_GROUP = "a";
        public static final Icon ICON = ICON_CLOSE;
        public static final String HELP_ANCHOR = "close_trace";

        public static ActionBuilder builderCommon(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }

        public static ActionBuilder builder(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseTraceAction.builderCommon(owner).menuGroup("Dbg7.b. Trace Close", SUB_GROUP)).menuIcon(ICON)).menuPath(new String[]{"Debugger", "Close ..."});
        }

        public static ActionBuilder builderPopup(Plugin owner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)CloseTraceAction.builderCommon(owner).popupMenuGroup("Dbg7.b. Trace Close", SUB_GROUP)).popupMenuIcon(ICON)).popupMenuPath(new String[]{"Close ..."});
        }
    }

    public static interface OpenTraceAction {
        public static final String NAME = "Open Trace";
        public static final String DESCRIPTION = "Open a trace from the project";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = ICON_TRACE;
        public static final String HELP_ANCHOR = "open_trace";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg7. Trace")).menuIcon(ICON)).menuPath(new String[]{"Debugger", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CloseOnTerminateAction {
        public static final String NAME = "Close Traces Upon Termination";
        public static final String DESCRIPTION = "Close any live trace whose recording terminates";
        public static final String GROUP = "Dbg7.a. Trace Toggles";
        public static final Icon ICON = ICON_CLOSE;
        public static final String HELP_ANCHOR = "auto_close_terminated";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuGroup("Dbg7.a. Trace Toggles")).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SaveByDefaultAction {
        public static final String NAME = "Save Traces By Default";
        public static final String DESCRIPTION = "Automatically save traces to the project";
        public static final String GROUP = "Dbg7.a. Trace Toggles";
        public static final Icon ICON = ICON_SAVE;
        public static final String HELP_ANCHOR = "save_by_default";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuGroup("Dbg7.a. Trace Toggles")).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface GoToTimeAction {
        public static final String NAME = "Go To Time";
        public static final String DESCRIPTION = "Go to a specific time, optionally using emulation";
        public static final Icon ICON = ICON_TIME;
        public static final String HELP_ANCHOR = "goto_time";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuIcon(ICON)).keyBinding("CTRL SHIFT T")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SynchronizeFocusAction {
        public static final String NAME = "Synchronize Focus";
        public static final String DESCRIPTION = "Synchronize trace activation with debugger focus/select";
        public static final Icon ICON = ICON_SYNC;
        public static final String HELP_ANCHOR = "sync_focus";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface RenameSnapshotAction {
        public static final String NAME = "Rename Current Snapshot";
        public static final String DESCRIPTION = "Modify the description of the snapshot (event) in the current view";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = ICON_RENAME_SNAPSHOT;
        public static final String HELP_ANCHOR = "rename_snapshot";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuGroup("Dbg7. Trace", "zzz")).keyBinding("CTRL SHIFT N")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSeekTracePresentAction
    extends ToggleDockingAction {
        public static final String NAME = "Seek Trace Present";
        public static final Icon ICON = ICON_SEEK_PRESENT;
        public static final String HELP_ANCHOR = "seek_trace_present";

        public AbstractSeekTracePresentAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Track the tool to the latest snap");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface EmulatePcodeBackwardAction {
        public static final String NAME = "Emulate Trace p-code Backward";
        public static final String DESCRIPTION = "Navigate the recording backward one p-code tick";
        public static final Icon ICON = ICON_STEP_BACK;
        public static final String GROUP = "Dbg4. Control";
        public static final String HELP_ANCHOR = "emu_trace_pcode_backward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractStepSnapBackwardAction
    extends DockingAction {
        public static final String NAME = "Step Trace Snap Backward";
        public static final Icon ICON = ICON_SNAP_BACKWARD;
        public static final String HELP_ANCHOR = "step_trace_snap_backward";

        public AbstractStepSnapBackwardAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Navigate the recording backward one snap");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEmulateTickBackwardAction
    extends DockingAction {
        public static final String NAME = "Emulate Trace Tick Backward";
        public static final Icon ICON = ICON_STEP_BACK;
        public static final String HELP_ANCHOR = "emu_trace_tick_backward";

        public AbstractEmulateTickBackwardAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Emulate the recording backward one tick");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface EmulatePcodeForwardAction {
        public static final String NAME = "Emulate Trace p-code Forward";
        public static final String DESCRIPTION = "Navigate the recording forward one p-code tick";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String GROUP = "Dbg4. Control";
        public static final String HELP_ANCHOR = "emu_trace_pcode_forward";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEmulateTickForwardAction
    extends DockingAction {
        public static final String NAME = "Emulate Trace Tick Forward";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String HELP_ANCHOR = "emu_trace_tick_forward";

        public AbstractEmulateTickForwardAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Emulate the recording forward one tick");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractStepSnapForwardAction
    extends DockingAction {
        public static final String NAME = "Step Trace Snap Forward";
        public static final Icon ICON = ICON_SNAP_FORWARD;
        public static final String HELP_ANCHOR = "step_trace_snap_forward";

        public AbstractStepSnapForwardAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Navigate the recording forward one snap");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface NewMemoryAction {
        public static final String NAME = "New Memory View";
        public static final String DESCRIPTION = "Open a new memory bytes view";
        public static final String GROUP = "Dbg3a. Transient Views";
        public static final Icon ICON = ICON_MEMORY_BYTES;
        public static final String HELP_ANCHOR = "new_memory";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg3a. Transient Views")).menuIcon(ICON)).menuPath(new String[]{"Window", "Debugger", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractNewListingAction
    extends DockingAction {
        public static final String NAME = "New Dynamic Listing";
        public static final Icon ICON = ICON_LISTING;
        public static final String HELP_ANCHOR = "new_listing";

        public AbstractNewListingAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Open a new dynamic disassembly listing");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractImportFromFileSystemAction
    extends DockingAction {
        public static final String NAME = "Import From File System";
        public static final String HELP_ANCHOR = "import_from_fs";

        public AbstractImportFromFileSystemAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Import and map the selected module by path from the local file system");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractCaptureSymbolsAction
    extends DockingAction {
        public static final String NAME = "Capture Symbols";
        public static final Icon ICON = ICON_CAPTURE_SYMBOLS;
        public static final String HELP_ANCHOR = "capture_symbols";

        public AbstractCaptureSymbolsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Capture symbols from selected modules");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractCaptureTypesAction
    extends DockingAction {
        public static final String NAME = "Capture Data Types";
        public static final Icon ICON = ICON_DATA_TYPES;
        public static final String HELP_ANCHOR = "capture_types";

        public AbstractCaptureTypesAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Capture data types from selected modules");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSelectAddressesAction
    extends DockingAction {
        public static final String NAME = "Select Addresses";
        public static final Icon ICON = ICON_SELECT_ADDRESSES;
        public static final String HELP_ANCHOR = "select_addresses";

        public AbstractSelectAddressesAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface MapSectionsToAction {
        public static final String NAME_PREFIX = "Map Sections to ";
        public static final String DESCRIPTION = "Map the selected module sections to the current program";
        public static final Icon ICON = ICON_MAP_SECTIONS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Sections to ..."})).popupMenuGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapSectionToAction {
        public static final String NAME_PREFIX = "Map Section to ";
        public static final String DESCRIPTION = "Map the selected module to the current program";
        public static final Icon ICON = ICON_MAP_SECTIONS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_section_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Section to ..."})).popupMenuGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapSectionsAction {
        public static final String NAME = "Map Sections";
        public static final String DESCRIPTION = "Map selected sections to program memory blocks";
        public static final Icon ICON = ICON_MAP_SECTIONS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_sections";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapModuleToAction {
        public static final String NAME_PREFIX = "Map Module to ";
        public static final String DESCRIPTION = "Map the selected module to the current program";
        public static final Icon ICON = ICON_MAP_MODULES;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_module_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Module to ..."})).popupMenuGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapModulesAction {
        public static final String NAME = "Map Modules";
        public static final String DESCRIPTION = "Map selected modules to program images";
        public static final Icon ICON = ICON_MAP_MODULES;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_modules";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface MapIdenticallyAction {
        public static final String NAME = "Map Identically";
        public static final String DESCRIPTION = "Map the current trace to the current program using identical addresses";
        public static final Icon ICON = ICON_MAP_IDENTICALLY;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_identically";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg9. Map Modules/Sections")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractToggleAction
    extends DockingAction {
        public static final String NAME = "Toggle";
        public static final Icon ICON = ICON_TOGGLE;
        public static final String HELP_ANCHOR = "toggle_option";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractToggleAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable or disable an option");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractMakeBreakpointsEffectiveAction
    extends DockingAction {
        public static final String NAME = "Make Breakpoints Effective";
        public static final Icon ICON = ICON_MAKE_BREAKPOINTS_EFFECTIVE;
        public static final String HELP_ANCHOR = "make_breakpoints_effective";

        public AbstractMakeBreakpointsEffectiveAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Place enabled but ineffective breakpoints where possible");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Clear All Breakpoints";
        public static final Icon ICON = ICON_CLEAR_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "clear_all_breakpoints";

        public AbstractClearAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Clear Breakpoints";
        public static final Icon ICON = ICON_CLEAR_BREAKPOINT;
        public static final String HELP_ANCHOR = "clear_breakpoints";

        public AbstractClearSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractClearBreakpointAction
    extends DockingAction {
        public static final String NAME = "Clear Breakpoint";
        public static final Icon ICON = ICON_CLEAR_BREAKPOINT;
        public static final String HELP_ANCHOR = "clear_breakpoint";

        public AbstractClearBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Clear this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Disable All Breakpoints";
        public static final Icon ICON = ICON_DISABLE_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "disable_all_breakpoints";

        public AbstractDisableAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Disable Breakpoints";
        public static final Icon ICON = ICON_DISABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "disable_breakpoints";

        public AbstractDisableSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisableBreakpointAction
    extends DockingAction {
        public static final String NAME = "Disable Breakpoint";
        public static final Icon ICON = ICON_DISABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "disable_breakpoint";

        public AbstractDisableBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Disable this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableAllBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Enable All Breakpoints";
        public static final Icon ICON = ICON_ENABLE_ALL_BREAKPOINTS;
        public static final String HELP_ANCHOR = "enable_all_breakpoints";

        public AbstractEnableAllBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable all breakpoints in the table");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableSelectedBreakpointsAction
    extends DockingAction {
        public static final String NAME = "Enable Breakpoints";
        public static final Icon ICON = ICON_ENABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "enable_breakpoints";

        public AbstractEnableSelectedBreakpointsAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enabled the selected breakpoints");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractEnableBreakpointAction
    extends DockingAction {
        public static final String NAME = "Enable Breakpoint";
        public static final Icon ICON = ICON_ENABLE_BREAKPOINT;
        public static final String HELP_ANCHOR = "enable_breakpoint";

        public AbstractEnableBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Enable this breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSetBreakpointAction
    extends DockingAction {
        public static final String NAME = "Set Breakpoint";
        public static final Icon ICON = ICON_SET_BREAKPOINT;
        public static final String HELP_ANCHOR = "set_breakpoint";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractSetBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Trap execution");
            this.setHelpLocation(AbstractSetBreakpointAction.help(owner));
        }
    }

    public static abstract class AbstractToggleBreakpointAction
    extends DockingAction {
        public static final String NAME = "Toggle Breakpoint";
        public static final Icon ICON = ICON_BREAKPOINT_MIXED_ED_MARKER;
        public static final String HELP_ANCHOR = "toggle_breakpoint";

        public AbstractToggleBreakpointAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Set, enable, or disable a breakpoint");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface OpenProgramAction {
        public static final String NAME = "Open Program";
        public static final Icon ICON = ICON_PROGRAM;
        public static final String DESCRIPTION = "Open the program";
        public static final String HELP_ANCHOR = "open_program";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoNewProgramAction
    extends CopyIntoProgramAction {
        public static final String NAME = String.format("Copy Into %s Program", "New");
        public static final String DESCRIPTION = String.format("Copy the current selection into %s program", "a new");
        public static final String HELP_ANCHOR = "copy_into_new";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(DebuggerResources.GROUP_MAINTENANCE)).menuPath(new String[]{"Debugger", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoCurrentProgramAction
    extends CopyIntoProgramAction {
        public static final String NAME = String.format("Copy Into %s Program", "Current");
        public static final String DESCRIPTION = String.format("Copy the current selection into %s program", "the current");
        public static final String HELP_ANCHOR = "copy_into_current";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(DebuggerResources.GROUP_MAINTENANCE)).menuPath(new String[]{"Debugger", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CopyIntoProgramAction {
        public static final String NAME_PAT = "Copy Into %s Program";
        public static final String DESC_PAT = "Copy the current selection into %s program";
        public static final String GROUP = "Dbg8. Maintenance";
    }

    public static interface ExportTraceViewAction {
        public static final String NAME = "Export Trace View";
        public static final String DESCRIPTION = "Export the current view as if a Ghidra program";
        public static final String GROUP = "Dbg8. Maintenance";
        public static final String HELP_ANCHOR = "export_view";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup("Dbg8. Maintenance")).menuPath(new String[]{"Debugger", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectRowsAction {
        public static final String NAME = "Select Rows";
        public static final Icon ICON = ICON_SELECT_ROWS;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "select_rows";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).toolBarIcon(ICON);
        }
    }

    public static interface SelectNoneAction {
        public static final String NAME = "Select None";
        public static final String GROUP = "Select";
        public static final String HELP_ANCHOR = "select_none";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).popupMenuGroup(GROUP)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface FilterAction {
        public static final String NAME = "Filter";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_FILTER;

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON);
        }
    }

    public static interface ClearAction {
        public static final String NAME = "Clear";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_CLEAR;
        public static final String HELP_ANCHOR = "clear";

        public static ActionBuilder builder(Plugin owner) {
            return ClearAction.builder(owner.getName());
        }

        public static ActionBuilder builder(String ownerName) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface RemoveAction {
        public static final String NAME = "Remove";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_DELETE;
        public static final String HELP_ANCHOR = "remove";

        public static ActionBuilder builder(Plugin owner) {
            return RemoveAction.builder(owner.getName());
        }

        public static ActionBuilder builder(String ownerName) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface AddAction {
        public static final String NAME = "Add";
        public static final String GROUP = "yyyy";
        public static final Icon ICON = ICON_ADD;
        public static final String HELP_ANCHOR = "add";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface DisassembleAsAction {
        public static final String NAME = "Disassemble as";
        public static final String DESCRIPTION = "Disassemble using an alternative language";
        public static final Icon ICON = ResourceManager.loadImage((String)"images/disassemble.png");
        public static final String HELP_ANCHOR = "disassemble_as";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EnableEditsAction {
        public static final String NAME = "Enable Edits";
        public static final String DESCRIPTION = "Enable editing of recorded or live values";
        public static final String GROUP = "yyyy2";
        public static final Icon ICON = ResourceManager.loadImage((String)"images/editbytes.gif");
        public static final String HELP_ANCHOR = "enable_edits";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface CreateSnapshotAction {
        public static final String NAME = "Create Snapshot";
        public static final String DESCRIPTION = "Create a (disconnected) snapshot copy of this window";
        public static final String GROUP = "zzzz";
        public static final Icon ICON = ResourceManager.loadImage((String)"images/camera-photo.png");
        public static final String HELP_ANCHOR = "snapshot_window";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface SelectRegistersAction {
        public static final String NAME = "Select Registers";
        public static final String DESCRIPTION = "Select registers to display/modify";
        public static final String GROUP = "aa";
        public static final Icon ICON = ResourceManager.loadImage((String)"images/select-registers.png");
        public static final String HELP_ANCHOR = "select_registers";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarGroup(GROUP)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractRefreshAction
    extends DockingAction {
        public static final String NAME = "Refresh";
        public static final Icon ICON = ICON_REFRESH;

        public AbstractRefreshAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Refresh the view");
            this.setHelpLocation(new HelpLocation(owner.getName(), "refresh"));
        }
    }

    public static interface AutoReadMemoryAction {
        public static final String NAME = "Auto-Read Target Memory";
        public static final String DESCRIPTION = "Automatically read and record visible memory from the live target";
        public static final String HELP_ANCHOR = "auto_memory";
        public static final String NAME_VIS_RO_ONCE = "Read Visible Memory, RO Once";
        public static final String NAME_VISIBLE = "Read Visible Memory";
        public static final String NAME_NONE = "Do Not Read Memory";
        public static final Icon ICON_VIS_RO_ONCE = ICON_AUTOREAD;
        public static final Icon ICON_VISIBLE = ICON_AUTOREAD;
        public static final Icon ICON_NONE = ICON_DELETE;

        public static <T> MultiStateActionBuilder<T> builder(Plugin owner) {
            String ownerName = owner.getName();
            return (MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractFollowsCurrentThreadAction
    extends ToggleDockingAction {
        public static final String NAME = "Follows Selected Thread";
        public static final String HELP_ANCHOR = "follows_thread";

        public AbstractFollowsCurrentThreadAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Register tracking follows selected thread (and contents follow selected trace)");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface MapMissingModuleAction {
        public static final String NAME = "Map Missing Module";
        public static final String DESCRIPTION = "Map the missing module to an existing import";
        public static final Icon ICON = ICON_MAP_MODULES;
        public static final String HELP_ANCHOR = "map_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface ImportMissingModuleAction {
        public static final String NAME = "Import Missing Module";
        public static final String DESCRIPTION = "Import the missing module from disk";
        public static final Icon ICON = ICON_IMPORT;
        public static final String HELP_ANCHOR = "import_missing_module";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).popupMenuIcon(ICON)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractSyncToStaticListingAction
    extends ToggleDockingAction {
        public static final String NAME = "Sync to Static Listing";
        public static final String HELP_ANCHOR = "sync_static";

        public AbstractSyncToStaticListingAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Synchronize the static listing (and related providers) to the dynamic listing (and related providers) where a mapping is known");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface GoToAction {
        public static final String NAME = "Go To";
        public static final String DESCRIPTION = "Seek this listing to an arbitrary expression";
        public static final String HELP_ANCHOR = "go_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).keyBinding(KeyStroke.getKeyStroke(71, 0))).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface TrackLocationAction {
        public static final String NAME = "Track Location";
        public static final String DESCRIPTION = "Follow a location in this view";
        public static final String HELP_ANCHOR = "track_location";
        public static final String NAME_PC = "Track Program Counter";
        public static final String NAME_SP = "Track Stack Pointer";
        public static final String NAME_NONE = "Do Not Track";
        public static final Icon ICON_PC = ICON_REGISTER_MARKER;
        public static final Icon ICON_SP = ICON_REGISTER_MARKER;
        public static final Icon ICON_NONE = ICON_DELETE;

        public static <T> MultiStateActionBuilder<T> builder(Plugin owner) {
            String ownerName = owner.getName();
            return (MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, ownerName).description(DESCRIPTION)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractReadSelectedMemoryAction
    extends DockingAction {
        public static final String NAME = "Read Selected Memory";
        public static final Icon ICON = ICON_READ_MEMORY;
        public static final String HELP_ANCHOR = "read_memory";

        public AbstractReadSelectedMemoryAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("(Re-)read and record memory for the selected addresses into the trace database");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractRecordAction
    extends DockingAction {
        public static final String NAME = "Record";
        public static final Icon ICON = ICON_TRACE;

        public AbstractRecordAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Record the process into a trace and open it (live trace)");
            this.setHelpLocation(new HelpLocation(owner.getName(), "record"));
        }
    }

    public static interface InterpreterInterruptAction {
        public static final String NAME = "Interpreter Interrupt";
        public static final String DESCRIPTION = "Send an interrupt through this Interpreter";
        public static final Icon ICON = ICON_TERMINATE;
        public static final String HELP_ANCHOR = "interrupt";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(ownerName, NAME).description(DESCRIPTION)).toolBarIcon(ICON)).keyBinding("CTRL I")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface PinInterpreterAction {
        public static final String NAME = "Pin Interpreter";
        public static final String DESCRIPTION = "Prevent this Interpreter from closing automatically";
        public static final Icon ICON = ICON_PIN;
        public static final String HELP_ANCHOR = "pin";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(ownerName, NAME).description(DESCRIPTION)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface DisconnectAllAction {
        public static final String NAME = "Disconnect All";
        public static final String DESCRIPTION = "Close and Debugger Model Connections";
        public static final Icon ICON = ICON_DISCONNECT;
        public static final String HELP_ANCHOR = "disconnect_all";

        public static ActionBuilder builder(Plugin owner, Plugin helpOwner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(owner.getName(), NAME).description(DESCRIPTION)).menuIcon(ICON)).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDisconnectAction
    extends DockingAction {
        public static final String NAME = "Disconnect";
        public static final Icon ICON = ICON_DISCONNECT;
        public static final String HELP_ANCHOR = "disconnect";

        public AbstractDisconnectAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Close the connection to the debugging agent");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractDetachAction
    extends DockingAction {
        public static final String NAME = "Detach";
        public static final Icon ICON = ICON_DETACH;
        public static final String HELP_ANCHOR = "detach";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractDetachAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Detach from the target (this may cause it to resume)");
            this.setHelpLocation(AbstractDetachAction.help(owner));
        }
    }

    public static abstract class AbstractKillAction
    extends DockingAction {
        public static final String NAME = "Kill";
        public static final Icon ICON = ICON_KILL;
        public static final String HELP_ANCHOR = "kill";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractKillAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Kill, i.e., forcibly terminate, the target");
            this.setHelpLocation(AbstractKillAction.help(owner));
        }
    }

    public static abstract class AbstractInterruptAction
    extends DockingAction {
        public static final String NAME = "Interrupt";
        public static final Icon ICON = ICON_TERMINATE;
        public static final String HELP_ANCHOR = "interrupt";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractInterruptAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Interrupt, i.e., suspend, the target");
            this.setHelpLocation(AbstractInterruptAction.help(owner));
        }
    }

    public static abstract class AbstractStepLastAction
    extends DockingAction {
        public static final String NAME = "Step Last";
        public static final Icon ICON = ICON_STEP_FINISH;
        public static final String HELP_ANCHOR = "step_last";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepLastAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Repeat the last stepping action");
            this.setHelpLocation(AbstractStepLastAction.help(owner));
        }
    }

    public static abstract class AbstractStepFinishAction
    extends DockingAction {
        public static final String NAME = "Step Finish";
        public static final Icon ICON = ICON_STEP_FINISH;
        public static final String HELP_ANCHOR = "step_finish";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepFinishAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target out of the current frame");
            this.setHelpLocation(AbstractStepFinishAction.help(owner));
        }
    }

    public static abstract class AbstractStepOverAction
    extends DockingAction {
        public static final String NAME = "Step Over";
        public static final Icon ICON = ICON_STEP_OVER;
        public static final String HELP_ANCHOR = "step_over";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepOverAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target a single instruction, without following calls");
            this.setHelpLocation(AbstractStepOverAction.help(owner));
        }
    }

    public static abstract class AbstractStepIntoAction
    extends DockingAction {
        public static final String NAME = "Step Into";
        public static final Icon ICON = ICON_STEP_INTO;
        public static final String HELP_ANCHOR = "step_into";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractStepIntoAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Step the target a single instruction, descending into calls");
            this.setHelpLocation(AbstractStepIntoAction.help(owner));
        }
    }

    public static abstract class AbstractResumeAction
    extends DockingAction {
        public static final String NAME = "Resume";
        public static final Icon ICON = ICON_RESUME;
        public static final String HELP_ANCHOR = "resume";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractResumeAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Resume, i.e., go or continue execution of, the target");
            this.setHelpLocation(AbstractResumeAction.help(owner));
        }
    }

    public static abstract class AbstractAttachAction
    extends DockingAction {
        public static final String NAME = "Attach";
        public static final Icon ICON = ICON_ATTACH;
        public static final String DESCRIPTION = "Attach to an existing target accessible to the agent";
        public static final String HELP_ANCHOR = "attach";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractAttachAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription(DESCRIPTION);
            this.setHelpLocation(AbstractAttachAction.help(owner));
        }
    }

    public static abstract class AbstractQuickLaunchAction
    extends DockingAction {
        public static final String NAME = "Quick Launch";
        public static final Icon ICON = ICON_DEBUGGER;
        public static final String HELP_ANCHOR = "quick_launch";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractQuickLaunchAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Load a trace in a local or selected connection");
            this.setHelpLocation(AbstractQuickLaunchAction.help(owner));
        }
    }

    public static interface EmulateAddThreadAction {
        public static final String NAME = "Add Emulated Thread to Trace";
        public static final String DESCRIPTION = "Add an emulated thread to the current trace starting here";
        public static final Icon ICON = ICON_THREAD;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "add_emulated_thread";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuIcon(ICON)).menuGroup("Dbg1. General")).popupMenuPath(new String[]{NAME})).popupMenuIcon(ICON)).popupMenuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface EmulateProgramAction {
        public static final String NAME = "Emulate Program in new Trace";
        public static final String DESCRIPTION = "Emulate the current program in a new trace starting at the cursor";
        public static final Icon ICON = ICON_EMULATE;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "emulate_program";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg1. General")).menuPath(new String[]{"Debugger", NAME})).menuIcon(ICON)).menuGroup("Dbg1. General")).popupMenuPath(new String[]{NAME})).popupMenuIcon(ICON)).popupMenuGroup("Dbg1. General")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static interface DebugProgramAction {
        public static final String NAME = "Debug Program";
        public static final Icon ICON = ICON_DEBUGGER;
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "debug_program";

        public static <T> MultiStateActionBuilder<T> buttonBuilder(Plugin owner, Plugin helpOwner) {
            return (MultiStateActionBuilder)((MultiStateActionBuilder)((MultiStateActionBuilder)new MultiStateActionBuilder(NAME, owner.getName()).toolBarIcon(ICON)).toolBarGroup("Dbg1. General")).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }

        public static ActionBuilder menuBuilder(DebuggerProgramLaunchOffer offer, Plugin owner, Plugin helpOwner) {
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), owner.getName()).description(offer.getButtonTitle())).menuPath(new String[]{"Debugger", offer.getMenuParentTitle(), offer.getMenuTitle()})).menuIcon(offer.getIcon())).menuGroup("Dbg1. General")).helpLocation(new HelpLocation(helpOwner.getName(), HELP_ANCHOR));
        }
    }

    public static abstract class AbstractLaunchAction
    extends DockingAction {
        public static final String NAME = "Launch";
        public static final Icon ICON = ICON_LAUNCH;
        public static final String HELP_ANCHOR = "launch";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractLaunchAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Launch a target");
            this.setHelpLocation(AbstractLaunchAction.help(owner));
        }
    }

    public static abstract class AbstractConsoleAction
    extends DockingAction {
        public static final String NAME = "Console";
        public static final Icon ICON = ICON_CONSOLE;
        public static final String HELP_ANCHOR = "console";

        public static HelpLocation help(Plugin owner) {
            return new HelpLocation(owner.getName(), HELP_ANCHOR);
        }

        public AbstractConsoleAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Issue commands to the debugger's interpreter");
            this.setHelpLocation(AbstractConsoleAction.help(owner));
        }
    }

    public static abstract class AbstractConnectAction
    extends DockingAction {
        public static final String NAME = "Connect";
        public static final Icon ICON = ICON_CONNECTION;
        public static final String HELP_ANCHOR = "connect";

        public static void styleButton(JButton button) {
            button.setText(NAME);
            button.setIcon(ICON);
        }

        public AbstractConnectAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Create a new connection to an debugging agent");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }

    public static interface SaveTraceAction {
        public static final String NAME_PREFIX = "Save ";
        public static final String DESCRIPTION = "Save the selected trace";
        public static final Icon ICON = ICON_SAVE;
        public static final String GROUP = "Dbg7. Trace";
        public static final String HELP_ANCHOR = "save_trace";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Save ..."})).menuIcon(ICON)).menuGroup("Dbg7. Trace")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    public static abstract class AbstractFlushCachesAction
    extends DockingAction {
        public static final String NAME = "Flush Caches";
        public static final String HELP_ANCHOR = "flush_caches";

        public AbstractFlushCachesAction(Plugin owner) {
            super(NAME, owner.getName());
            this.setDescription("Flush the targets' client-side caches");
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }
    }
}

