/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.colors;

import docking.widgets.fieldpanel.support.BackgroundColorModel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public abstract class DebuggerTrackedRegisterBackgroundColorModel
implements BackgroundColorModel {
    protected Color defaultBackgroundColor;
    protected Program program;
    protected AddressIndexMap addressIndexMap;
    @AutoOptionConsumed(name={"Colors.Tracking Markers"})
    Color trackingColor;
    private final AutoOptions.Wiring autoOptionsWiring;

    public DebuggerTrackedRegisterBackgroundColorModel(Plugin plugin) {
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
    }

    protected abstract ProgramLocation getTrackedLocation();

    public Color getBackgroundColor(BigInteger index) {
        if (this.addressIndexMap == null) {
            return this.defaultBackgroundColor;
        }
        ProgramLocation loc = this.getTrackedLocation();
        if (loc == null) {
            return this.defaultBackgroundColor;
        }
        Address address = this.addressIndexMap.getAddress(index);
        if (!loc.getAddress().equals((Object)address)) {
            return this.defaultBackgroundColor;
        }
        return this.trackingColor;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }
}

