/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsoleProvider;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import javax.swing.Icon;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;

@PluginInfo(shortDescription="Debugger console panel plugin", description="A tool-global console for controlling a debug/trace session", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesRequired={}, servicesProvided={DebuggerConsoleService.class})
public class DebuggerConsolePlugin
extends Plugin
implements DebuggerConsoleService {
    protected static final String APPENDER_NAME = "debuggerAppender";
    protected DebuggerConsoleProvider provider;
    protected final ConsolePluginAppender appender = new ConsolePluginAppender();
    protected Logger rootLogger;

    public DebuggerConsolePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.provider = new DebuggerConsoleProvider(this);
        this.rootLogger = (Logger)LogManager.getRootLogger();
        this.appender.start();
        this.rootLogger.addAppender((Appender)this.appender);
    }

    protected void dispose() {
        if (this.rootLogger != null) {
            this.rootLogger.removeAppender((Appender)this.appender);
            this.appender.stop();
            this.provider.dispose();
            this.tool.removeComponentProvider((ComponentProvider)this.provider);
        }
        super.dispose();
    }

    @Override
    public void log(Icon icon, String message) {
        this.provider.log(icon, message);
    }

    @Override
    public void log(Icon icon, String message, ActionContext context) {
        this.provider.log(icon, message, context);
    }

    @Override
    public void removeFromLog(ActionContext context) {
        this.provider.removeFromLog(context);
    }

    @Override
    public boolean logContains(ActionContext context) {
        return this.provider.logContains(context);
    }

    @Override
    public void addResolutionAction(DockingActionIf action) {
        this.provider.addResolutionAction(action);
    }

    @Override
    public void removeResolutionAction(DockingActionIf action) {
        this.provider.removeResolutionAction(action);
    }

    public long getRowCount(Class<? extends ActionContext> ctxCls) {
        return this.provider.getRowCount(ctxCls);
    }

    public DebuggerConsoleProvider.LogRow getLogRow(ActionContext ctx) {
        return this.provider.getLogRow(ctx);
    }

    protected class ConsolePluginAppender
    extends AbstractAppender {
        public ConsolePluginAppender() {
            super(DebuggerConsolePlugin.APPENDER_NAME, null, null, true, Property.EMPTY_ARRAY);
            this.addFilter((Filter)LevelRangeFilter.createFilter((Level)Level.FATAL, (Level)Level.INFO, null, null));
        }

        public void append(LogEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName.contains(".debug") || loggerName.contains(".dbg.") || loggerName.contains("agent.")) {
                DebuggerConsolePlugin.this.provider.logEvent(event);
            }
        }
    }
}

