/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.nav.ListingPanelContainer;
import ghidra.app.plugin.core.clipboard.CodeBrowserClipboardProvider;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerLocationLabel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerReadsMemoryTrait;
import ghidra.app.plugin.core.debug.gui.action.DebuggerTrackLocationTrait;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerListingPlugin;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerOpenProgramActionContext;
import ghidra.app.plugin.core.debug.gui.listing.MultiBlendedListingBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerMissingModuleActionContext;
import ghidra.app.plugin.core.debug.utils.ProgramLocationUtils;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Element;
import utilities.util.SuppressableCallback;

public class DebuggerListingProvider
extends CodeViewerProvider {
    private static final AutoConfigState.ClassHandler<DebuggerListingProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerListingProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    private final DebuggerListingPlugin plugin;
    private DebuggerTraceManagerService traceManager;
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private ProgramManager programManager;
    @AutoServiceConsumed
    private FileImporterService importerService;
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionConsumed(name={"Colors.Tracking Markers"})
    private Color trackingColor;
    private final AutoOptions.Wiring autoOptionsWiring;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected Program markedProgram;
    protected Address markedAddress;
    protected MarkerSet trackingMarker;
    protected DockingAction actionGoTo;
    protected SyncToStaticListingAction actionSyncToStaticListing;
    protected FollowsCurrentThreadAction actionFollowsCurrentThread;
    protected MultiStateDockingAction<AutoReadMemorySpec> actionAutoReadMemory;
    protected DockingAction actionReadSelectedMemory;
    protected DockingAction actionOpenProgram;
    protected MultiStateDockingAction<LocationTrackingSpec> actionTrackLocation;
    @AutoConfigStateField
    protected boolean syncToStaticListing;
    @AutoConfigStateField
    protected boolean followsCurrentThread = true;
    protected final DebuggerGoToTrait goToTrait;
    protected final ForListingTrackingTrait trackingTrait;
    protected final ForListingReadsMemoryTrait readsMemTrait;
    protected final ListenerSet<DebuggerListingService.LocationTrackingSpecChangeListener> trackingSpecChangeListeners = new ListenerSet(DebuggerListingService.LocationTrackingSpecChangeListener.class);
    protected final DebuggerLocationLabel locationLabel = new DebuggerLocationLabel();
    protected final MultiBlendedListingBackgroundColorModel colorModel;
    protected final MarkerSetChangeListener markerChangeListener = new MarkerSetChangeListener();
    protected MarkerServiceBackgroundColorModel markerServiceColorModel;
    private SuppressableCallback<ProgramLocation> cbGoTo = new SuppressableCallback();
    protected final ForStaticSyncMappingChangeListener mappingChangeListener = new ForStaticSyncMappingChangeListener();
    protected final boolean isMainListing;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getRecorder(), b.getRecorder())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerListingProvider(DebuggerListingPlugin plugin, FormatManager formatManager, boolean isConnected) {
        super((CodeBrowserPluginInterface)plugin, formatManager, isConnected);
        this.plugin = plugin;
        this.isMainListing = isConnected;
        this.goToTrait = new ForListingGoToTrait();
        this.trackingTrait = new ForListingTrackingTrait();
        this.readsMemTrait = new ForListingReadsMemoryTrait();
        ListingPanel listingPanel = this.getListingPanel();
        this.colorModel = plugin.createListingBackgroundColorModel(listingPanel);
        this.colorModel.addModel((BackgroundColorModel)this.trackingTrait.createListingBackgroundColorModel(listingPanel));
        listingPanel.setBackgroundColorModel((ListingBackgroundColorModel)this.colorModel);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.autoOptionsWiring = AutoOptions.wireOptionsConsumed((Plugin)plugin, (Object)((Object)this));
        this.syncToStaticListing = isConnected;
        this.setVisible(true);
        this.createActions();
        this.goToTrait.goToCoordinates(this.current);
        this.trackingTrait.goToCoordinates(this.current);
        this.readsMemTrait.goToCoordinates(this.current);
        this.locationLabel.goToCoordinates(this.current);
        this.addDisplayListener(this.readsMemTrait.getDisplayListener());
        this.setNorthComponent(this.locationLabel);
        if (isConnected) {
            this.setTitle("Dynamic");
        } else {
            this.setTitle("[Dynamic]");
        }
        this.updateTitle();
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_LISTING);
    }

    public boolean isConnected() {
        return false;
    }

    public boolean isMainListing() {
        return this.isMainListing;
    }

    public boolean isReadOnly() {
        return this.current.isAliveAndPresent();
    }

    public boolean isDynamicListing() {
        return true;
    }

    public String getWindowGroup() {
        return "Core";
    }

    public void writeDataState(SaveState saveState) {
        if (!this.isMainListing()) {
            this.current.writeDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
        }
        super.writeDataState(saveState);
    }

    public void readDataState(SaveState saveState) {
        if (!this.isMainListing()) {
            DebuggerCoordinates coordinates = DebuggerCoordinates.readDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES, true);
            this.coordinatesActivated(coordinates);
        }
        super.readDataState(saveState);
    }

    void writeConfigState(SaveState saveState) {
        SaveState formatManagerState = new SaveState("formatManager");
        this.getListingPanel().getFormatManager().saveState(formatManagerState);
        saveState.putXmlElement("formatManager", formatManagerState.saveToXml());
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
        this.trackingTrait.writeConfigState(saveState);
        this.readsMemTrait.writeConfigState(saveState);
    }

    void readConfigState(SaveState saveState) {
        Element formatManagerElement = saveState.getXmlElement("formatManager");
        if (formatManagerElement != null) {
            SaveState formatManagerState = new SaveState(formatManagerElement);
            this.getListingPanel().getFormatManager().readState(formatManagerState);
        }
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.trackingTrait.readConfigState(saveState);
        this.readsMemTrait.readConfigState(saveState);
        if (this.isMainListing()) {
            this.actionSyncToStaticListing.setSelected(this.syncToStaticListing);
            this.followsCurrentThread = true;
        } else {
            this.syncToStaticListing = false;
            this.actionFollowsCurrentThread.setSelected(this.followsCurrentThread);
            this.updateBorder();
        }
    }

    public void addToTool() {
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.setDefaultWindowPosition(WindowPosition.STACK);
        super.addToTool();
    }

    protected CodeBrowserClipboardProvider newClipboardProvider() {
        return new CodeBrowserClipboardProvider(this.tool, (ComponentProvider)this){

            protected boolean pasteBytes(Transferable pasteData) throws UnsupportedFlavorException, IOException {
                return false;
            }

            protected boolean pasteByteString(String string) {
                return false;
            }
        };
    }

    protected void updateMarkerServiceColorModel() {
        this.colorModel.removeModel((BackgroundColorModel)this.markerServiceColorModel);
        if (this.markerService != null) {
            this.markerServiceColorModel = new MarkerServiceBackgroundColorModel(this.markerService, (Program)this.current.getView(), this.getListingPanel().getAddressIndexMap());
            this.colorModel.addModel((BackgroundColorModel)this.markerServiceColorModel);
        }
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.traceManager = traceManager;
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener(this.mappingChangeListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener(this.mappingChangeListener);
            this.doMarkTrackedLocation();
            this.doSyncToStatic(this.getLocation());
        }
    }

    protected void removeOldStaticTrackingMarker() {
        if (this.markerService != null && this.trackingMarker != null) {
            this.markerService.removeMarker(this.trackingMarker, this.markedProgram);
            this.trackingMarker = null;
        }
    }

    protected void createNewStaticTrackingMarker() {
        if (this.markerService != null && this.markedAddress != null) {
            this.trackingMarker = this.markerService.createPointMarker("Tracked Register", "An address stored by a trace register, mapped to a static program", this.markedProgram, 0, true, true, true, this.trackingColor, DebuggerResources.ICON_REGISTER_MARKER, true);
            this.trackingMarker.add(this.markedAddress);
        }
    }

    @AutoOptionConsumed(name={"Colors.Tracking Markers"})
    private void setTrackingColor(Color trackingColor) {
        if (this.trackingMarker != null) {
            this.trackingMarker.setMarkerColor(trackingColor);
        }
    }

    @AutoServiceConsumed
    private void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.removeChangeListener((ChangeListener)this.markerChangeListener);
        }
        this.removeOldStaticTrackingMarker();
        this.markerService = markerService;
        this.createNewStaticTrackingMarker();
        this.updateMarkerServiceColorModel();
        if (this.markerService != null && !this.isMainListing()) {
            this.markerService.addChangeListener((ChangeListener)this.markerChangeListener);
        }
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null && this.actionOpenProgram != null) {
            consoleService.addResolutionAction((DockingActionIf)this.actionOpenProgram);
        }
    }

    protected void markTrackedStaticLocation(ProgramLocation location) {
        Swing.runIfSwingOrRunLater(() -> {
            if (location == null) {
                this.removeOldStaticTrackingMarker();
                this.markedAddress = null;
                this.markedProgram = null;
            } else if (this.trackingMarker != null && location.getProgram() == this.markedProgram) {
                this.trackingMarker.clearAll();
                this.markedAddress = location.getAddress();
                this.trackingMarker.add(this.markedAddress);
            } else {
                this.removeOldStaticTrackingMarker();
                this.markedAddress = location.getAddress();
                this.markedProgram = location.getProgram();
                this.createNewStaticTrackingMarker();
            }
        });
    }

    public void programOpened(Program program) {
        if (!this.isMainListing()) {
            return;
        }
        DomainFile df = program.getDomainFile();
        DebuggerOpenProgramActionContext ctx = new DebuggerOpenProgramActionContext(df);
        if (this.consoleService != null) {
            this.consoleService.removeFromLog(ctx);
        }
    }

    public void programClosed(Program program) {
        if (program == this.markedProgram) {
            this.removeOldStaticTrackingMarker();
            this.markedProgram = null;
            this.markedAddress = null;
        }
    }

    protected void doSetProgram(Program newProgram) {
        if (newProgram != null && newProgram != this.current.getView()) {
            throw new AssertionError();
        }
        if (this.getProgram() == newProgram) {
            return;
        }
        if (newProgram != null && !(newProgram instanceof TraceProgramView)) {
            throw new IllegalArgumentException("Dynamic Listings require trace views");
        }
        this.setSelection(new ProgramSelection());
        super.doSetProgram(newProgram);
        this.updateTitle();
        this.locationLabel.updateLabel();
    }

    protected String computeSubTitle() {
        String specTitle;
        LocationTrackingSpec trackingSpec;
        TraceProgramView view = this.current.getView();
        ArrayList<String> parts = new ArrayList<String>();
        LocationTrackingSpec locationTrackingSpec = trackingSpec = this.trackingTrait == null ? null : this.trackingTrait.getSpec();
        if (trackingSpec != null && (specTitle = trackingSpec.computeTitle(this.current)) != null) {
            parts.add(specTitle);
        }
        if (view != null) {
            parts.add(this.current.getTrace().getDomainFile().getName());
        }
        return StringUtils.join(parts, (String)", ");
    }

    protected void updateTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    protected String computePanelTitle(Program panelProgram) {
        if (!(panelProgram instanceof TraceProgramView)) {
            return super.computePanelTitle(panelProgram);
        }
        TraceProgramView view = (TraceProgramView)panelProgram;
        TraceSnapshot snapshot = view.getTrace().getTimeManager().getSnapshot(view.getSnap(), false);
        if (snapshot == null) {
            return Long.toString(view.getSnap());
        }
        String description = snapshot.getDescription();
        String schedule = snapshot.getScheduleString();
        if (description == null) {
            description = "";
        }
        if (schedule == null) {
            schedule = "";
        }
        if (!description.isBlank() && !schedule.isBlank()) {
            return description + " (" + schedule + ")";
        }
        if (!description.isBlank()) {
            return description;
        }
        if (!schedule.isBlank()) {
            return schedule;
        }
        return DateUtils.formatDateTimestamp((Date)new Date(snapshot.getRealTime()));
    }

    protected void createActions() {
        if (this.isMainListing()) {
            this.actionSyncToStaticListing = new SyncToStaticListingAction();
        } else {
            this.actionFollowsCurrentThread = new FollowsCurrentThreadAction();
        }
        this.actionGoTo = this.goToTrait.installAction();
        this.actionTrackLocation = this.trackingTrait.installAction();
        this.actionAutoReadMemory = this.readsMemTrait.installAutoReadAction();
        this.actionReadSelectedMemory = this.readsMemTrait.installReadSelectedAction();
        this.actionOpenProgram = (DockingAction)DebuggerResources.OpenProgramAction.builder((Plugin)this.plugin).withContext(DebuggerOpenProgramActionContext.class).onAction(this::activatedOpenProgram).build();
        this.contextChanged();
    }

    private void activatedOpenProgram(DebuggerOpenProgramActionContext context) {
        this.programManager.openProgram(context.getDomainFile(), -1, 1);
    }

    protected boolean isEffectivelyDifferent(ProgramLocation cur, ProgramLocation dest) {
        if (Objects.equals(cur, dest)) {
            return false;
        }
        if (cur == null || dest == null) {
            return true;
        }
        if (dest.getClass() != ProgramLocation.class) {
            return true;
        }
        TraceProgramView curView = (TraceProgramView)cur.getProgram();
        TraceProgramView destView = (TraceProgramView)dest.getProgram();
        if (curView.getTrace() != destView.getTrace()) {
            return true;
        }
        return !Objects.equals(cur.getAddress(), dest.getAddress());
    }

    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        ProgramLocation trackedLocation = this.trackingTrait.getTrackedLocation();
        if (trackedLocation != null && !this.isEffectivelyDifferent(this.getLocation(), trackedLocation)) {
            this.cbGoTo.invoke(() -> this.getListingPanel().goTo(trackedLocation, true));
        }
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        assert (Swing.isSwingThread());
        return (Boolean)this.cbGoTo.invokeWithTop(goingTo -> {
            if (!this.isEffectivelyDifferent((ProgramLocation)goingTo, location)) {
                this.getListingPanel().scrollTo(location);
                return false;
            }
            try (SuppressableCallback.Suppression supp = this.cbGoTo.suppress((Object)location);){
                if (!this.isEffectivelyDifferent(this.getLocation(), location)) {
                    this.getListingPanel().scrollTo(location);
                    Boolean bl = true;
                    return bl;
                }
                if (gotoProgram != this.getProgram()) {
                    this.doSetProgram(gotoProgram);
                }
                if (!gotoProgram.getMemory().contains(location.getAddress())) {
                    Boolean bl = false;
                    return bl;
                }
                if (super.goTo(gotoProgram, location)) {
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
        });
    }

    public void programLocationChanged(ProgramLocation location, EventTrigger trigger) {
        this.locationLabel.goToAddress(location.getAddress());
        if (this.traceManager != null) {
            location = ProgramLocationUtils.fixLocation(location, false);
        }
        super.programLocationChanged(location, trigger);
        if (trigger == EventTrigger.GUI_ACTION) {
            this.doSyncToStatic(location);
            this.doCheckCurrentModuleMissing();
        }
    }

    protected void doSyncToStatic(ProgramLocation location) {
        ProgramLocation staticLoc;
        if (this.isSyncToStaticListing() && location != null && (staticLoc = this.mappingService.getStaticLocationFromDynamic(location)) != null) {
            Swing.runIfSwingOrRunLater(() -> this.plugin.fireStaticLocationEvent(staticLoc));
        }
    }

    protected void doTryOpenProgram(final DomainFile df, int version, final int state) {
        final DebuggerOpenProgramActionContext ctx = new DebuggerOpenProgramActionContext(df);
        if (this.consoleService != null && this.consoleService.logContains(ctx)) {
            return;
        }
        if (df.canRecover()) {
            if (this.consoleService != null) {
                this.consoleService.log(DebuggerResources.ICON_MODULES, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> has recovery data. It must be opened manually.</html>", ctx);
            }
            return;
        }
        new TaskLauncher(new Task("Open " + df, true, false, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(TaskMonitor monitor) throws CancelledException {
                Program program = null;
                try {
                    program = (Program)df.getDomainObject((Object)this, false, false, monitor);
                    DebuggerListingProvider.this.programManager.openProgram(program, state);
                }
                catch (VersionException e) {
                    if (DebuggerListingProvider.this.consoleService != null) {
                        DebuggerListingProvider.this.consoleService.log(DebuggerResources.ICON_MODULES, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> was created with a different version of Ghidra. It must be opened manually.</html>", ctx);
                    }
                    return;
                }
                catch (Exception e) {
                    if (DebuggerListingProvider.this.consoleService != null) {
                        DebuggerListingProvider.this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> could not be opened: " + e + ". Try opening it manually.</html>", ctx);
                    }
                    return;
                }
                finally {
                    if (program != null) {
                        program.release((Object)this);
                    }
                }
            }
        }, (Component)this.tool.getToolFrame());
    }

    protected void doCheckCurrentModuleMissing() {
        DomainFile df;
        if (!this.isSyncToStaticListing()) {
            return;
        }
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        ProgramLocation loc = this.getLocation();
        if (loc == null) {
            return;
        }
        ProgramLocation mapped = this.mappingService.getStaticLocationFromDynamic(loc);
        if (mapped != null) {
            return;
        }
        long snap = this.current.getSnap();
        Address address = loc.getAddress();
        TraceStaticMapping mapping = trace.getStaticMappingManager().findContaining(address, snap);
        if (mapping != null && (df = ProgramURLUtils.getFileForHackedUpGhidraURL(this.tool.getProject(), mapping.getStaticProgramURL())) != null) {
            this.doTryOpenProgram(df, -1, 1);
        }
        HashSet<TraceModule> missing = new HashSet<TraceModule>();
        HashSet<DomainFile> toOpen = new HashSet<DomainFile>();
        TraceModuleManager modMan = trace.getModuleManager();
        Collection modules = Stream.concat(modMan.getModulesAt(snap, address).stream().filter(m -> m.getSections().isEmpty()), modMan.getSectionsAt(snap, address).stream().map(s -> s.getModule())).collect(Collectors.toSet());
        for (TraceModule mod : modules) {
            Set<DomainFile> matches = this.mappingService.findProbableModulePrograms(mod);
            if (matches.isEmpty()) {
                missing.add(mod);
                continue;
            }
            toOpen.addAll(matches);
        }
        if (this.programManager != null && !toOpen.isEmpty()) {
            for (DomainFile df2 : toOpen) {
                this.doTryOpenProgram(df2, -1, 2);
            }
        }
        if (this.importerService == null || this.consoleService == null) {
            return;
        }
        for (TraceModule mod : missing) {
            this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, "<html>The module <b><tt>" + HTMLUtilities.escapeHTML((String)mod.getName()) + "</tt></b> was not found in the project</html>", new DebuggerMissingModuleActionContext(mod));
        }
    }

    public void setTrackingSpec(LocationTrackingSpec spec) {
        this.trackingTrait.setSpec(spec);
    }

    public LocationTrackingSpec getTrackingSpec() {
        return this.trackingTrait.getSpec();
    }

    public void addTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        this.trackingSpecChangeListeners.add((Object)listener);
    }

    public void removeTrackingSpecChangeListener(DebuggerListingService.LocationTrackingSpecChangeListener listener) {
        this.trackingSpecChangeListeners.remove((Object)listener);
    }

    public void setSyncToStaticListing(boolean sync) {
        if (!this.isMainListing()) {
            throw new IllegalStateException("Only the main dynamic listing can be synced to the main static listing");
        }
        this.actionSyncToStaticListing.setSelected(sync);
        this.doSetSyncToStaticListing(sync);
    }

    protected void doSetSyncToStaticListing(boolean sync) {
        this.syncToStaticListing = sync;
        this.contextChanged();
        this.doSyncToStatic(this.getLocation());
    }

    public boolean isSyncToStaticListing() {
        return this.syncToStaticListing;
    }

    public void setFollowsCurrentThread(boolean follows) {
        if (this.isMainListing()) {
            throw new IllegalStateException("The main dynamic listing always follows the current trace and thread");
        }
        this.actionFollowsCurrentThread.setSelected(follows);
        this.doSetFollowsCurrentThread(follows);
    }

    protected void doSetFollowsCurrentThread(boolean follows) {
        this.followsCurrentThread = follows;
        this.updateBorder();
        this.updateTitle();
        this.coordinatesActivated(this.traceManager.getCurrent());
    }

    protected void updateBorder() {
        ListingPanelContainer decoration = (ListingPanelContainer)this.getComponent();
        decoration.setConnnected(this.followsCurrentThread);
    }

    public boolean isFollowsCurrentThread() {
        return this.followsCurrentThread;
    }

    public void setAutoReadMemorySpec(AutoReadMemorySpec spec) {
        this.readsMemTrait.setAutoSpec(spec);
    }

    public AutoReadMemorySpec getAutoReadMemorySpec() {
        return this.readsMemTrait.getAutoSpec();
    }

    protected ProgramLocation doMarkTrackedLocation() {
        ProgramLocation trackedLocation = this.trackingTrait.getTrackedLocation();
        if (trackedLocation == null) {
            this.markTrackedStaticLocation(null);
            return null;
        }
        ProgramLocation trackedStatic = this.mappingService == null ? null : this.mappingService.getStaticLocationFromDynamic(trackedLocation);
        this.markTrackedStaticLocation(trackedStatic);
        return trackedStatic;
    }

    protected void doGoToTracked() {
        ProgramLocation loc = this.trackingTrait.getTrackedLocation();
        ProgramLocation trackedStatic = this.doMarkTrackedLocation();
        if (loc == null) {
            return;
        }
        TraceProgramView curView = this.current.getView();
        if (!this.syncToStaticListing || trackedStatic == null) {
            Swing.runIfSwingOrRunLater(() -> {
                this.goTo((Program)curView, loc);
                this.doCheckCurrentModuleMissing();
            });
        } else {
            Swing.runIfSwingOrRunLater(() -> {
                this.goTo((Program)curView, loc);
                this.doCheckCurrentModuleMissing();
                this.plugin.fireStaticLocationEvent(trackedStatic);
            });
        }
    }

    public void dispose() {
        super.dispose();
        if (this.consoleService != null && this.actionOpenProgram != null) {
            this.consoleService.removeResolutionAction((DockingActionIf)this.actionOpenProgram);
        }
    }

    public void staticProgramLocationChanged(ProgramLocation location) {
        TraceProgramView view = this.current.getView();
        if (!this.isSyncToStaticListing() || view == null || location == null) {
            return;
        }
        ProgramLocation dyn = this.mappingService.getDynamicLocationFromStatic(view, location);
        if (dyn == null) {
            return;
        }
        this.goTo((Program)view, dyn);
    }

    protected DebuggerCoordinates adjustCoordinates(DebuggerCoordinates coordinates) {
        if (this.followsCurrentThread) {
            return coordinates;
        }
        return this.current.withTime(coordinates.getTime());
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        if (DebuggerListingProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.doSetProgram((Program)this.current.getView());
        this.goToTrait.goToCoordinates(coordinates);
        this.trackingTrait.goToCoordinates(coordinates);
        this.readsMemTrait.goToCoordinates(coordinates);
        this.locationLabel.goToCoordinates(coordinates);
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        DebuggerCoordinates adjusted = this.adjustCoordinates(coordinates);
        this.goToCoordinates(adjusted);
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.goToCoordinates(DebuggerCoordinates.NOWHERE);
        }
    }

    public void cloneWindow() {
        DebuggerListingProvider newProvider = (DebuggerListingProvider)this.plugin.createNewDisconnectedProvider();
        ViewerPosition vp = this.getListingPanel().getFieldPanel().getViewerPosition();
        SaveState saveState = new SaveState();
        this.writeConfigState(saveState);
        Swing.runLater(() -> {
            newProvider.readConfigState(saveState);
            newProvider.goToCoordinates(this.current);
            newProvider.getListingPanel().getFieldPanel().setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
        });
    }

    protected class ForListingReadsMemoryTrait
    extends DebuggerReadsMemoryTrait {
        public ForListingReadsMemoryTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
        }

        @Override
        protected AddressSetView getSelection() {
            return DebuggerListingProvider.this.getSelection();
        }

        @Override
        protected void repaintPanel() {
            DebuggerListingProvider.this.getListingPanel().getFieldPanel().repaint();
        }
    }

    protected class ForListingTrackingTrait
    extends DebuggerTrackLocationTrait {
        public ForListingTrackingTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
        }

        @Override
        protected void specChanged(LocationTrackingSpec spec) {
            ((DebuggerListingService.LocationTrackingSpecChangeListener)DebuggerListingProvider.this.trackingSpecChangeListeners.fire).locationTrackingSpecChanged(spec);
        }

        @Override
        protected void locationTracked() {
            DebuggerListingProvider.this.doGoToTracked();
        }
    }

    protected class ForListingGoToTrait
    extends DebuggerGoToTrait {
        public ForListingGoToTrait() {
            super(DebuggerListingProvider.this.tool, (Plugin)DebuggerListingProvider.this.plugin, (ComponentProvider)DebuggerListingProvider.this);
        }

        @Override
        protected boolean goToAddress(Address address) {
            return DebuggerListingProvider.this.getListingPanel().goTo(address);
        }
    }

    protected class ForStaticSyncMappingChangeListener
    implements DebuggerStaticMappingChangeListener {
        protected ForStaticSyncMappingChangeListener() {
        }

        @Override
        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Swing.runIfSwingOrRunLater(() -> {
                if (DebuggerListingProvider.this.current.getView() == null) {
                    return;
                }
                if (!affectedTraces.contains(DebuggerListingProvider.this.current.getTrace())) {
                    return;
                }
                DebuggerListingProvider.this.doMarkTrackedLocation();
                DebuggerListingProvider.this.doSyncToStatic(DebuggerListingProvider.this.getLocation());
            });
        }
    }

    protected class MarkerSetChangeListener
    implements ChangeListener {
        protected MarkerSetChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DebuggerListingProvider.this.getListingPanel().getFieldPanel().repaint();
        }
    }

    protected class FollowsCurrentThreadAction
    extends DebuggerResources.AbstractFollowsCurrentThreadAction {
        public FollowsCurrentThreadAction() {
            super((Plugin)DebuggerListingProvider.this.plugin);
            this.setMenuBarData(new MenuData(new String[]{"Follows Selected Thread"}));
            this.setSelected(true);
            DebuggerListingProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerListingProvider.this.doSetFollowsCurrentThread(this.isSelected());
        }
    }

    protected class SyncToStaticListingAction
    extends DebuggerResources.AbstractSyncToStaticListingAction {
        public SyncToStaticListingAction() {
            super((Plugin)DebuggerListingProvider.this.plugin);
            this.setMenuBarData(new MenuData(new String[]{this.getName()}));
            this.setSelected(true);
            DebuggerListingProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerListingProvider.this.doSetSyncToStaticListing(this.isSelected());
        }
    }
}

