/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerLayoutModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.colors.MultiSelectionBlendedLayoutBackgroundColorManager;
import ghidra.app.plugin.core.debug.gui.colors.SelectionGenerator;
import ghidra.app.plugin.core.debug.gui.colors.SelectionTranslator;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesPanel;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesProvider;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryState;
import java.awt.Color;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DebuggerMemoryByteViewerComponent
extends ByteViewerComponent
implements SelectionTranslator {
    private final DebuggerMemoryBytesPanel panel;
    @AutoOptionConsumed(name={"Colors.Error Memory"})
    private Color errorColor;
    @AutoOptionConsumed(name={"Colors.Stale Memory"})
    private Color unknownColor;
    private final AutoOptions.Wiring autoOptionsWiring;
    private final List<SelectionGenerator> selectionGenerators;

    public DebuggerMemoryByteViewerComponent(DebuggerMemoryBytesPanel vpanel, ByteViewerLayoutModel layoutModel, DataFormatModel model, int bytesPerLine, FontMetrics fm) {
        super((ByteViewerPanel)vpanel, layoutModel, model, bytesPerLine, fm);
        this.panel = vpanel;
        this.autoOptionsWiring = AutoOptions.wireOptionsConsumed((Plugin)vpanel.getProvider().getPlugin(), (Object)this);
        this.selectionGenerators = List.of(new SelectionHighlightSelectionGenerator(), new TraceMemoryStateSelectionGenerator(), vpanel.getProvider().trackingTrait.getSelectionGenerator());
    }

    protected Color colorForState(TraceMemoryState state) {
        switch (state) {
            case ERROR: {
                return this.errorColor;
            }
            case KNOWN: {
                return null;
            }
            case UNKNOWN: {
                return this.unknownColor;
            }
        }
        throw new AssertionError();
    }

    protected LayoutBackgroundColorManager getLayoutSelectionMap(BigInteger layoutIndex) {
        Color backgroundColor = this.backgroundColorModel.getBackgroundColor(layoutIndex);
        boolean isBackgroundDefault = this.backgroundColorModel.getDefaultBackgroundColor().equals(backgroundColor);
        ArrayList<MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection> selections = new ArrayList<MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection>(3);
        for (SelectionGenerator sg : this.selectionGenerators) {
            sg.addSelections(layoutIndex, this, selections);
        }
        return MultiSelectionBlendedLayoutBackgroundColorManager.getLayoutColorMap(layoutIndex, selections, backgroundColor, isBackgroundDefault);
    }

    @Override
    public AddressSetView convertFieldToAddress(FieldSelection fieldSelection) {
        ProgramByteBlockSet blockSet = this.getBlockSet();
        if (blockSet == null) {
            return new AddressSet();
        }
        return blockSet.getAddressSet(this.processFieldSelection(fieldSelection));
    }

    @Override
    public FieldSelection convertAddressToField(AddressSetView addresses) {
        ProgramByteBlockSet blockSet = this.getBlockSet();
        if (blockSet == null) {
            return new FieldSelection();
        }
        return this.getFieldSelection(blockSet.getBlockSelection(addresses));
    }

    @Override
    public FieldSelection convertAddressToField(AddressRange range) {
        ProgramByteBlockSet blockSet = this.getBlockSet();
        if (blockSet == null) {
            return new FieldSelection();
        }
        return this.getFieldSelection(blockSet.getBlockSelection(range));
    }

    protected class TraceMemoryStateSelectionGenerator
    implements SelectionGenerator {
        protected TraceMemoryStateSelectionGenerator() {
        }

        @Override
        public void addSelections(BigInteger layoutIndex, SelectionTranslator translator, List<MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection> selections) {
            FieldSelection lineFieldSel = new FieldSelection();
            lineFieldSel.addRange(layoutIndex, layoutIndex.add(BigInteger.ONE));
            DebuggerMemoryBytesProvider provider = DebuggerMemoryByteViewerComponent.this.panel.getProvider();
            DebuggerCoordinates coordinates = provider.current;
            if (coordinates.getView() == null) {
                return;
            }
            Trace trace = coordinates.getTrace();
            long snap = coordinates.getSnap();
            AddressSetView lineAddresses = translator.convertFieldToAddress(lineFieldSel);
            AddressSet unknown = new AddressSet(lineAddresses);
            for (AddressRange range : lineAddresses) {
                for (Map.Entry entry : trace.getMemoryManager().getStates(snap, range)) {
                    FieldSelection resultFieldSel;
                    Color color;
                    if (entry.getValue() != TraceMemoryState.UNKNOWN) {
                        unknown.delete(((TraceAddressSnapRange)entry.getKey()).getRange());
                    }
                    if ((color = DebuggerMemoryByteViewerComponent.this.colorForState((TraceMemoryState)entry.getValue())) == null || (resultFieldSel = translator.convertAddressToField(((TraceAddressSnapRange)entry.getKey()).getRange())).isEmpty()) continue;
                    selections.add(new MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection(resultFieldSel, color));
                }
            }
            if (DebuggerMemoryByteViewerComponent.this.unknownColor == null) {
                return;
            }
            for (AddressRange unk : unknown) {
                FieldSelection resultFieldSel = translator.convertAddressToField(unk);
                if (resultFieldSel.isEmpty()) continue;
                selections.add(new MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection(resultFieldSel, DebuggerMemoryByteViewerComponent.this.unknownColor));
            }
        }
    }

    protected class SelectionHighlightSelectionGenerator
    implements SelectionGenerator {
        protected SelectionHighlightSelectionGenerator() {
        }

        @Override
        public void addSelections(BigInteger layoutIndex, SelectionTranslator translator, List<MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection> selections) {
            FieldSelection highlight;
            Color selectionColor = DebuggerMemoryByteViewerComponent.this.paintContext.getSelectionColor();
            Color highlightColor = DebuggerMemoryByteViewerComponent.this.paintContext.getHighlightColor();
            FieldSelection selection = DebuggerMemoryByteViewerComponent.this.getSelection();
            if (!selection.isEmpty()) {
                selections.add(new MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection(selection, selectionColor));
            }
            if (!(highlight = DebuggerMemoryByteViewerComponent.this.getHighlight()).isEmpty()) {
                selections.add(new MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection(highlight, highlightColor));
            }
        }
    }
}

