/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.tree.GTree;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsPlugin;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainerListener;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsGraphAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsTableAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsTreeAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayAsXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredGraphAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredTableAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredTreeAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayMethodsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ExportAsFactsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ExportAsXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportFromFactsAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportFromXMLAction;
import ghidra.app.plugin.core.debug.gui.objects.actions.OpenWinDbgTraceAction;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerAttachDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerBreakpointDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementColumn;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectNode;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectPane;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTable;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTree;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetDetachable;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetTogglable;
import ghidra.dbg.util.DebuggerCallbackReorderer;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.PrivatelyQueuedListener;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;

public class DebuggerObjectsProvider
extends ComponentProviderAdapter
implements ObjectContainerListener {
    public static final String PATH_JOIN_CHAR = ".";
    private static final AutoConfigState.ClassHandler<DebuggerObjectsProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerObjectsProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final DebuggerObjectsPlugin plugin;
    @AutoServiceConsumed
    public DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private GraphDisplayBroker graphBroker;
    @AutoServiceConsumed
    private ConsoleService consoleService;
    private final AutoService.Wiring autoServiceWiring;
    public static final String OPTION_NAME_DEFAULT_FOREGROUND_COLOR = "Object Colors.Default";
    public static final String OPTION_NAME_MODIFIED_FOREGROUND_COLOR = "Object Colors.Modifed";
    public static final String OPTION_NAME_SUBSCRIBED_FOREGROUND_COLOR = "Object Colors.Subscribed";
    public static final String OPTION_NAME_INVISIBLE_FOREGROUND_COLOR = "Object Colors.Invisible (when toggled on)";
    public static final String OPTION_NAME_INVALIDATED_FOREGROUND_COLOR = "Object Colors.Invalidated";
    public static final String OPTION_NAME_ERROR_FOREGROUND_COLOR = "Object Colors.Errors";
    public static final String OPTION_NAME_INTRINSIC_FOREGROUND_COLOR = "Object Colors.Intrinsics";
    public static final String OPTION_NAME_TARGET_FOREGROUND_COLOR = "Object Colors.Targets";
    public static final String OPTION_NAME_ACCESSOR_FOREGROUND_COLOR = "Object Colors.Accessors";
    public static final String OPTION_NAME_LINK_FOREGROUND_COLOR = "Object Colors.Links";
    public static final String OPTION_NAME_DEFAULT_BACKGROUND_COLOR = "Object Colors.Background";
    @AutoOptionDefined(name={"Object Colors.Default"}, description="The default foreground color of items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color defaultForegroundColor = Color.BLACK;
    @AutoOptionDefined(name={"Object Colors.Background"}, description="The default background color of items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color defaultBackgroundColor = Color.WHITE;
    @AutoOptionDefined(name={"Object Colors.Invisible (when toggled on)"}, description="The foreground color for items normally not visible (toggleable)", help=@HelpInfo(anchor="colors"))
    Color invisibleForegroundColor = Color.LIGHT_GRAY;
    @AutoOptionDefined(name={"Object Colors.Invalidated"}, description="The foreground color for items no longer valid", help=@HelpInfo(anchor="colors"))
    Color invalidatedForegroundColor = Color.LIGHT_GRAY;
    @AutoOptionDefined(name={"Object Colors.Modifed"}, description="The foreground color for modified items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color modifiedForegroundColor = Color.RED;
    @AutoOptionDefined(name={"Object Colors.Subscribed"}, description="The foreground color for subscribed items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color subscribedForegroundColor = Color.BLACK;
    @AutoOptionDefined(name={"Object Colors.Errors"}, description="The foreground color for items in error", help=@HelpInfo(anchor="colors"))
    Color errorForegroundColor = Color.RED;
    @AutoOptionDefined(name={"Object Colors.Intrinsics"}, description="The foreground color for intrinsic items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color intrinsicForegroundColor = Color.BLUE;
    @AutoOptionDefined(name={"Object Colors.Targets"}, description="The foreground color for target object items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color targetForegroundColor = Color.MAGENTA;
    @AutoOptionDefined(name={"Object Colors.Accessors"}, description="The foreground color for property accessor items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color accessorForegroundColor = Color.LIGHT_GRAY;
    @AutoOptionDefined(name={"Object Colors.Links"}, description="The foreground color for links to items in the objects tree", help=@HelpInfo(anchor="colors"))
    Color linkForegroundColor = Color.GREEN.darker();
    @AutoOptionDefined(name={"Default Extended Step"}, description="The default string for the extended step command")
    String extendedStep = "";
    private static final Icon ENABLED_ICON = ResourceManager.loadImage((String)"images/enabled.png");
    private static final Icon DISABLED_ICON = ResourceManager.loadImage((String)"images/disabled.png");
    private final AutoOptions.Wiring autoOptionsWiring;
    private JPanel mainPanel;
    private ObjectPane pane;
    protected ObjectContainer root;
    private Map<String, ObjectContainer> targetMap;
    private Set<TargetObject> refSet;
    public Program currentProgram;
    protected Map<Long, Trace> traces = new HashMap<Long, Trace>();
    protected Trace currentTrace;
    protected DebuggerObjectModel currentModel;
    protected Runnable repeatLastSet = () -> {};
    private boolean asTree = true;
    private MyObjectListener listener = new MyObjectListener();
    public DebuggerMethodInvocationDialog configDialog;
    public DebuggerMethodInvocationDialog launchDialog;
    public DebuggerAttachDialog attachDialog;
    public DebuggerBreakpointDialog breakpointDialog;
    DockingAction actionLaunch;
    DockingAction actionAddBreakpoint;
    DisplayAsTreeAction displayAsTreeAction;
    DisplayAsTableAction displayAsTableAction;
    DisplayAsGraphAction displayAsGraphAction;
    DisplayAsXMLAction displayAsXMLAction;
    DisplayFilteredTreeAction displayFilteredTreeAction;
    DisplayFilteredTableAction displayFilteredTableAction;
    DisplayFilteredGraphAction displayFilteredGraphAction;
    DisplayFilteredXMLAction displayFilteredXMLAction;
    DisplayMethodsAction displayMethodsAction;
    ExportAsXMLAction exportAsXMLAction;
    ExportAsFactsAction exportAsFactsAction;
    ImportFromXMLAction importFromXMLAction;
    ImportFromFactsAction importFromFactsAction;
    OpenWinDbgTraceAction openTraceAction;
    private ToggleDockingAction actionToggleBase;
    private ToggleDockingAction actionToggleSubscribe;
    private ToggleDockingAction actionToggleAutoRecord;
    private ToggleDockingAction actionToggleHideIntrinsics;
    private ToggleDockingAction actionToggleSelectionOnly;
    private ToggleDockingAction actionToggleIgnoreState;
    @AutoConfigStateField
    private boolean autoRecord = true;
    @AutoConfigStateField
    private boolean hideIntrinsics = true;
    @AutoConfigStateField
    private boolean selectionOnly = false;
    @AutoConfigStateField
    private boolean ignoreState = false;
    Set<TargetConfigurable> configurables = new HashSet<TargetConfigurable>();

    public DebuggerObjectsProvider(DebuggerObjectsPlugin plugin, DebuggerObjectModel model, ObjectContainer container, boolean asTree) throws Exception {
        super(plugin.getTool(), container.getPrefixedName(), plugin.getName());
        this.plugin = plugin;
        this.currentProgram = plugin.getActiveProgram();
        plugin.addProvider(this);
        this.currentModel = model;
        this.root = container;
        this.asTree = asTree;
        this.setIcon(asTree ? ObjectTree.ICON_TREE : ObjectTable.ICON_TABLE);
        this.targetMap = new LinkedMap();
        this.refSet = new HashSet<TargetObject>();
        this.getRoot().propagateProvider(this);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_OBJECTS);
        this.setDefaultWindowPosition(WindowPosition.STACK);
        this.setWindowGroup("Debugger.Core.Objects");
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setVisible(true);
        this.createActions();
        this.repeatLastSet.run();
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public ObjectActionContext getActionContext(MouseEvent event) {
        return new ObjectActionContext(this);
    }

    public TargetObject getObjectFromContext(ActionContext context) {
        return this.pane == null ? null : this.pane.getSelectedObject();
    }

    public DebuggerObjectModel getModel() {
        return this.currentModel;
    }

    public void setModel(DebuggerObjectModel model) {
        this.currentModel = model;
        this.currentModel.addModelListener(this.getListener(), true);
        this.refresh();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private void buildMainPanel() throws Exception {
        this.mainPanel = new JPanel(new BorderLayout());
        if (this.asTree) {
            this.addTree(this.getRoot());
        } else {
            this.addTable(this.getRoot());
        }
        this.launchDialog = new DebuggerMethodInvocationDialog(this.tool, "Launch", "Launch", DebuggerResources.ICON_LAUNCH);
        this.attachDialog = new DebuggerAttachDialog(this);
        this.breakpointDialog = new DebuggerBreakpointDialog(this);
        this.configDialog = new DebuggerMethodInvocationDialog(this.tool, "Configuration", "Configure", DebuggerResources.ICON_CONFIG);
    }

    private void addToPanel(ObjectPane p) throws Exception {
        if (p == null) {
            throw new Exception("NULL PANE generated!");
        }
        this.pane = p;
        this.mainPanel.add(this.pane.getComponent());
    }

    JComponent getContextObject() {
        return this.pane == null ? null : this.pane.getPrincipalComponent();
    }

    @AutoOptionConsumed(name={"Object Colors.Background"})
    private void setDefaultBackgroundColor(Color color) {
        this.defaultBackgroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Default"})
    private void setDefaultForegroundColor(Color color) {
        this.defaultForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Accessors"})
    private void setAccessorForegroundColor(Color color) {
        this.accessorForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Errors"})
    private void setErrorForegroundColor(Color color) {
        this.errorForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Intrinsics"})
    private void setIntrinsicForegroundColor(Color color) {
        this.intrinsicForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Invisible (when toggled on)"})
    private void setInvisibleForegroundColor(Color color) {
        this.invisibleForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Invalidated"})
    private void setInvalidatedForegroundColor(Color color) {
        this.invalidatedForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Links"})
    private void setLinkForegroundColor(Color color) {
        this.linkForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Modifed"})
    private void setModifiedForegroundColor(Color color) {
        this.modifiedForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Subscribed"})
    private void setSubscribedForegroundColor(Color color) {
        this.subscribedForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    @AutoOptionConsumed(name={"Object Colors.Targets"})
    private void setTargetForegroundColor(Color color) {
        this.targetForegroundColor = color;
        if (this.pane != null) {
            this.pane.getComponent().repaint();
        }
    }

    public void setProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        this.currentProgram = program;
        this.plugin.setActiveProgram(this.currentProgram);
        this.contextChanged();
    }

    private boolean hasModelAndProgram() {
        return this.currentModel != null && this.currentProgram != null;
    }

    public void traceOpened(Trace trace) {
        this.repeatLastSet.run();
    }

    public void refresh() {
        if (this.pane != null && this.currentModel != null) {
            ((CompletableFuture)this.currentModel.fetchModelRoot().thenAccept(this::refresh)).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Error refreshing model root", (Throwable)ex);
                return null;
            });
        }
    }

    public void refresh(TargetObject targetObject) {
        if (this.pane != null) {
            Swing.runIfSwingOrRunLater(() -> {
                this.pane.setRoot(this.getRoot(), targetObject);
                this.getRoot().propagateProvider(this.getRoot().getProvider());
                this.pane.signalUpdate(this.getRoot());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String key) {
        if (this.pane != null) {
            if (key != null) {
                ArrayList<ObjectContainer> containers = new ArrayList<ObjectContainer>();
                for (String path : this.targetMap.keySet()) {
                    if (!path.endsWith(key)) continue;
                    Map<String, ObjectContainer> map = this.targetMap;
                    synchronized (map) {
                        ObjectContainer container = this.targetMap.get(path);
                        containers.add(container);
                    }
                }
                for (ObjectContainer container : containers) {
                    this.pane.signalUpdate(container);
                }
            } else {
                this.pane.signalUpdate(this.pane.getContainer());
            }
        }
    }

    public void modelActivated(DebuggerObjectModel model) {
        if (model != null && model.equals(this.currentModel)) {
            this.requestFocus();
            this.toFront();
            this.setSubTitle(this.currentModel.getBrief());
        }
    }

    public void traceActivated(DebuggerCoordinates coordinates) {
        if (this.currentTrace == coordinates.getTrace()) {
            return;
        }
        this.setTrace(coordinates.getTrace(), coordinates.getThread(), true);
    }

    public void setTrace(Trace trace, TraceThread thread, boolean select) {
        TargetObject target = this.modelService.getTarget(trace);
        if (!this.refSet.contains(target)) {
            return;
        }
        this.repeatLastSet = () -> this.setTrace(trace, thread, select);
        if (trace != null) {
            this.currentTrace = trace;
        }
        this.contextChanged();
    }

    public void traceClosed(Trace trace) {
        if (trace == this.currentTrace) {
            this.setTrace(null, null, true);
        }
    }

    public GraphDisplayBroker getGraphBroker() {
        return this.graphBroker;
    }

    public ConsoleService getConsoleService() {
        return this.consoleService;
    }

    public ObjectContainer getSelectedContainer(Object obj) {
        if (obj instanceof GTree) {
            Object last;
            GTree tree = (GTree)obj;
            TreePath path = tree.getSelectionPath();
            if (path != null && (last = path.getLastPathComponent()) instanceof ObjectNode) {
                return ((ObjectNode)((Object)last)).getContainer();
            }
            return this.pane.getContainer();
        }
        if (obj instanceof GhidraTable) {
            GhidraTable table = (GhidraTable)obj;
            ObjectContainer container = this.pane.getContainer();
            if (this.pane.getPrincipalComponent().equals(table)) {
                TargetObject object = this.pane.getSelectedObject();
                if (object instanceof DummyTargetObject) {
                    return container;
                }
                ObjectContainer subContainer = container.getSubContainer(object);
                if (subContainer != null) {
                    return subContainer;
                }
            }
            return container;
        }
        return null;
    }

    public TargetObject getSelectedObject() {
        TargetObject selectedObject = this.pane.getSelectedObject();
        if (selectedObject != null) {
            return selectedObject;
        }
        return null;
    }

    public void addTree(ObjectContainer container) {
        ObjectTree objTree = new ObjectTree(container);
        try {
            this.addToPanel(objTree);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GTree tree = (GTree)objTree.getPrincipalComponent();
        tree.setRootVisible(true);
    }

    public void addTable(ObjectContainer container) {
        AtomicReference update = new AtomicReference();
        AsyncUtils.sequence((TypeSpec)TypeSpec.cls(ObjectContainer.class)).then(seq -> container.getOffspring().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), update).then(seq -> {
            try {
                ObjectContainer oc = (ObjectContainer)update.get();
                if (oc.hasElements()) {
                    this.addToPanel(this.buildTableFromElements(oc));
                } else {
                    this.addToPanel(this.buildTableFromAttributes(oc));
                }
                seq.exit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).finish().completeExceptionally(new RuntimeException("Unable to add table"));
    }

    private ObjectTable<ObjectAttributeRow> buildTableFromAttributes(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        String name = targetObject.getName();
        DefaultEnumeratedColumnTableModel model = new DefaultEnumeratedColumnTableModel(name, ObjectAttributeColumn.class);
        Map<String, Object> map = container.getAttributeMap();
        ArrayList<ObjectAttributeRow> list = new ArrayList<ObjectAttributeRow>();
        for (Object val : map.values()) {
            if (!(val instanceof TargetObject)) continue;
            TargetObject ref = (TargetObject)val;
            list.add(new ObjectAttributeRow(ref, container.getProvider()));
        }
        model.addAll(list);
        return new ObjectTable<ObjectAttributeRow>(container, ObjectAttributeRow.class, (AbstractSortedTableModel<ObjectAttributeRow>)model);
    }

    private ObjectTable<ObjectElementRow> buildTableFromElements(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        String name = targetObject.getName();
        Map<String, TargetObject> map = container.getElementMap();
        ArrayList<ObjectElementRow> list = new ArrayList<ObjectElementRow>();
        for (TargetObject obj : map.values()) {
            if (!(obj instanceof TargetObject)) continue;
            TargetObject ref = obj;
            list.add(new ObjectElementRow(ref, container.getProvider()));
        }
        ObjectEnumeratedColumnTableModel.ObjectsEnumeratedTableColumn[] cols = new ObjectElementColumn[]{new ObjectElementColumn("Accessor", ObjectElementRow::getValue)};
        ObjectEnumeratedColumnTableModel model = new ObjectEnumeratedColumnTableModel(name, cols);
        model.addAll(list);
        ObjectTable<ObjectElementRow> table = new ObjectTable<ObjectElementRow>(container, ObjectElementRow.class, model);
        for (TargetObject obj : map.values()) {
            if (!(obj instanceof TargetObject)) continue;
            TargetObject ref = obj;
            ((CompletableFuture)ref.fetchAttributes(true).thenAccept(attrs -> table.setColumns())).exceptionally(ex -> {
                Msg.error((Object)this, (Object)"Failed to fetch attributes", (Throwable)ex);
                return null;
            });
        }
        return table;
    }

    public DebuggerObjectsPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetToMap(ObjectContainer container) {
        TargetObject targetObject;
        DebuggerObjectsProvider provider = container.getProvider();
        if (!this.equals(provider)) {
            Msg.error((Object)this, (Object)"TargetMap corrupted");
        }
        if ((targetObject = container.getTargetObject()) != null && !container.isLink()) {
            String key = targetObject.getJoinedPath(PATH_JOIN_CHAR);
            container.subscribe();
            Map<String, ObjectContainer> map = this.targetMap;
            synchronized (map) {
                this.targetMap.put(key, container);
                this.refSet.add(targetObject);
            }
            if (targetObject instanceof TargetInterpreter) {
                TargetInterpreter interpreter = (TargetInterpreter)targetObject;
                this.getPlugin().showConsole(interpreter);
                DebugModelConventions.findSuitable(TargetFocusScope.class, (TargetObject)targetObject).thenAccept(f -> this.setFocus((TargetObject)f, targetObject));
            }
            if (targetObject instanceof TargetConfigurable) {
                this.configurables.add((TargetConfigurable)targetObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromMap(ObjectContainer container) {
        TargetObject targetObject = container.getTargetObject();
        if (targetObject != null) {
            Map<String, ObjectContainer> map = this.targetMap;
            synchronized (map) {
                this.targetMap.remove(targetObject.getJoinedPath(PATH_JOIN_CHAR));
                this.refSet.remove(targetObject);
                if (targetObject instanceof TargetConfigurable) {
                    this.configurables.remove(targetObject);
                }
            }
        }
    }

    public ObjectContainer getContainerByPath(List<String> path) {
        return this.targetMap.get(PathUtils.toString(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ObjectContainer> getContainersFromObjects(Map<String, ?> objectMap, TargetObject parent, boolean usingAttributes) {
        ArrayList<ObjectContainer> result = new ArrayList<ObjectContainer>();
        if (parent == null || parent instanceof DummyTargetObject) {
            return result;
        }
        Map<String, ?> map = objectMap;
        synchronized (map) {
            for (String key : objectMap.keySet()) {
                Object object = objectMap.get(key);
                if (object == null) {
                    System.err.println("null object for " + key);
                    continue;
                }
                ObjectContainer container = null;
                try {
                    container = DebuggerObjectsProvider.buildContainerFromObject(parent, key, object, usingAttributes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (container == null) continue;
                result.add(container);
            }
        }
        return result;
    }

    static ObjectContainer buildContainerFromObject(TargetObject parent, String key, Object val, boolean usingAttributes) {
        Object xkey;
        Object object = xkey = usingAttributes ? key : "[" + key + "]";
        if (val instanceof TargetObject) {
            TargetObject to = (TargetObject)val;
            List path = to.getPath();
            boolean isLink = PathUtils.isLink((List)parent.getPath(), (String)xkey, (List)path);
            boolean isMethod = false;
            isMethod = to instanceof TargetMethod;
            if (!(val instanceof DummyTargetObject) && !isMethod) {
                return new ObjectContainer(to, (String)(isLink ? xkey : null));
            }
        } else {
            List xpath = PathUtils.extend((List)parent.getPath(), (String)key);
            DummyTargetObject to = new DummyTargetObject(parent, (List<String>)xpath, "", val, "");
            return new ObjectContainer(to, null);
        }
        return null;
    }

    public void closeComponent() {
        TargetObject targetObject = this.getRoot().getTargetObject();
        if (targetObject != null) {
            targetObject.removeListener(this.getListener());
        }
        super.closeComponent();
    }

    public void signalDataChanged(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalDataChanged(container);
        }
    }

    public void signalContentsChanged(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalContentsChanged(container);
        }
    }

    @Override
    public void update(ObjectContainer container) {
        if (this.pane != null) {
            this.pane.signalUpdate(container);
        }
    }

    public ObjectContainer getRoot() {
        return this.root;
    }

    public ObjectContainer getParent(ObjectContainer container) {
        List path = container.getTargetObject().getPath();
        ArrayList<String> ppath = new ArrayList<String>();
        for (String link : path) {
            ppath.add(link);
        }
        if (path.size() == 0) {
            return null;
        }
        ppath.remove(path.size() - 1);
        String joinedPath = StringUtils.join(ppath, (String)PATH_JOIN_CHAR);
        return this.targetMap.get(joinedPath);
    }

    public void fireObjectUpdated(ObjectContainer object) {
        this.plugin.fireObjectUpdated(object);
    }

    public boolean isInstance(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        if (this.isLocalOnly()) {
            return clazz.isInstance(object);
        }
        TargetObject result = null;
        try {
            result = (TargetObject)DebugModelConventions.findSuitable(clazz, (TargetObject)object).get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null;
    }

    public TargetObject getAncestor(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject object;
        for (TargetObject ref = object = this.getObjectFromContext(context); ref != null; ref = ref.getParent()) {
            if (!clazz.isInstance(ref)) continue;
            return ref;
        }
        return null;
    }

    public boolean descendsFrom(ActionContext context, Class<? extends TargetObject> clazz) {
        TargetObject ref = this.getAncestor(context, clazz);
        return ref != null;
    }

    private void createActions() {
        int groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh Node", this.plugin.getName()).keyBinding("SHIFT R")).toolBarGroup("Dbg8. Maintenance", "M" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractRefreshAction.ICON)).helpLocation(new HelpLocation(this.plugin.getName(), "refresh"))).onAction(ctx -> this.performRefresh((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleBase = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Base", this.plugin.getName()).keyBinding("B")).menuPath(new String[]{"&Toggle base"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_base"))).onAction(ctx -> this.performToggleBase((ActionContext)ctx))).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleSubscribe = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Subscription", this.plugin.getName()).keyBinding("U")).menuPath(new String[]{"&Toggle subscription"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_subscription"))).onAction(ctx -> this.performToggleSubscription((ActionContext)ctx))).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleAutoRecord = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("&Record Automatically", this.plugin.getName()).menuPath(new String[]{"&Record Automatically"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "record_automatically"))).onAction(ctx -> this.performToggleAutoRecord((ActionContext)ctx))).selected(this.autoRecord).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleHideIntrinsics = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Hide Intrinsic Atributes", this.plugin.getName()).menuPath(new String[]{"Maintenance", "&Hide Intrinsic Attributes"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "hide_intrinsic_attributes"))).onAction(ctx -> this.performToggleHideIntrinsics((ActionContext)ctx))).selected(this.hideIntrinsics).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleSelectionOnly = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Enable By Selection Only", this.plugin.getName()).menuPath(new String[]{"Maintenance", "Enable By &Selection Only"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "act_on_selection_only"))).onAction(ctx -> this.performToggleSelectionOnly((ActionContext)ctx))).selected(this.selectionOnly).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        this.actionToggleIgnoreState = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle ignore state on/off", this.plugin.getName()).menuPath(new String[]{"Maintenance", "&Ignore State"})).menuGroup("Dbg5. Target", "M" + ++groupTargetIndex)).helpLocation(new HelpLocation(this.plugin.getName(), "toggle_ignore_state"))).onAction(ctx -> this.performToggleIgnoreState((ActionContext)ctx))).selected(this.selectionOnly).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Quick Launch", this.plugin.getName()).keyBinding("Q")).toolBarGroup("Dbg5. Target", "" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractQuickLaunchAction.ICON)).helpLocation(DebuggerResources.AbstractQuickLaunchAction.help(this.plugin))).enabledWhen(ctx -> this.hasModelAndProgram())).onAction(ctx -> this.performQuickLaunch((ActionContext)ctx))).enabled(this.currentModel != null)).buildAndInstallLocal((ComponentProvider)this);
        this.actionLaunch = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Launch", this.plugin.getName()).keyBinding("X")).toolBarGroup("Dbg5. Target", "T" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractLaunchAction.ICON)).popupMenuPath(new String[]{"&Exec"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractLaunchAction.ICON)).helpLocation(DebuggerResources.AbstractLaunchAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetLauncher.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetLauncher.class))).onAction(ctx -> this.performLaunch((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Attach", this.plugin.getName()).keyBinding("A")).toolBarGroup("Dbg5. Target", "T" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractAttachAction.ICON)).popupMenuPath(new String[]{"&Attach"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractAttachAction.ICON)).helpLocation(DebuggerResources.AbstractAttachAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetAttachable.class))).onAction(ctx -> this.performAttach((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Re-attach", this.plugin.getName()).keyBinding("ALT A")).menuPath(new String[]{"&Reattach"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractDetachAction.ICON)).helpLocation(DebuggerResources.AbstractAttachAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetAttachable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performReattach((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Detach", this.plugin.getName()).keyBinding("D")).menuPath(new String[]{"&Detach"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractDetachAction.ICON)).popupMenuPath(new String[]{"&Detach"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractDetachAction.ICON)).helpLocation(DebuggerResources.AbstractDetachAction.help(this.plugin))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetDetachable.class) && this.isStopped((ActionContext)ctx))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetDetachable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performDetach((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Kill", this.plugin.getName()).keyBinding("K")).menuPath(new String[]{"&Kill"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractKillAction.ICON)).popupMenuPath(new String[]{"&Kill"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractKillAction.ICON)).helpLocation(DebuggerResources.AbstractKillAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetKillable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetKillable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performKill((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Start Recording", this.plugin.getName()).keyBinding("R")).menuPath(new String[]{"&Record"})).menuGroup("Dbg5. Target", "T" + ++groupTargetIndex)).menuIcon(DebuggerResources.AbstractRecordAction.ICON)).popupMenuPath(new String[]{"&Record"})).popupMenuGroup("Dbg5. Target", "T" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractRecordAction.ICON)).helpLocation(new HelpLocation(this.plugin.getName(), "record"))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetProcess.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetProcess.class))).onAction(ctx -> this.performStartRecording((ActionContext)ctx))).enabled(true)).buildAndInstallLocal((ComponentProvider)this);
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Resume", this.plugin.getName()).keyBinding("F5")).toolBarGroup("Dbg4. Control", "C" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractResumeAction.ICON)).popupMenuPath(new String[]{"&Resume"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractResumeAction.ICON)).helpLocation(DebuggerResources.AbstractResumeAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetResumable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetResumable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performResume((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Interrupt", this.plugin.getName()).keyBinding("pause")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractInterruptAction.ICON)).popupMenuPath(new String[]{"&Interrupt"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractInterruptAction.ICON)).helpLocation(DebuggerResources.AbstractInterruptAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterruptible.class) && (!this.isStopped((ActionContext)ctx) || this.ignoreState))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterruptible.class) && (!this.isStopped((ActionContext)ctx) || this.ignoreState))).onAction(ctx -> this.performInterrupt((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Into", this.plugin.getName()).keyBinding("F8")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepIntoAction.ICON)).popupMenuPath(new String[]{"&Step Into"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepIntoAction.ICON)).helpLocation(DebuggerResources.AbstractStepIntoAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepInto((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Over", this.plugin.getName()).keyBinding("F10")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepOverAction.ICON)).popupMenuPath(new String[]{"&Step Over"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepOverAction.ICON)).helpLocation(DebuggerResources.AbstractStepOverAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepOver((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Finish", this.plugin.getName()).keyBinding("F12")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepFinishAction.ICON)).popupMenuPath(new String[]{"&Finish"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepFinishAction.ICON)).helpLocation(DebuggerResources.AbstractStepFinishAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepFinish((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Step Last", this.plugin.getName()).keyBinding("ALT F8")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractStepLastAction.ICON)).popupMenuPath(new String[]{"&Step Last"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractStepLastAction.ICON)).helpLocation(DebuggerResources.AbstractStepLastAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetSteppable.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performStepLast((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        this.actionAddBreakpoint = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Add Breakpoint", this.plugin.getName()).keyBinding("F3")).toolBarGroup("Dbg4. Control", "C" + ++groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractSetBreakpointAction.ICON)).popupMenuPath(new String[]{"&Add Breakpoint"})).popupMenuGroup("Dbg4. Control", "C" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractSetBreakpointAction.ICON)).helpLocation(DebuggerResources.AbstractSetBreakpointAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetBreakpointSpecContainer.class) && this.isStopped((ActionContext)ctx))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetBreakpointSpecContainer.class) && this.isStopped((ActionContext)ctx))).onAction(ctx -> this.performSetBreakpoint((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        groupTargetIndex = 0;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Console", this.plugin.getName()).toolBarGroup("Dbg2. Connection", "X" + groupTargetIndex)).toolBarIcon(DebuggerResources.AbstractConsoleAction.ICON)).popupMenuPath(new String[]{"&Show Console"})).popupMenuGroup("Dbg2. Connection", "X" + groupTargetIndex)).popupMenuIcon(DebuggerResources.AbstractConsoleAction.ICON)).helpLocation(DebuggerResources.AbstractConsoleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterpreter.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetInterpreter.class))).onAction(ctx -> this.initiateConsole((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Toggle", this.plugin.getName()).keyBinding("T")).toolBarGroup("Dbg4. Control", "X" + ++groupTargetIndex)).popupMenuPath(new String[]{"&Toggle"})).popupMenuGroup("Dbg4. Control", "X" + groupTargetIndex)).helpLocation(DebuggerResources.AbstractToggleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetTogglable.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetTogglable.class))).onAction(ctx -> this.performToggle((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Configure", this.plugin.getName()).keyBinding("C")).toolBarGroup("Dbg4. Control", "X" + ++groupTargetIndex)).popupMenuPath(new String[]{"&Configure"})).popupMenuGroup("Dbg4. Control", "X" + groupTargetIndex)).helpLocation(DebuggerResources.AbstractToggleAction.help(this.plugin))).enabledWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetConfigurable.class))).popupWhen(ctx -> this.isInstance((ActionContext)ctx, (Class<? extends TargetObject>)TargetConfigurable.class))).onAction(ctx -> this.performConfigure((ActionContext)ctx))).enabled(false)).buildAndInstallLocal((ComponentProvider)this);
        ++groupTargetIndex;
        this.displayAsTreeAction = new DisplayAsTreeAction(this.tool, this.plugin.getName(), this);
        this.displayAsTableAction = new DisplayAsTableAction(this.tool, this.plugin.getName(), this);
        this.displayAsGraphAction = new DisplayAsGraphAction(this.tool, this.plugin.getName(), this);
        this.displayAsXMLAction = new DisplayAsXMLAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredTreeAction = new DisplayFilteredTreeAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredTableAction = new DisplayFilteredTableAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredGraphAction = new DisplayFilteredGraphAction(this.tool, this.plugin.getName(), this);
        this.displayFilteredXMLAction = new DisplayFilteredXMLAction(this.tool, this.plugin.getName(), this);
        this.displayMethodsAction = new DisplayMethodsAction(this.tool, this.plugin.getName(), this);
        this.exportAsXMLAction = new ExportAsXMLAction(this.tool, this.plugin.getName(), this);
        this.exportAsFactsAction = new ExportAsFactsAction(this.tool, this.plugin.getName(), this);
        this.importFromXMLAction = new ImportFromXMLAction(this.tool, this.plugin.getName(), this);
        this.importFromFactsAction = new ImportFromFactsAction(this.tool, this.plugin.getName(), this);
        this.openTraceAction = new OpenWinDbgTraceAction(this.tool, this.plugin.getName(), this);
    }

    public void performRefresh(ActionContext context) {
        TargetObject current = this.getObjectFromContext(context);
        if (current != null) {
            this.refresh(current.getName());
        } else {
            this.refresh();
        }
    }

    public void performToggleAutoupdate(ActionContext context) {
        TargetObject object = this.getObjectFromContext(context);
    }

    public void performToggleBase(ActionContext context) {
        for (TargetConfigurable configurable : this.configurables) {
            Object value = configurable.getCachedAttribute("_base");
            if (value == null) continue;
            Integer base = (Integer)value;
            base = base == 10 ? 16 : 10;
            configurable.writeConfigurationOption("_base", (Object)base);
        }
    }

    public void performToggleSubscription(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.getSelectedContainer(contextObject);
        if (container.isSubscribed()) {
            container.unsubscribe();
        } else {
            container.subscribe();
        }
    }

    public void performToggleAutoRecord(ActionContext context) {
        this.autoRecord = this.actionToggleAutoRecord.isSelected();
    }

    public void performToggleHideIntrinsics(ActionContext context) {
        this.hideIntrinsics = this.actionToggleHideIntrinsics.isSelected();
        this.refresh("");
    }

    public void performToggleSelectionOnly(ActionContext context) {
        this.selectionOnly = this.actionToggleSelectionOnly.isSelected();
        this.refresh("");
    }

    public void performToggleIgnoreState(ActionContext context) {
        this.ignoreState = this.actionToggleIgnoreState.isSelected();
        this.refresh("");
    }

    protected <T extends TargetObject> void performAction(ActionContext context, boolean fallbackRoot, Class<T> cls, Function<T, CompletableFuture<Void>> func, String errorMsg) {
        TargetObject obj = this.getObjectFromContext(context);
        if (obj == null && fallbackRoot) {
            obj = this.root.getTargetObject();
        }
        if (!this.isLocalOnly()) {
            ((CompletableFuture)DebugModelConventions.findSuitable(cls, (TargetObject)obj).thenCompose(t -> (CompletionStage)func.apply((TargetObject)t))).exceptionally(DebuggerResources.showError(this.getComponent(), errorMsg));
        } else {
            TargetObject t2 = (TargetObject)cls.cast(obj);
            func.apply(t2).exceptionally(DebuggerResources.showError(this.getComponent(), errorMsg));
        }
    }

    public void performQuickLaunch(ActionContext context) {
        if (this.currentProgram == null) {
            return;
        }
        this.performAction(context, true, TargetLauncher.class, launcher -> launcher.launch(Map.of("args", this.currentProgram.getExecutablePath())), "Couldn't launch");
    }

    public void performLaunch(ActionContext context) {
        this.performAction(context, true, TargetLauncher.class, launcher -> {
            Map<String, ?> args;
            if (this.currentProgram != null) {
                String path = this.currentProgram.getExecutablePath();
                String cmdlineArgs = this.launchDialog.getMemorizedArgument("args", String.class);
                if (path != null) {
                    if (cmdlineArgs == null) {
                        this.launchDialog.setMemorizedArgument("args", String.class, path);
                    } else if (!cmdlineArgs.startsWith(path)) {
                        this.launchDialog.setMemorizedArgument("args", String.class, path);
                    }
                }
            }
            if ((args = this.launchDialog.promptArguments((Map<String, TargetMethod.ParameterDescription<?>>)launcher.getParameters())) == null) {
                return AsyncUtils.NIL;
            }
            return launcher.launch(args);
        }, "Couldn't launch");
    }

    public void performAttach(ActionContext context) {
        TargetObject obj = this.getObjectFromContext(context);
        this.performAction(context, false, TargetAttacher.class, attacher -> {
            this.attachDialog.setAttacher((TargetAttacher)attacher);
            if (obj instanceof TargetAttachable) {
                return attacher.attach((TargetAttachable)obj);
            }
            this.attachDialog.fetchAndDisplayAttachable();
            this.tool.showDialog((DialogComponentProvider)this.attachDialog);
            return AsyncUtils.NIL;
        }, "Couldn't attach");
    }

    public void performReattach(ActionContext context) {
        TargetObject obj = this.getObjectFromContext(context);
        if (!(obj instanceof TargetAttachable)) {
            return;
        }
        ((CompletableFuture)DebugModelConventions.findSuitable(TargetAttacher.class, (TargetObject)obj).thenCompose(attacher -> attacher.attach((TargetAttachable)obj))).exceptionally(DebuggerResources.showError(this.getComponent(), "Couldn't re-attach"));
    }

    public void startRecording(TargetProcess targetObject, boolean prompt) {
        TraceRecorder rec = prompt ? this.modelService.recordTargetPromptOffers((TargetObject)targetObject) : this.modelService.recordTargetBestOffer((TargetObject)targetObject);
        if (rec == null) {
            return;
        }
        Trace trace = rec.getTrace();
        this.traceManager.openTrace(trace);
        this.traceManager.activateTrace(trace);
    }

    public void stopRecording(TargetObject targetObject) {
        TraceRecorder rec = this.modelService.getRecorderForSuccessor(targetObject);
        if (rec != null) {
            rec.stopRecording();
        }
    }

    public void performDetach(ActionContext context) {
        this.performAction(context, false, TargetDetachable.class, TargetDetachable::detach, "Couldn't detach");
    }

    public void performKill(ActionContext context) {
        this.performAction(context, false, TargetKillable.class, TargetKillable::kill, "Couldn't kill");
    }

    public void performStartRecording(ActionContext context) {
        this.performAction(context, false, TargetProcess.class, proc -> {
            TargetProcess valid = DebugModelConventions.liveProcessOrNull((TargetObject)proc);
            if (valid != null) {
                this.startRecording(valid, true);
            }
            return AsyncUtils.NIL;
        }, "Couldn't record");
    }

    public void performResume(ActionContext context) {
        this.performAction(context, false, TargetResumable.class, TargetResumable::resume, "Couldn't resume");
    }

    public void performInterrupt(ActionContext context) {
        this.performAction(context, false, TargetInterruptible.class, TargetInterruptible::interrupt, "Couldn't interrupt");
    }

    public void performStepInto(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, TargetSteppable::step, "Couldn't step into");
    }

    public void performStepOver(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> s.step(TargetSteppable.TargetStepKind.OVER), "Couldn't step over");
    }

    public void performStepFinish(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> s.step(TargetSteppable.TargetStepKind.FINISH), "Couldn't step finish");
    }

    public void performStepLast(ActionContext context) {
        this.performAction(context, false, TargetSteppable.class, s -> {
            if (this.extendedStep.equals("")) {
                return s.step(TargetSteppable.TargetStepKind.EXTENDED);
            }
            return s.step(Map.of("Command", this.extendedStep));
        }, "Couldn't step extended(" + this.extendedStep + ")");
    }

    public void performSetBreakpoint(ActionContext context) {
        this.performAction(context, false, TargetBreakpointSpecContainer.class, container -> {
            this.breakpointDialog.setContainer((TargetBreakpointSpecContainer)container);
            this.tool.showDialog((DialogComponentProvider)this.breakpointDialog);
            return AsyncUtils.NIL;
        }, "Couldn't set breakpoint");
    }

    public void performToggle(ActionContext context) {
        this.performAction(context, false, TargetTogglable.class, t -> t.toggle(!t.isEnabled()), "Couldn't toggle");
    }

    public void performConfigure(ActionContext context) {
        this.performAction(context, false, TargetConfigurable.class, configurable -> {
            Map configParameters = configurable.getConfigurableOptions();
            if (configParameters.isEmpty()) {
                return AsyncUtils.NIL;
            }
            Map<String, ?> args = this.configDialog.promptArguments(configParameters);
            if (args == null) {
                return AsyncUtils.NIL;
            }
            AsyncFence fence = new AsyncFence();
            for (Map.Entry<String, ?> entry : args.entrySet()) {
                fence.include(configurable.writeConfigurationOption(entry.getKey(), entry.getValue()));
            }
            return fence.ready();
        }, "Couldn't configure one or more options");
    }

    public void initiateConsole(ActionContext context) {
        this.performAction(context, false, TargetInterpreter.class, interpreter -> {
            this.getPlugin().showConsole((TargetInterpreter)interpreter);
            return AsyncUtils.NIL;
        }, "Couldn't show interpreter");
    }

    public boolean isStopped(ActionContext context) {
        TargetObject object = this.getObjectFromContext(context);
        if (object == null) {
            return false;
        }
        if (this.ignoreState) {
            return true;
        }
        if (this.isLocalOnly()) {
            if (object instanceof TargetExecutionStateful) {
                TargetExecutionStateful stateful = (TargetExecutionStateful)object;
                TargetExecutionStateful.TargetExecutionState executionState = stateful.getExecutionState();
                return !executionState.equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING);
            }
            return false;
        }
        TargetObject result = null;
        try {
            result = (TargetObject)DebugModelConventions.findSuitable(TargetExecutionStateful.class, (TargetObject)object).get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception executionState) {
            // empty catch block
        }
        if (result != null) {
            TargetExecutionStateful stateful = (TargetExecutionStateful)result;
            TargetExecutionStateful.TargetExecutionState executionState = stateful.getExecutionState();
            return !executionState.equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING);
        }
        return false;
    }

    public void setFocus(TargetObject object, TargetObject focused) {
        if (focused.getModel() != this.currentModel) {
            return;
        }
        this.pane.setFocus(object, focused);
    }

    public DebuggerTraceManagerService getTraceManager() {
        return this.traceManager;
    }

    public boolean isHideIntrinsics() {
        return this.hideIntrinsics;
    }

    public void setHideIntrinsics(boolean hideIntrinsics) {
        this.hideIntrinsics = hideIntrinsics;
    }

    public boolean isLocalOnly() {
        return this.selectionOnly;
    }

    public void setLocalOnly(boolean localOnly) {
        this.selectionOnly = localOnly;
    }

    public Color getColor(String name) {
        switch (name) {
            case "Object Colors.Accessors": {
                return this.accessorForegroundColor;
            }
            case "Object Colors.Background": {
                return this.defaultBackgroundColor;
            }
            case "Object Colors.Default": {
                return this.defaultForegroundColor;
            }
            case "Object Colors.Errors": {
                return this.errorForegroundColor;
            }
            case "Object Colors.Intrinsics": {
                return this.intrinsicForegroundColor;
            }
            case "Object Colors.Invisible (when toggled on)": {
                return this.invisibleForegroundColor;
            }
            case "Object Colors.Invalidated": {
                return this.invalidatedForegroundColor;
            }
            case "Object Colors.Modifed": {
                return this.modifiedForegroundColor;
            }
            case "Object Colors.Subscribed": {
                return this.subscribedForegroundColor;
            }
            case "Object Colors.Links": {
                return this.linkForegroundColor;
            }
            case "Object Colors.Targets": {
                return this.targetForegroundColor;
            }
        }
        return Color.BLACK;
    }

    public boolean isAutorecord() {
        return this.autoRecord;
    }

    public void setAutorecord(boolean autorecord) {
        this.autoRecord = autorecord;
    }

    public void updateActions(ObjectContainer providerContainer) {
        TargetObject obj = this.getSelectedObject();
        if (obj != null) {
            this.actionToggleSubscribe.setEnabled(true);
            this.actionToggleSubscribe.setSelected(providerContainer.isSubscribed());
            MenuData menuData = this.actionToggleSubscribe.getMenuBarData();
            if (menuData != null) {
                menuData.setMenuPath(new String[]{"Subscribe to '" + obj.getDisplay() + "'"});
            }
        } else {
            this.actionToggleSubscribe.setEnabled(false);
            this.actionToggleSubscribe.setSelected(false);
            MenuData menuData = this.actionToggleSubscribe.getMenuBarData();
            if (menuData != null) {
                menuData.setMenuPath(new String[]{"Subscribe"});
            }
        }
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
        this.launchDialog.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionToggleAutoRecord.setSelected(this.autoRecord);
        this.actionToggleHideIntrinsics.setSelected(this.hideIntrinsics);
        this.actionToggleSelectionOnly.setSelected(this.selectionOnly);
        this.launchDialog.readConfigState(saveState);
    }

    public void componentActivated() {
        if (this.currentTrace != null && !this.isActive()) {
            this.traceManager.activateTrace(this.currentTrace);
        }
    }

    public DebuggerModelService getModelService() {
        return this.modelService;
    }

    public DebuggerListingService getListingService() {
        return this.listingService;
    }

    public DebuggerModelListener getListener() {
        return (DebuggerModelListener)this.listener.queue.in;
    }

    class MyObjectListener
    extends AnnotatedDebuggerAttributeListener {
        protected final DebuggerCallbackReorderer reorderer;
        protected final PrivatelyQueuedListener<DebuggerModelListener> queue;

        public MyObjectListener() {
            super(MethodHandles.lookup());
            this.reorderer = new DebuggerCallbackReorderer((DebuggerModelListener)this);
            this.queue = new PrivatelyQueuedListener(DebuggerModelListener.class, "ObjectsProvider-EventQueue", (Object)this.reorderer);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_accessible")
        public void accessibilityChanged(TargetObject object, boolean accessible) {
            DebuggerObjectsProvider.this.plugin.getTool().contextChanged((ComponentProvider)DebuggerObjectsProvider.this);
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel channel, String out) {
            System.err.println("consoleOutput: " + out);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_display")
        public void displayChanged(TargetObject object, String display) {
            if (ObjectContainer.visibleByDefault(object.getName())) {
                DebuggerObjectsProvider.this.pane.signalDataChanged(DebuggerObjectsProvider.this.getContainerByPath(object.getPath()));
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_modified")
        public void modifiedChanged(TargetObject object, boolean modified) {
            if (ObjectContainer.visibleByDefault(object.getName())) {
                DebuggerObjectsProvider.this.pane.signalDataChanged(DebuggerObjectsProvider.this.getContainerByPath(object.getPath()));
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
        public void executionStateChanged(TargetObject object, TargetExecutionStateful.TargetExecutionState state) {
            DebuggerObjectsProvider.this.plugin.getTool().contextChanged((ComponentProvider)DebuggerObjectsProvider.this);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
        public void focusChanged(TargetObject object, TargetObject focused) {
            DebuggerObjectsProvider.this.plugin.setFocus(object, focused);
            DebuggerObjectsProvider.this.plugin.getTool().contextChanged((ComponentProvider)DebuggerObjectsProvider.this);
        }

        public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
        }

        public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
            System.err.println("memoryReadError");
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_prompt")
        public void promptChanged(TargetObject interpreter, String prompt) {
        }

        public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
            Map cachedElements = bank.getCachedElements();
            for (String key : cachedElements.keySet()) {
                TargetObject ref = (TargetObject)cachedElements.get(key);
                this.displayChanged(ref, "registersUpdated");
            }
            Map cachedAttributes = bank.getCachedAttributes();
            for (String key : cachedAttributes.keySet()) {
                Object obj = cachedAttributes.get(key);
                if (!(obj instanceof TargetObject)) continue;
                this.displayChanged((TargetObject)obj, "registersUpdated");
            }
        }

        public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            ObjectContainer container;
            ObjectContainer objectContainer = container = parent == null ? null : DebuggerObjectsProvider.this.getContainerByPath(parent.getPath());
            if (container != null) {
                container.augmentElements(removed, added);
                boolean visibleChange = false;
                for (String key : removed) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                for (String key : added.keySet()) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                if (visibleChange) {
                    container.propagateProvider(DebuggerObjectsProvider.this);
                    DebuggerObjectsProvider.this.update(container);
                    DebuggerObjectsProvider.this.getComponent().repaint();
                }
            }
        }

        public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
            TargetProcess proc;
            ObjectContainer container;
            super.attributesChanged(parent, removed, added);
            ObjectContainer objectContainer = container = parent == null ? null : DebuggerObjectsProvider.this.getContainerByPath(parent.getPath());
            if (container != null) {
                container.augmentAttributes(removed, added);
                boolean visibleChange = false;
                for (String key : removed) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                for (String key : added.keySet()) {
                    visibleChange |= ObjectContainer.visibleByDefault(key);
                }
                if (visibleChange) {
                    container.propagateProvider(DebuggerObjectsProvider.this);
                    DebuggerObjectsProvider.this.update(container);
                    DebuggerObjectsProvider.this.getComponent().repaint();
                }
            }
            if (parent != null && DebuggerObjectsProvider.this.isAutorecord() && parent.getCachedAttribute("_state") != null && (proc = DebugModelConventions.liveProcessOrNull((TargetObject)parent)) != null) {
                DebuggerObjectsProvider.this.startRecording(proc, false);
            }
        }
    }

    class ObjectActionContext
    extends ActionContext {
        private DebuggerObjectsProvider provider;

        ObjectActionContext(DebuggerObjectsProvider provider) {
            super((ComponentProvider)provider);
            this.provider = provider;
        }

        public Object getContextObject() {
            return this.provider.getContextObject();
        }
    }
}

