/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DbgDebuggerProgramLaunchOpinion
implements DebuggerProgramLaunchOpinion {
    @Override
    public Collection<DebuggerProgramLaunchOffer> getOffers(Program program, PluginTool tool, DebuggerModelService service) {
        String exe = program.getExecutablePath();
        if (exe == null || "".equals(exe.trim())) {
            return List.of();
        }
        ArrayList<DebuggerProgramLaunchOffer> offers = new ArrayList<DebuggerProgramLaunchOffer>();
        for (DebuggerModelFactory factory : service.getModelFactories()) {
            if (!factory.isCompatible()) continue;
            String clsName = factory.getClass().getName();
            if (clsName.equals("agent.dbgeng.DbgEngInJvmDebuggerModelFactory")) {
                offers.add(new InVmDbgengDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (clsName.equals("agent.dbgeng.gadp.DbgEngLocalDebuggerModelFactory")) {
                offers.add(new GadpDbgengDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (clsName.equals("agent.dbgmodel.DbgModelInJvmDebuggerModelFactory")) {
                offers.add(new InVmDbgmodelDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (!clsName.equals("agent.dbgmodel.gadp.DbgModelLocalDebuggerModelFactory")) continue;
            offers.add(new GadpDbgmodelDebuggerProgramLaunchOffer(program, tool, factory));
        }
        return offers;
    }

    protected class GadpDbgmodelDebuggerProgramLaunchOffer
    extends AbstractDbgDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.dbgmodel.gadp.DbgModelLocalDebuggerModelFactory";

        public GadpDbgmodelDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP dbgmodel";
        }

        @Override
        public String getMenuTitle() {
            return "in dbgmodel locally via GADP";
        }
    }

    protected class InVmDbgmodelDebuggerProgramLaunchOffer
    extends AbstractDbgDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.dbgmodel.DbgModelInJvmDebuggerModelFactory";

        public InVmDbgmodelDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM dbgmodel";
        }

        @Override
        public String getMenuTitle() {
            return "in dbgmodel locally IN-VM";
        }
    }

    protected class GadpDbgengDebuggerProgramLaunchOffer
    extends AbstractDbgDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.dbgeng.gadp.DbgEngLocalDebuggerModelFactory";

        public GadpDbgengDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP dbgeng";
        }

        @Override
        public String getMenuTitle() {
            return "in dbgeng locally via GADP";
        }
    }

    protected class InVmDbgengDebuggerProgramLaunchOffer
    extends AbstractDbgDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.dbgeng.DbgEngInJvmDebuggerModelFactory";

        public InVmDbgengDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM dbgeng";
        }

        @Override
        public String getMenuTitle() {
            return "in dbgeng locally IN-VM";
        }
    }

    protected static abstract class AbstractDbgDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractDbgDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getMenuParentTitle() {
            return "Debug " + this.program.getName();
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"");
        }

        @Override
        protected Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
            return Map.of("args", this.program.getExecutablePath());
        }
    }
}

