/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.async.AsyncUtils;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class AsyncWrappedPcodeExecutorStatePiece<A, T>
implements PcodeExecutorStatePiece<CompletableFuture<A>, CompletableFuture<T>> {
    protected final PcodeExecutorStatePiece<A, T> state;
    private CompletableFuture<?> lastWrite = AsyncUtils.NIL;

    public AsyncWrappedPcodeExecutorStatePiece(PcodeExecutorStatePiece<A, T> state) {
        this.state = state;
    }

    protected boolean isWriteDone() {
        return this.lastWrite.isDone();
    }

    protected <U> CompletableFuture<U> nextRead(Supplier<CompletableFuture<U>> next) {
        return ((CompletableFuture)this.lastWrite.thenCompose(__ -> (CompletionStage)next.get())).exceptionally(ex -> null);
    }

    protected <U> void nextWrite(Supplier<CompletableFuture<U>> next) {
        this.lastWrite = this.nextRead(next);
    }

    protected CompletableFuture<?> doSetVar(AddressSpace space, CompletableFuture<A> offset, int size, boolean truncateAddressableUnit, CompletableFuture<T> val) {
        return offset.thenCompose(off -> val.thenAccept(v -> this.state.setVar(space, off, size, truncateAddressableUnit, v)));
    }

    public void setVar(AddressSpace space, CompletableFuture<A> offset, int size, boolean truncateAddressableUnit, CompletableFuture<T> val) {
        this.nextWrite(() -> this.doSetVar(space, offset, size, truncateAddressableUnit, val));
    }

    protected CompletableFuture<T> doGetVar(AddressSpace space, CompletableFuture<A> offset, int size, boolean truncateAddressableUnit) {
        return offset.thenApply(off -> this.state.getVar(space, off, size, truncateAddressableUnit));
    }

    public CompletableFuture<T> getVar(AddressSpace space, CompletableFuture<A> offset, int size, boolean truncateAddressableUnit) {
        return this.nextRead(() -> this.doGetVar(space, offset, size, truncateAddressableUnit));
    }

    public CompletableFuture<A> longToOffset(AddressSpace space, long l) {
        return CompletableFuture.completedFuture(this.state.longToOffset(space, l));
    }

    public MemBuffer getConcreteBuffer(Address address) {
        if (!this.isWriteDone()) {
            throw new AssertionError((Object)"An async write is still pending");
        }
        return this.state.getConcreteBuffer(address);
    }
}

