/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PathPattern
implements PathPredicates {
    private final List<String> pattern;

    public PathPattern(List<String> pattern) {
        this.pattern = List.copyOf(pattern);
    }

    public String toString() {
        return String.format("<PathPattern %s>", PathUtils.toString(this.pattern));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathPattern)) {
            return false;
        }
        PathPattern that = (PathPattern)obj;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public static boolean isWildcard(String pat) {
        return "[]".equals(pat) || "".equals(pat);
    }

    public static boolean keyMatches(String pat, String key) {
        if (key.equals(pat)) {
            return true;
        }
        if ("[]".equals(pat) && PathUtils.isIndex(key)) {
            return true;
        }
        return "".equals(pat) && PathUtils.isName(key);
    }

    protected boolean matchesUpTo(List<String> path, int length) {
        for (int i = 0; i < length; ++i) {
            if (PathPattern.keyMatches(this.pattern.get(i), path.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(List<String> path) {
        if (path.size() != this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean successorCouldMatch(List<String> path, boolean strict) {
        if (path.size() > this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean ancestorMatches(List<String> path, boolean strict) {
        if (path.size() < this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, this.pattern.size());
    }

    protected static boolean containsWildcards(List<String> pattern) {
        for (String pat : pattern) {
            if (!PathPattern.isWildcard(pat)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getSingletonPath() {
        if (PathPattern.containsWildcards(this.pattern)) {
            return null;
        }
        return this.pattern;
    }

    public int countWildcards() {
        return (int)this.pattern.stream().filter(k -> PathPattern.isWildcard(k)).count();
    }

    @Override
    public PathPattern getSingletonPattern() {
        return this;
    }

    @Override
    public Set<String> getNextNames(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        String pat = this.pattern.get(path.size());
        if (PathUtils.isName(pat)) {
            return Set.of(pat);
        }
        return Set.of();
    }

    @Override
    public Set<String> getNextIndices(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        String pat = this.pattern.get(path.size());
        if (PathUtils.isIndex(pat)) {
            return Set.of(PathUtils.parseIndex(pat));
        }
        return Set.of();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public PathPattern applyIndices(List<String> indices) {
        ArrayList<String> result = new ArrayList<String>(this.pattern.size());
        Iterator<String> it = indices.iterator();
        for (String pat : this.pattern) {
            if (it.hasNext() && PathPattern.isWildcard(pat)) {
                String index = it.next();
                if (PathUtils.isIndex(pat)) {
                    result.add(PathUtils.makeKey(index));
                    continue;
                }
                result.add(index);
                continue;
            }
            result.add(pat);
        }
        return new PathPattern(result);
    }

    public List<String> matchIndices(List<String> path) {
        int length = this.pattern.size();
        if (length != path.size()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String key;
            String pat = this.pattern.get(i);
            if (!PathPattern.keyMatches(pat, key = path.get(i))) {
                return null;
            }
            if (!PathPattern.isWildcard(pat)) continue;
            if (PathUtils.isIndex(pat)) {
                result.add(PathUtils.parseIndex(key));
                continue;
            }
            result.add(key);
        }
        return result;
    }
}

