/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import java.util.ArrayList;
import java.util.List;

public class ShellUtils {
    public static List<String> parseArgs(String args) {
        ArrayList<String> argsList = new ArrayList<String>();
        StringBuilder curArg = new StringBuilder();
        State state = State.NORMAL;
        block27: for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            switch (state) {
                case NORMAL: {
                    switch (c) {
                        case '\\': {
                            state = State.NORMAL_ESCAPE;
                            continue block27;
                        }
                        case '\"': {
                            state = State.DQUOTE;
                            continue block27;
                        }
                        case '\'': {
                            state = State.SQUOTE;
                            continue block27;
                        }
                        case ' ': {
                            argsList.add(curArg.toString());
                            curArg.setLength(0);
                            continue block27;
                        }
                    }
                    curArg.append(c);
                    continue block27;
                }
                case NORMAL_ESCAPE: {
                    curArg.append(c);
                    state = State.NORMAL;
                    continue block27;
                }
                case DQUOTE: {
                    switch (c) {
                        case '\\': {
                            state = State.DQUOTE_ESCAPE;
                            continue block27;
                        }
                        case '\"': {
                            state = State.NORMAL;
                            continue block27;
                        }
                    }
                    curArg.append(c);
                    continue block27;
                }
                case DQUOTE_ESCAPE: {
                    curArg.append(c);
                    state = State.DQUOTE;
                    continue block27;
                }
                case SQUOTE: {
                    switch (c) {
                        case '\\': {
                            state = State.SQUOTE_ESCAPE;
                            break;
                        }
                        case '\'': {
                            state = State.NORMAL;
                            break;
                        }
                        default: {
                            curArg.append(c);
                        }
                    }
                }
                case SQUOTE_ESCAPE: {
                    curArg.append(c);
                    state = State.SQUOTE;
                    continue block27;
                }
                default: {
                    throw new AssertionError((Object)"Shouldn't be here!");
                }
            }
        }
        switch (state) {
            case NORMAL: {
                if (curArg.length() == 0) break;
                argsList.add(curArg.toString());
                break;
            }
            case DQUOTE: 
            case SQUOTE: {
                throw new IllegalArgumentException("Unterminated string");
            }
            case NORMAL_ESCAPE: 
            case DQUOTE_ESCAPE: 
            case SQUOTE_ESCAPE: {
                throw new IllegalArgumentException("Incomplete escaped character");
            }
            default: {
                throw new AssertionError((Object)"Shouldn't be here!");
            }
        }
        return argsList;
    }

    public static String generateLine(List<String> args) {
        if (args.isEmpty()) {
            return "";
        }
        StringBuilder line = new StringBuilder(args.get(0));
        for (int i = 1; i < args.size(); ++i) {
            String a = args.get(i);
            if (a.contains(" ")) {
                if (a.contains("\"")) {
                    if (a.contains("'")) {
                        line.append(" \"");
                        line.append(a.replace("\"", "\\\""));
                        line.append("\"");
                        continue;
                    }
                    line.append(" '");
                    line.append(a);
                    line.append("'");
                    continue;
                }
                line.append(" \"");
                line.append(a);
                line.append("\"");
                continue;
            }
            line.append(" ");
            line.append(a);
        }
        return line.toString();
    }

    static enum State {
        NORMAL,
        NORMAL_ESCAPE,
        DQUOTE,
        DQUOTE_ESCAPE,
        SQUOTE,
        SQUOTE_ESCAPE;

    }
}

